/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.messages;

import com.tridium.ccn.BCcnDevice;
import com.tridium.ccn.BCcnDeviceFolder;
import com.tridium.ccn.BCcnNetwork;
import com.tridium.ccn.components.BCcnControllerEntry;
import com.tridium.ccn.components.BCcnControllerList;
import com.tridium.ccn.components.BCcnTableEntry;
import com.tridium.ccn.components.BCcnTableList;
import com.tridium.ccn.enums.BCcnDeviceTypeEnum;
import com.tridium.ccn.exceptions.CcnException;
import com.tridium.ccn.job.BCcnAddDevicesJob;
import com.tridium.ccn.messages.CcnCreateTablesRequest;
import com.tridium.ccn.messages.CcnFetchDeviceDataRequest;
import com.tridium.ccn.messages.CcnLearnDeviceRequest;
import com.tridium.ccn.messages.CcnMessageConst;
import com.tridium.ccn.util.AsynchronousRequest;
import com.tridium.ccn.util.CcnUtil;
import com.tridium.ccn.util.TargetNameContainer;
import com.tridium.util.ObjectUtil;
import java.util.HashMap;
import java.util.Vector;
import javax.baja.job.BJobState;
import javax.baja.log.Log;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.LocalizableRuntimeException;

public class CcnCreateDevicesRequest
implements AsynchronousRequest,
CcnMessageConst {
    private BCcnControllerList controllerList;
    private BCcnNetwork network;
    private BCcnDevice device = null;
    private BCcnDeviceFolder deviceFolder;
    private Vector<BCcnDevice> controllersAdded;
    private BCcnAddDevicesJob job = null;
    Log ccnMessageLog = Log.getLog((String)"CCNMessagesLog");

    public CcnCreateDevicesRequest(BCcnNetwork network, BCcnDeviceFolder deviceFolder, BCcnControllerList controllerList, BCcnAddDevicesJob job) {
        this.controllerList = controllerList;
        this.network = network;
        this.deviceFolder = deviceFolder;
        this.job = job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        if (!this.network.isNetworkStatusOk()) {
            throw new LocalizableRuntimeException("ccn", "CcnCreateDevice.add");
        }
        this.network.setLearnStatus("Create-> Start create process... disable deviceStatus and polling");
        this.job.log().message("Create-> Start create process... disable deviceStatus and polling");
        try {
            BCcnControllerEntry[] controllers = this.controllerList.getControllerList();
            this.controllersAdded = new Vector();
            this.ccnMessageLog.trace("CreateDeviceRequest...." + controllers.length);
            for (int i = 0; i < controllers.length; ++i) {
                BCcnControllerEntry controller = controllers[i];
                int busNum = controller.getBusNo();
                int controllerNum = controller.getElemNo();
                if (this.job != null) {
                    this.job.progress((100 * i + 1) / (controllers.length + 1));
                }
                if (!(this.job == null || this.job.isAlive() && this.job.getJobState() != BJobState.canceled)) {
                    this.job.setJobState(BJobState.canceled);
                    break;
                }
                BCcnDevice existingDevice = CcnUtil.findCcnDevice((BComponent)this.network, busNum, controllerNum);
                String deviceName = controller.getDevName().trim();
                this.ccnMessageLog.trace("<CcnCreateDevicesRequest: nam: " + deviceName + " device found: " + (Object)((Object)existingDevice));
                if (deviceName.length() == 0) {
                    deviceName = "D";
                }
                if (!Character.isLetter(deviceName.charAt(0))) {
                    deviceName = "D_" + deviceName;
                }
                deviceName = CcnUtil.makeValidName(deviceName);
                boolean isNewDevice = false;
                if (existingDevice == null) {
                    isNewDevice = true;
                    this.device = new BCcnDevice(controller);
                    this.controllersAdded.addElement(this.device);
                    String deviceDefault = ObjectUtil.generateUniqueName((String)deviceName, (ObjectUtil.NameContainer)new TargetNameContainer((BComponent)this.network, new HashMap<String, BComponent>()));
                    if (this.deviceFolder != null) {
                        this.deviceFolder.add(deviceName, (BValue)this.device);
                    } else {
                        this.network.add(deviceDefault, (BValue)this.device);
                    }
                } else {
                    this.device = existingDevice;
                }
                this.ccnMessageLog.trace("<CcnCreateDevicesRequest: " + deviceName + " isNewDevice=" + isNewDevice + ">");
                if (isNewDevice) {
                    if (!this.device.isDeviceFID()) {
                        this.device.setStatusDisplay(this.device.getLrnStaDspPic11());
                        this.device.setSetPoints(this.device.getLrnSetPtsPic17() || this.device.getLrnSetPtsPoc18());
                        this.device.setTimeSchedules(this.device.getLrnTimSchDTT614() || this.device.getLrnUsrCfgPoc14());
                        this.device.setAlarmHistory(this.device.getLrnAlmHstPic43());
                        if (this.device.getIsEnhancedVersion()) {
                            this.device.setUserConfiguration(this.device.getLrnUsrCfgPic10() || this.device.getLrnUsrCfgPoc14());
                            this.device.setMaintenance(this.device.getLrnMaintPic12() || this.device.getLrnMaintPoc15());
                            this.device.setServiceConfiguration(this.device.getLrnSvcCfgPic13() || this.device.getLrnSvcCfgPoc16());
                        } else {
                            this.device.setUserConfiguration(false);
                            this.device.setMaintenance(false);
                            this.device.setServiceConfiguration(false);
                            this.device.setFlags(this.device.getSlot("userConfiguration"), 1);
                            this.device.setFlags(this.device.getSlot("maintenance"), 1);
                            this.device.setFlags(this.device.getSlot("serviceConfiguration"), 1);
                        }
                    } else {
                        this.device.setStatusDisplay(this.device.getLrnStaDspTT500());
                        this.device.setSetPoints(this.device.getLrnSetPtsTT504());
                        this.device.setTimeSchedules(this.device.getLrnTimSchTT503());
                        this.device.setHoliday(this.device.getLrnHolSchTT505());
                        this.device.setFlags(this.device.getSlot("alarmHistory"), 4);
                        this.device.setFlags(this.device.getSlot("userConfiguration"), 4);
                        this.device.setFlags(this.device.getSlot("maintenance"), 4);
                        this.device.setFlags(this.device.getSlot("serviceConfiguration"), 4);
                    }
                    this.network.setDiscoveryInProgress(true);
                    this.device.setBusNo(busNum);
                    this.device.setElemNo(controllerNum);
                    this.device.setDeviceName(controller.getDevName().trim());
                    this.device.setDeviceType(BCcnDeviceTypeEnum.make(controller.getDevType()));
                    CcnFetchDeviceDataRequest ccnFDDR = new CcnFetchDeviceDataRequest(this.device, this.network, controllerNum, busNum);
                    try {
                        ccnFDDR.fetchBlock3();
                        ccnFDDR.fetchBlock4();
                        ccnFDDR.fetchBlock6();
                    }
                    catch (CcnException e) {
                        this.ccnMessageLog.error("<CcnCreateDevicesRequest: ERROR: " + (Object)((Object)e));
                        e.printStackTrace();
                        continue;
                    }
                }
                if (!this.network.getCreateTables()) continue;
                BCcnDevice[] newControllers = new BCcnDevice[this.controllersAdded.size()];
                this.controllersAdded.copyInto((Object[])newControllers);
                for (int j = 0; j < newControllers.length; ++j) {
                    BCcnDevice newController = newControllers[j];
                    CcnLearnDeviceRequest lreq = new CcnLearnDeviceRequest(newController);
                    lreq.execute();
                    BCcnTableEntry[] learnedTables = (BCcnTableEntry[])newController.getLearnedTables().getChildren(BCcnTableEntry.class);
                    BCcnTableList tableList = new BCcnTableList(learnedTables);
                    CcnCreateTablesRequest creq = new CcnCreateTablesRequest(this.network, newController, tableList, null);
                    creq.execute();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.network.setLearnStatus("Create-> Complete");
            this.job.log().message("Create-> Complete");
            this.network.setLearnStatus("Idle");
        }
    }
}

