/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.messages;

import com.tridium.ccn.BCcnDevice;
import com.tridium.ccn.exceptions.CcnException;
import com.tridium.ccn.exceptions.CcnRuntimeException;
import com.tridium.ccn.messages.CcnReadTableRequest;
import com.tridium.ccn.messages.CcnResponseMessage;
import com.tridium.ccn.messages.CcnWriteTableRequest;
import com.tridium.ccn.util.AsynchronousRequest;
import com.tridium.platCcn.CcnTableDef;
import javax.baja.log.Log;

public class CcnChangeBaudRateRequest
implements AsynchronousRequest {
    private BCcnDevice device = null;
    private Integer primaryBaudRate = null;
    private Integer secondaryBaudRate = null;
    private static boolean PRIMARY_BAUD_RATE = true;
    private static boolean SECONDARY_BAUD_RATE = false;
    Log ccnMessageLog = Log.getLog((String)"CCNMessagesLog");

    public static boolean isSupportedBaudRate(int queryBaudRate) {
        switch (queryBaudRate) {
            case 9600: 
            case 19200: 
            case 38400: {
                return true;
            }
        }
        return false;
    }

    public CcnChangeBaudRateRequest(BCcnDevice newDevice, int newPrimaryBaudRate) {
        this(newDevice, new Integer(newPrimaryBaudRate), null);
    }

    public CcnChangeBaudRateRequest(BCcnDevice newDevice, int newPrimaryBaudRate, int newSecondaryBaudRate) {
        this(newDevice, new Integer(newPrimaryBaudRate), new Integer(newSecondaryBaudRate));
    }

    public CcnChangeBaudRateRequest(BCcnDevice newDevice, Integer newPrimaryBaudRate, Integer newSecondaryBaudRate) {
        this.device = newDevice;
        boolean bError = false;
        String sError = "";
        try {
            this.setBaudRate(newPrimaryBaudRate, PRIMARY_BAUD_RATE);
        }
        catch (CcnRuntimeException ccnRE) {
            if (ccnRE.getCode() == 6488274) {
                bError = true;
                sError = sError + "\nThe proposed new primary baud rate, " + newPrimaryBaudRate + " is not supported.";
            }
            throw ccnRE;
        }
        try {
            this.setBaudRate(newSecondaryBaudRate, SECONDARY_BAUD_RATE);
        }
        catch (CcnRuntimeException ccnRE) {
            if (ccnRE.getCode() == 6488274) {
                bError = true;
                sError = sError + "\nThe proposed new secondary baud rate, " + newSecondaryBaudRate + " is not supported.";
            }
            throw ccnRE;
        }
        if (bError) {
            throw new CcnRuntimeException(6488274, sError);
        }
    }

    private void setBaudRate(Integer newBaudRate, boolean baudRateIsPrimaryAsOpposedToSecondary) {
        if (newBaudRate != null && !CcnChangeBaudRateRequest.isSupportedBaudRate(newBaudRate)) {
            throw new CcnRuntimeException(6488274, "Baud rate not supported");
        }
        if (baudRateIsPrimaryAsOpposedToSecondary) {
            this.primaryBaudRate = newBaudRate;
        } else {
            this.secondaryBaudRate = newBaudRate;
        }
    }

    private void validateBaudRateRsp(CcnResponseMessage baudRateRsp, int errorCodeIfUnsuccessful, String errorTxtIfUnsuccessful) throws CcnException {
        if (baudRateRsp == null || baudRateRsp.getResponseCommand() != 6) {
            throw new CcnException(errorCodeIfUnsuccessful, new String("Baud rate change error occurred " + errorTxtIfUnsuccessful + "."));
        }
    }

    private byte[] readBaudRateBlockData() throws CcnException {
        CcnReadTableRequest readBaudRateReq = new CcnReadTableRequest(new CcnTableDef((byte)this.device.getElemNo(), (byte)this.device.getBusNo(), null, 32, 1, 3, 0, 0));
        CcnResponseMessage readBaudRateRsp = this.device.getCcnNetwork().getCcnComm().ccnAsyncRequest().sendAsyncRequest(readBaudRateReq);
        this.validateBaudRateRsp(readBaudRateRsp, 6488177, "during initial baud rate read");
        return readBaudRateRsp.getData();
    }

    private void changeBaudRateInBuffer(byte[] blockData, int ovrBaud, boolean baudRateIsPrimaryAsOpposedToSecondary) {
        int baudMSB = baudRateIsPrimaryAsOpposedToSecondary ? 0 : 2;
        int baudLSB = baudRateIsPrimaryAsOpposedToSecondary ? 1 : 3;
        blockData[baudMSB] = (byte)((ovrBaud & 0xFF00) >> 8);
        blockData[baudLSB] = (byte)((ovrBaud & 0xFF) >> 0);
    }

    private void overwriteBaudRateTableBlock(byte[] newBaudRateData) throws CcnException {
        CcnWriteTableRequest writeBaudRateReq = new CcnWriteTableRequest(new CcnTableDef((byte)this.device.getElemNo(), (byte)this.device.getBusNo(), null, 32, 1, 3, (byte)newBaudRateData.length, 0), newBaudRateData);
        CcnResponseMessage writeBaudRateRsp = this.device.getCcnNetwork().getCcnComm().ccnAsyncRequest().sendAsyncRequest(writeBaudRateReq);
        this.validateBaudRateRsp(writeBaudRateRsp, 6488175, "writing new baud rate data");
    }

    @Override
    public void execute() {
        try {
            byte[] baudData = this.readBaudRateBlockData();
            if (this.primaryBaudRate != null) {
                this.changeBaudRateInBuffer(baudData, this.primaryBaudRate, PRIMARY_BAUD_RATE);
            }
            if (this.secondaryBaudRate != null) {
                this.changeBaudRateInBuffer(baudData, this.secondaryBaudRate, SECONDARY_BAUD_RATE);
            }
            if (this.primaryBaudRate != null || this.secondaryBaudRate != null) {
                this.overwriteBaudRateTableBlock(baudData);
            }
        }
        catch (Throwable t) {
            this.ccnMessageLog.trace(">CcnChangeBaudRateRequest: could not change baud rate(s).\n>Cause = " + t + ">Reason = " + t.getLocalizedMessage() + "\n>Stack Print = ");
            t.printStackTrace();
        }
    }
}

