/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.messages;

import com.tridium.ccn.BCcnNetwork;
import com.tridium.ccn.comm.CcnComm;
import com.tridium.ccn.messages.CcnAutoVariableRequest;
import com.tridium.ccn.messages.CcnChangeTableNameRequest;
import com.tridium.ccn.messages.CcnMessageConst;
import com.tridium.ccn.messages.CcnReadObjectDataRequest;
import com.tridium.ccn.messages.CcnReadTableRequest;
import com.tridium.ccn.messages.CcnReadVariableRequest;
import com.tridium.ccn.messages.CcnRequestMessage;
import com.tridium.ccn.messages.CcnResponseMessage;
import com.tridium.ccn.messages.CcnWriteTableRequest;
import com.tridium.ccn.messages.CcnWriteVariableRequest;
import com.tridium.ccn.util.AsynchronousRequest;
import com.tridium.ccn.util.AsynchronousRequestHelper;
import com.tridium.platCcn.CcnResponseBuffer;
import javax.baja.log.Log;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Clock;

public class CcnAsyncRequest
extends AsynchronousRequestHelper
implements CcnMessageConst {
    public CcnComm comm;
    public BCcnNetwork ccnNetwork;
    private static final Log ccnNetworkLog = Log.getLog((String)"CCNNetworkLog");

    public CcnAsyncRequest(CcnComm newComm, BCcnNetwork newCcnNetwork) {
        this.comm = newComm;
        this.ccnNetwork = newCcnNetwork;
    }

    @Override
    public String getName() {
        return "Ccn:AsyncRequest";
    }

    public CcnResponseMessage sendAsyncRequest(CcnRequestMessage msg) {
        return this.send(msg, true);
    }

    @Deprecated
    private CcnResponseMessage sendRequest(CcnRequestMessage msg) {
        return this.send(msg, false);
    }

    private synchronized CcnResponseMessage send(CcnRequestMessage msg, boolean async) {
        CcnSendRequest req = new CcnSendRequest(msg);
        req.execute();
        if (ccnNetworkLog.isTraceOn()) {
            ccnNetworkLog.trace(System.currentTimeMillis() + ": AsyncRequest sendRequest after execution, about to return");
        }
        return req.getResponse(0);
    }

    private static class CcnStopRequest
    implements AsynchronousRequest {
        private boolean complete = false;

        @Override
        public synchronized void execute() {
            this.complete = true;
            this.notify();
        }

        public synchronized void stop() {
            if (!this.complete) {
                try {
                    this.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private class CcnSendRequest
    implements AsynchronousRequest {
        private CcnRequestMessage reqMsg = null;
        private CcnResponseMessage response = null;
        private boolean complete = false;
        private int curBus;

        public CcnSendRequest(CcnRequestMessage newReqMsg) {
            this.reqMsg = newReqMsg;
        }

        @Override
        public synchronized void execute() {
            CcnResponseBuffer respBuf = null;
            CcnResponseMessage respMsg = null;
            try {
                if (this.reqMsg == null) {
                    return;
                }
                int retryCount = CcnAsyncRequest.this.ccnNetwork.getRetryCount();
                this.curBus = 0;
                if (this.reqMsg instanceof CcnReadTableRequest) {
                    this.curBus = ((CcnReadTableRequest)this.reqMsg).getTableDef().getBus();
                } else if (this.reqMsg instanceof CcnChangeTableNameRequest) {
                    this.curBus = ((CcnChangeTableNameRequest)this.reqMsg).getTableDef().getBus();
                } else if (this.reqMsg instanceof CcnWriteTableRequest) {
                    this.curBus = ((CcnWriteTableRequest)this.reqMsg).getTableDef().getBus();
                } else if (this.reqMsg instanceof CcnReadVariableRequest) {
                    this.curBus = ((CcnReadVariableRequest)this.reqMsg).getVarDef().getBus();
                } else if (this.reqMsg instanceof CcnWriteVariableRequest) {
                    this.curBus = ((CcnWriteVariableRequest)this.reqMsg).getVarDef().getBus();
                } else if (this.reqMsg instanceof CcnAutoVariableRequest) {
                    this.curBus = ((CcnAutoVariableRequest)this.reqMsg).getVarDef().getBus();
                } else if (this.reqMsg instanceof CcnReadObjectDataRequest) {
                    this.curBus = ((CcnReadObjectDataRequest)this.reqMsg).getObjDef().getBus();
                }
                int i = 0;
                int attempt = 1;
                while (i < retryCount + 1) {
                    long txTimeMillis = Clock.ticks();
                    if (ccnNetworkLog.isTraceOn()) {
                        ccnNetworkLog.trace("CCN Tx: " + txTimeMillis + " " + (Object)((Object)this.reqMsg));
                    }
                    respBuf = CcnAsyncRequest.this.comm.sendCcnRequest(this.reqMsg);
                    this.reqMsg.setPid((byte)-1);
                    if (!this.reqMsg.getResponseExpected() || respBuf != null && respBuf.isValidResponse()) break;
                    if (ccnNetworkLog.isTraceOn()) {
                        long toTimeTicks = Clock.ticks();
                        BAbsTime toTime = BAbsTime.make((long)System.currentTimeMillis());
                        ccnNetworkLog.trace("Date/Time is " + toTime + " CCN MessageTimeOut - " + toTimeTicks);
                    }
                    ++i;
                    ++attempt;
                }
                if (respBuf != null && respBuf.isValidResponse()) {
                    this.response = respMsg = this.reqMsg.toCcnResponse(respBuf);
                    this.complete = true;
                    this.notify();
                    return;
                }
                this.complete = true;
                this.notify();
                return;
            }
            catch (Exception e) {
                ccnNetworkLog.error("Exception during execution of CcnSendRequest", (Throwable)e);
                this.complete = true;
                this.notify();
                return;
            }
        }

        public synchronized CcnResponseMessage getResponse(int timeout) {
            if (!this.complete) {
                try {
                    this.wait(timeout);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return this.response;
        }
    }
}

