/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.comm;

import com.tridium.basicdriver.BBasicNetwork;
import com.tridium.basicdriver.comm.Comm;
import com.tridium.basicdriver.comm.CommReceiver;
import com.tridium.ccn.BCcnNetwork;
import com.tridium.ccn.exceptions.CcnException;
import com.tridium.ccn.exceptions.CcnRuntimeException;
import com.tridium.ccn.messages.CcnAsyncRequest;
import com.tridium.ccn.messages.CcnAutoVariableRequest;
import com.tridium.ccn.messages.CcnChangeTableNameRequest;
import com.tridium.ccn.messages.CcnReadObjectDataRequest;
import com.tridium.ccn.messages.CcnReadTableRequest;
import com.tridium.ccn.messages.CcnReadVariableRequest;
import com.tridium.ccn.messages.CcnRequestMessage;
import com.tridium.ccn.messages.CcnSendByteArrayRequest;
import com.tridium.ccn.messages.CcnWriteTableRequest;
import com.tridium.ccn.messages.CcnWriteVariableRequest;
import com.tridium.platCcn.CcnResponseBuffer;

public class CcnComm
extends Comm {
    BCcnNetwork ccnNetwork;
    private boolean driverStarted = false;
    private final CcnAsyncRequest ccnAsyncRequest;

    public CcnComm(BCcnNetwork network, CommReceiver commReceiver) {
        super((BBasicNetwork)network, commReceiver);
        this.ccnNetwork = network;
        this.ccnAsyncRequest = new CcnAsyncRequest(this, this.ccnNetwork);
        this.ccnAsyncRequest.init();
        this.ccnAsyncRequest.start();
    }

    public boolean started() throws Exception {
        this.driverStarted = true;
        return true;
    }

    public void stopped() throws Exception {
    }

    public final BCcnNetwork getCcnNetwork() {
        return this.ccnNetwork;
    }

    public CcnAsyncRequest ccnAsyncRequest() {
        return this.ccnAsyncRequest;
    }

    public synchronized CcnResponseBuffer sendCcnRequest(CcnRequestMessage requestMessage) throws CcnException {
        this.ccnNetwork.driverStarted = true;
        if (this.driverStarted) {
            return this.callProperNativeMethod(requestMessage);
        }
        throw new CcnException(6488165, "Cannot sendCcnRequest because CcnNativeDriver not started");
    }

    private CcnResponseBuffer callProperNativeMethod(CcnRequestMessage req) {
        if (req instanceof CcnReadTableRequest) {
            return this.ccnNetwork.ccnPlatSrvc.readTable(((CcnReadTableRequest)req).getTableDef());
        }
        if (req instanceof CcnChangeTableNameRequest) {
            return this.ccnNetwork.ccnPlatSrvc.changeTableName(((CcnChangeTableNameRequest)req).getTableDef());
        }
        if (req instanceof CcnWriteTableRequest) {
            return this.ccnNetwork.ccnPlatSrvc.writeTable(((CcnWriteTableRequest)req).getTableDef(), ((CcnWriteTableRequest)req).getWriteTableData());
        }
        if (req instanceof CcnReadVariableRequest) {
            return this.ccnNetwork.ccnPlatSrvc.readVariable(((CcnReadVariableRequest)req).getVarDef());
        }
        if (req instanceof CcnWriteVariableRequest) {
            return this.ccnNetwork.ccnPlatSrvc.writeVariable(((CcnWriteVariableRequest)req).getVarDef(), ((CcnWriteVariableRequest)req).getWriteVarValue());
        }
        if (req instanceof CcnAutoVariableRequest) {
            return this.ccnNetwork.ccnPlatSrvc.autoVariable(((CcnAutoVariableRequest)req).getVarDef());
        }
        if (req instanceof CcnReadObjectDataRequest) {
            return this.ccnNetwork.ccnPlatSrvc.readObjectData(((CcnReadObjectDataRequest)req).getObjDef());
        }
        if (req instanceof CcnSendByteArrayRequest) {
            return this.ccnNetwork.ccnPlatSrvc.sendByteArray(req.getByteArray());
        }
        throw new CcnRuntimeException(6488267, "Can not process unrecognized CcnNativeDriver request " + (Object)((Object)req));
    }
}

