/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn;

import com.tridium.ccn.BCcnTunnelHelper;
import com.tridium.ccn.CcnUdpRoutingTable;
import java.net.DatagramSocket;
import java.net.SocketException;
import javax.baja.log.Log;
import javax.baja.sys.Clock;

abstract class CcnTunnelProcess
extends Thread {
    protected DatagramSocket iSocket;
    protected BCcnTunnelHelper iCcnTunnelHelper;
    protected final CcnUdpRoutingTable iRoutingTable;
    protected volatile boolean quittingTime;
    private int iBindPort;
    private String iThreadName;
    private char iDotChar;
    private final Object briefRestMonitor = new Object();
    Log tunnelLog = Log.getLog((String)"CCNTunnelLog");

    public CcnTunnelProcess(BCcnTunnelHelper lCcnTunnelHelper, CcnUdpRoutingTable lRoutingTable, String lThreadName, int lBindPort, char lDotChar) {
        super(lThreadName);
        this.iThreadName = lThreadName;
        this.iCcnTunnelHelper = lCcnTunnelHelper;
        this.iRoutingTable = lRoutingTable;
        this.iBindPort = lBindPort;
        this.iDotChar = lDotChar;
    }

    protected int getBindPort() {
        return this.iBindPort;
    }

    @Override
    public void start() {
        try {
            this.setStatus("Starting...");
            if (this.iBindPort > 0) {
                this.iSocket = new DatagramSocket(this.iBindPort);
            }
            this.quittingTime = false;
            super.start();
        }
        catch (SocketException e) {
            this.tunnelLog.trace("Unable to start CCN/UDP-IP " + this.iThreadName + " thread. Unable to open socket connection.");
            this.tunnelLog.trace("Caught SocketException while binding datagram socket to port " + this.iBindPort);
            System.out.println("** " + e);
        }
    }

    public void pleaseStop() {
        this.setStatus("Stopped.");
        this.quittingTime = true;
    }

    @Override
    public void run() {
        while (!this.quittingTime) {
            if (this.isDisplayDots()) {
                System.out.print(this.iDotChar);
            }
            try {
                this.cycle();
            }
            catch (Exception e) {
                this.setStatus("Exception: " + e.getClass().getName());
                this.debugLn(this.iThreadName + " - caught exception " + e);
                if (this.isDebugOn()) {
                    e.printStackTrace();
                }
                this.briefRest();
            }
        }
        this.closeSocket();
        this.setStatus("Stopped.");
    }

    protected void closeSocket() {
        if (this.iSocket != null) {
            this.iSocket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopResting() {
        Object object = this.briefRestMonitor;
        synchronized (object) {
            this.briefRestMonitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void briefRest() {
        Object object = this.briefRestMonitor;
        synchronized (object) {
            try {
                this.briefRestMonitor.wait(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void setStatus(String text) {
    }

    protected boolean isDebugOn() {
        return false;
    }

    protected boolean isDisplayDots() {
        return false;
    }

    protected String getDebugIntro() {
        return this.getClass().getName();
    }

    protected void debugLn(String text) {
        this.tunnelLog.trace(this.getDebugIntro() + " - " + text + "[" + Clock.ticks() + "]");
    }

    protected abstract void cycle();
}

