/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn;

import com.tridium.ccn.BCcnNetwork;
import com.tridium.ccn.CcnRoutingTableManager;
import com.tridium.ccn.CcnTunnelBack;
import com.tridium.ccn.CcnTunnelUp;
import com.tridium.ccn.CcnUdpRoutingTable;
import com.tridium.ccn.UDPRoutingTableEntry;
import com.tridium.ccn.messages.CcnAsyncRequest;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.baja.log.Log;
import javax.baja.sys.BComponent;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BCcnTunnelHelper
extends BComponent {
    public static final Property tunnelRxDisplayDots = BCcnTunnelHelper.newProperty((int)0, (boolean)false, null);
    public static final Property tunnelTxDisplayDots = BCcnTunnelHelper.newProperty((int)0, (boolean)false, null);
    public static final Property tunnelRxDebugOn = BCcnTunnelHelper.newProperty((int)0, (boolean)false, null);
    public static final Property tunnelTxDebugOn = BCcnTunnelHelper.newProperty((int)0, (boolean)false, null);
    public static final Property tunnelRxRetryCount = BCcnTunnelHelper.newProperty((int)0, (int)2, null);
    public static final Property tunnelRxResponseTimeout = BCcnTunnelHelper.newProperty((int)0, (int)10000, null);
    public static final Property tunnelRxStatus = BCcnTunnelHelper.newProperty((int)1, (String)"Stopped", null);
    public static final Property tunnelTxStatus = BCcnTunnelHelper.newProperty((int)1, (String)"Stopped", null);
    public static final Type TYPE = Sys.loadType(BCcnTunnelHelper.class);
    BCcnNetwork ccnNetwork;
    private CcnTunnelBack tunnelBack;
    private CcnTunnelUp tunnelUp;
    private CcnUdpRoutingTable routingTable;
    private CcnRoutingTableManager rtManager;
    Log tunnelLog = Log.getLog((String)"CCNTunnelLog");

    public boolean getTunnelRxDisplayDots() {
        return this.getBoolean(tunnelRxDisplayDots);
    }

    public void setTunnelRxDisplayDots(boolean v) {
        this.setBoolean(tunnelRxDisplayDots, v, null);
    }

    public boolean getTunnelTxDisplayDots() {
        return this.getBoolean(tunnelTxDisplayDots);
    }

    public void setTunnelTxDisplayDots(boolean v) {
        this.setBoolean(tunnelTxDisplayDots, v, null);
    }

    public boolean getTunnelRxDebugOn() {
        return this.getBoolean(tunnelRxDebugOn);
    }

    public void setTunnelRxDebugOn(boolean v) {
        this.setBoolean(tunnelRxDebugOn, v, null);
    }

    public boolean getTunnelTxDebugOn() {
        return this.getBoolean(tunnelTxDebugOn);
    }

    public void setTunnelTxDebugOn(boolean v) {
        this.setBoolean(tunnelTxDebugOn, v, null);
    }

    public int getTunnelRxRetryCount() {
        return this.getInt(tunnelRxRetryCount);
    }

    public void setTunnelRxRetryCount(int v) {
        this.setInt(tunnelRxRetryCount, v, null);
    }

    public int getTunnelRxResponseTimeout() {
        return this.getInt(tunnelRxResponseTimeout);
    }

    public void setTunnelRxResponseTimeout(int v) {
        this.setInt(tunnelRxResponseTimeout, v, null);
    }

    public String getTunnelRxStatus() {
        return this.getString(tunnelRxStatus);
    }

    public void setTunnelRxStatus(String v) {
        this.setString(tunnelRxStatus, v, null);
    }

    public String getTunnelTxStatus() {
        return this.getString(tunnelTxStatus);
    }

    public void setTunnelTxStatus(String v) {
        this.setString(tunnelTxStatus, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void cleanup() {
        this.abortOldThreadJobs();
    }

    private void createNewThreadJobs() {
        this.routingTable = new CcnUdpRoutingTable(this.ccnNetwork);
        this.routingTable.giveEntry(new UDPRoutingTableEntry(BCcnTunnelHelper.getIpAddrBytes(), this.ccnNetwork.getElemAddress(), 50005, 3));
        this.tunnelBack = new CcnTunnelBack(this, this.routingTable);
        this.rtManager = new CcnRoutingTableManager(this, this.routingTable, this.tunnelBack);
        this.tunnelUp = new CcnTunnelUp(this, this.tunnelBack, this.routingTable);
    }

    public static int[] getIpAddrBytes() {
        int[] iaIPAddr = new int[4];
        try {
            String sIPAddr = Sys.getLocalHost(null).getHostAddress();
            StringTokenizer st = new StringTokenizer(sIPAddr, ".");
            for (int i = 0; i < 4; ++i) {
                iaIPAddr[i] = Integer.parseInt(st.nextToken());
            }
        }
        catch (NoSuchElementException nsee) {
            Log.getLog((String)"CCNTunnelLog").message("Cannot find the four parts of the ip address. What else can I do but return that which I was able to parse which might have been nothing?");
        }
        return iaIPAddr;
    }

    public void abortOldThreadJobs() {
        if (this.tunnelUp != null) {
            this.tunnelUp.pleaseStop();
            this.tunnelUp = null;
        }
        if (this.tunnelBack != null) {
            this.tunnelBack.pleaseStop();
            this.tunnelBack = null;
        }
        if (this.rtManager != null) {
            this.rtManager.pleaseStop();
            this.rtManager = null;
        }
        this.routingTable = null;
    }

    public void tunnelStart(BCcnNetwork nw) {
        this.ccnNetwork = nw;
        this.abortOldThreadJobs();
        this.createNewThreadJobs();
        this.tunnelBack.start();
        this.rtManager.start();
        this.tunnelUp.start();
    }

    public void tunnelStop() {
        this.abortOldThreadJobs();
    }

    public CcnAsyncRequest getCcnAsyncReq() {
        return this.ccnNetwork.getCcnComm().ccnAsyncRequest();
    }

    public CcnTunnelBack getCcnTunnelBack() {
        return this.tunnelBack;
    }

    protected CcnUdpRoutingTable getRoutingTable() {
        return this.routingTable;
    }
}

