/*
 * Decompiled with CFR 0.152.
 */
package obix.ui;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import obix.Contract;
import obix.ContractRegistry;
import obix.Obj;
import obix.Op;
import obix.Uri;
import obix.io.ObixDecoder;
import obix.net.ObixSession;
import obix.ui.Form;
import obix.ui.ObjSheet;
import obix.ui.Shell;
import obix.ui.Utils;

public class UiSession
extends ObixSession {
    static HashMap<String, UiSession> sessions = new HashMap();
    static final ImageIcon iconDefault = Utils.icon("x16/object.png");
    static final ImageIcon iconOp = Utils.icon("x16/exclaim.png");
    static final ImageIcon iconInfo = Utils.icon("x16/info.png");
    static final ImageIcon iconGlasses = Utils.icon("x16/glasses.png");
    static final ImageIcon iconHistory = Utils.icon("x16/history.png");
    static final ImageIcon iconAlarm = Utils.icon("x16/alarm.png");
    Object iconLock = new Object();
    IconLoader iconLoader = new IconLoader();
    HashMap<String, RemoteIcon> iconCache = new HashMap();
    ArrayList<RemoteIcon> iconQueue = new ArrayList();

    public static UiSession[] list() {
        return sessions.values().toArray(new UiSession[sessions.size()]);
    }

    public static UiSession make(Shell shell, Uri uri) throws Exception {
        uri.checkAbsolute();
        String auth = uri.getAuthority();
        UiSession session = sessions.get(auth);
        if (session != null) {
            return session;
        }
        Ask ask = new Ask();
        ask.lobby = uri.getAuthority() + "obix/";
        ask = (Ask)Form.prompt(shell.getRootPane(), "Open New Session", ask);
        if (ask == null) {
            return null;
        }
        session = new UiSession(new Uri(ask.lobby), ask.userName, ask.password);
        session.open();
        sessions.put(auth, session);
        shell.sessionCreated(session);
        return session;
    }

    private UiSession(Uri lobby, String user, String pass) {
        super(lobby, user, pass);
    }

    public void open() throws Exception {
        super.open();
        this.iconLoader = new IconLoader();
        this.iconLoader.start();
    }

    public void close() {
        super.close();
        this.iconLoader.kill();
        this.iconLoader = null;
    }

    public Response request(Uri uri) throws Exception {
        int c;
        Response resp = new Response();
        resp.session = this;
        InputStream in = this.open(uri);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        while ((c = in.read()) >= 0) {
            bout.write(c);
        }
        in.close();
        byte[] buf = bout.toByteArray();
        StringBuffer source = new StringBuffer(buf.length);
        for (int i = 0; i < buf.length; ++i) {
            c = buf[i];
            if (c == 10 || 32 <= c && c <= 127) {
                source.append((char)c);
                continue;
            }
            source.append('.');
        }
        resp.source = source.toString();
        try {
            resp.obj = ObixDecoder.make((InputStream)new ByteArrayInputStream(buf)).decodeDocument();
        }
        catch (Throwable e) {
            resp.objError = e;
        }
        return resp;
    }

    public Obj invoke(Shell shell, Op op) throws Exception {
        Uri href = op.getNormalizedHref();
        if (href == null) {
            throw new Exception("Missing href for op");
        }
        Obj in = this.getInvokeIn(op);
        if (in != null) {
            in.setWritable(true, true);
            in = ObjSheet.prompt(shell, "Invoke " + op.getName(), this, in);
            if (in == null) {
                return null;
            }
        } else {
            in = new Obj("in");
        }
        return this.invoke(href, in);
    }

    public Obj getInvokeIn(Op op) throws Exception {
        Contract in = op.getIn();
        if (in.containsOnlyObj()) {
            return null;
        }
        System.out.println("getInvokeIn: " + in);
        Obj obj = null;
        if (in.primary().get().startsWith("obix:")) {
            obj = ContractRegistry.toObj(Obj.class, (Contract)in);
            System.out.println("  reg: " + obj);
            if (obj != null) {
                obj.setName("in");
            }
        }
        if (obj != null && obj.getClass() != Obj.class) {
            return obj;
        }
        Uri inUri = in.primary().normalize(op.getNormalizedHref());
        return this.read(inUri);
    }

    public Icon loadIcon(Obj obj) {
        ImageIcon def = this.getDefaultIcon(obj);
        Uri href = obj.getIcon();
        if (href == null) {
            return def;
        }
        return this.loadIcon(href, def);
    }

    public ImageIcon getDefaultIcon(Obj obj) {
        if (obj instanceof Op) {
            return iconOp;
        }
        if (obj.getIs() == null) {
            return iconDefault;
        }
        Uri[] contracts = obj.getIs().list();
        for (int i = 0; i < contracts.length; ++i) {
            String c = contracts[i].toString();
            if (c.equals("obix:About")) {
                return iconInfo;
            }
            if (c.equals("obix:WatchService")) {
                return iconGlasses;
            }
            if (c.equals("obix:Alarm")) {
                return iconAlarm;
            }
            if (!c.equals("obix:History")) continue;
            return iconHistory;
        }
        return iconDefault;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Icon loadIcon(Uri href, ImageIcon def) {
        if (href == null) {
            return def;
        }
        Object object = this.iconLock;
        synchronized (object) {
            String key = href.toString();
            RemoteIcon icon = this.iconCache.get(key);
            if (icon != null) {
                return icon;
            }
            icon = new RemoteIcon(href, def);
            this.iconCache.put(key, icon);
            this.iconQueue.add(icon);
            this.iconLock.notifyAll();
            return icon;
        }
    }

    public static class Response {
        public UiSession session;
        public String source;
        public Obj obj;
        public Throwable objError;
    }

    class IconLoader
    extends Thread {
        boolean alive;

        IconLoader() {
            super("IconLoader");
            this.alive = true;
        }

        public void kill() {
            this.alive = false;
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.alive) {
                try {
                    int n;
                    RemoteIcon icon = null;
                    Object object = UiSession.this.iconLock;
                    synchronized (object) {
                        while (UiSession.this.iconQueue.size() == 0) {
                            UiSession.this.iconLock.wait();
                        }
                        icon = UiSession.this.iconQueue.remove(0);
                    }
                    InputStream in = UiSession.this.open(icon.href);
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    byte[] buf = new byte[1024];
                    while ((n = in.read(buf)) >= 0) {
                        out.write(buf, 0, n);
                    }
                    byte[] data = out.toByteArray();
                    Image image = Toolkit.getDefaultToolkit().createImage(data);
                    if (image == null) continue;
                    icon.image = Utils.sync(image);
                    icon.w = image.getWidth(null);
                    icon.h = image.getHeight(null);
                    Shell.theShell.repaint();
                }
                catch (Exception e) {
                    if (!this.alive) break;
                    e.printStackTrace();
                }
            }
        }
    }

    static class RemoteIcon
    implements Icon {
        int w = 16;
        int h = 16;
        Image image;
        Uri href;

        RemoteIcon(Uri href, ImageIcon def) {
            this.href = href;
            this.image = def.getImage();
        }

        @Override
        public int getIconHeight() {
            return this.h;
        }

        @Override
        public int getIconWidth() {
            return this.w;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.image != null) {
                g.drawImage(this.image, x, y, c);
            }
        }
    }

    static class Ask {
        public String lobby = "";
        public String userName = "admin";
        public String password = "";

        Ask() {
        }
    }
}

