/*
 * Decompiled with CFR 0.152.
 */
package obix.ui;

import java.util.ArrayList;
import obix.Uri;

public class History {
    public static final int MAX_HISTORY = 50;
    private Entry[] list = new Entry[50];
    private int count;
    private int current = -1;
    private ArrayList<Entry> recent = new ArrayList();

    public Entry append(String uri) {
        Entry entry = new Entry(uri);
        for (int i = this.current + 1; i < this.count; ++i) {
            this.list[i] = null;
        }
        this.count = this.current + 1;
        if (this.count >= this.list.length) {
            this.count = this.list.length;
            System.arraycopy(this.list, 1, this.list, 0, this.count - 1);
            this.list[this.count - 1] = entry;
        } else {
            this.list[this.count++] = entry;
        }
        this.current = this.count - 1;
        this.recentAdd(entry);
        return entry;
    }

    public String back() {
        if (this.current < 1) {
            return null;
        }
        return this.list[--this.current].uri;
    }

    public String forward() {
        if (this.current >= this.count - 1) {
            return null;
        }
        return this.list[++this.current].uri;
    }

    public boolean isBackEnabled() {
        return this.current >= 1;
    }

    public boolean isForwardEnabled() {
        return this.current < this.count - 1;
    }

    public boolean isUpEnabled() {
        try {
            String cur = this.getCurrent().uri;
            return new Uri(cur).parent() != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    Entry[] getBackHistory() {
        Entry[] temp = new Entry[this.current];
        for (int i = 0; i < this.current; ++i) {
            temp[this.current - i - 1] = this.list[i];
        }
        return temp;
    }

    Entry[] getForwardHistory() {
        Entry[] temp = new Entry[this.count - this.current - 1];
        for (int i = 0; i < this.count - this.current - 1; ++i) {
            temp[i] = this.list[this.current + i + 1];
        }
        return temp;
    }

    Entry getCurrent() {
        return this.list[this.current];
    }

    public int recentIndexOf(String uri) {
        for (int i = 0; i < this.recent.size(); ++i) {
            if (!uri.equals(this.recent.get((int)i).uri)) continue;
            return i;
        }
        return -1;
    }

    public void recentAdd(Entry entry) {
        int index = this.recentIndexOf(entry.uri);
        if (index < 0) {
            if (this.recent.size() >= 50) {
                this.recent.remove(this.recent.size() - 1);
            }
        } else {
            this.recent.remove(index);
        }
        this.recent.add(0, entry);
    }

    public void recentTouch(String ord) {
        int index = this.recentIndexOf(ord);
        if (index >= 0) {
            Entry entry = this.recent.get(index);
            this.recent.remove(index);
            this.recent.add(0, entry);
        }
    }

    Entry[] recentList() {
        return this.recent.toArray(new Entry[this.recent.size()]);
    }

    static class Entry {
        public String uri;

        public Entry(String uri) {
            this.uri = uri;
        }
    }
}

