/*
 * Decompiled with CFR 0.152.
 */
package obix.ui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.reflect.Field;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import obix.ui.UiSession;
import obix.ui.Utils;

public class Form
extends JPanel {
    Object target;
    Editor[] editors;

    public static Object prompt(JComponent parent, String title, Object target) {
        Form form = new Form(target);
        form.load();
        JOptionPane pane = new JOptionPane(form, -1, 2);
        JDialog dialog = pane.createDialog(parent, title);
        dialog.pack();
        dialog.setVisible(true);
        if (pane.getValue() == null || pane.getValue().equals(new Integer(2))) {
            return null;
        }
        form.save();
        return target;
    }

    public Form(Object target) {
        try {
            this.target = target;
            Field[] fields = target.getClass().getFields();
            this.editors = new Editor[fields.length];
            GridBagLayout gb = new GridBagLayout();
            GridBagConstraints gc = new GridBagConstraints();
            this.setLayout(gb);
            for (int i = 0; i < fields.length; ++i) {
                this.editors[i] = Form.makeEditor(fields[i]);
                gc = new GridBagConstraints();
                gc.gridx = 0;
                gc.gridy = i;
                gc.insets = new Insets(2, 2, 2, 2);
                gc.anchor = 17;
                gc.weightx = 0.0;
                gb.setConstraints(this.editors[i].label, gc);
                this.add(this.editors[i].label);
                gc.gridx = 1;
                gc.gridy = i;
                gc.insets = new Insets(2, 2, 2, 2);
                gc.anchor = 17;
                gc.weightx = 1.0;
                gb.setConstraints(this.editors[i].editor, gc);
                this.add(this.editors[i].editor);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void load() {
        for (int i = 0; i < this.editors.length; ++i) {
            Editor editor = this.editors[i];
            try {
                editor.load(editor.field.get(this.target));
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot save form field: " + editor.name, e);
            }
        }
    }

    public void save() {
        for (int i = 0; i < this.editors.length; ++i) {
            Editor editor = this.editors[i];
            try {
                editor.field.set(this.target, editor.save());
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot save form field: " + editor.name, e);
            }
        }
    }

    static Editor makeEditor(Field field) {
        Class<?> type = field.getType();
        if (type == String.class) {
            return new StringEditor(field);
        }
        if (type == Integer.TYPE) {
            return new IntEditor(field);
        }
        if (type == UiSession.class) {
            return new SessionEditor(field);
        }
        throw new IllegalStateException("Field not unsupported: " + type.getName());
    }

    static class SessionEditor
    extends Editor {
        JComboBox<Object> combo = new JComboBox<UiSession>(UiSession.list());

        SessionEditor(Field field) {
            super(field);
            this.editor = this.combo;
            this.combo.setSelectedIndex(0);
        }

        @Override
        void load(Object v) {
            if (v != null) {
                this.combo.setSelectedItem(v);
            }
        }

        @Override
        Object save() {
            return this.combo.getSelectedItem();
        }
    }

    static class IntEditor
    extends Editor {
        JTextField textField = new JTextField("0", 15);

        IntEditor(Field field) {
            super(field);
            this.editor = this.textField;
        }

        @Override
        void load(Object v) {
            this.textField.setText(v.toString());
        }

        @Override
        Object save() {
            return new Integer(this.textField.getText());
        }
    }

    static class StringEditor
    extends Editor {
        JTextField textField;

        StringEditor(Field field) {
            super(field);
            if (field.getName().equals("password")) {
                this.textField = new JPasswordField("", 30);
                this.editor = this.textField;
            } else {
                this.textField = new JTextField("", 30);
                this.editor = this.textField;
            }
        }

        @Override
        void load(Object v) {
            this.textField.setText(v.toString());
        }

        @Override
        Object save() {
            return this.textField.getText();
        }
    }

    static abstract class Editor {
        Field field;
        String name;
        JLabel label;
        JComponent editor;

        Editor(Field field) {
            this.field = field;
            this.name = Utils.toFriendly(field.getName());
            this.label = new JLabel(this.name, 2);
        }

        abstract void load(Object var1);

        abstract Object save();
    }
}

