/*
 * Decompiled with CFR 0.152.
 */
package obix.ui;

import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import obix.Obj;
import obix.Op;
import obix.Uri;
import obix.ui.Command;
import obix.ui.History;
import obix.ui.HyperlinkInfo;
import obix.ui.Shell;
import obix.ui.UiSession;

public class Commands {
    public final Shell shell;
    public final Command back = new Back();
    public final Command forward = new Forward();
    public final Command up = new Up();
    public final Command refresh = new Refresh();
    public final Command save = new Save();
    public final Command exit = new Exit();
    public final Command localHost = new LocalHost();
    public final Command sessions = new Sessions();
    public final ToggleCommand verbose = new Verbose();
    public final ToggleCommand useWritable = new UseWritable();
    public final Command about = new About();

    public Commands(Shell shell) {
        this.shell = shell;
    }

    public JMenuBar makeMenuBar() {
        JMenuBar bar = new JMenuBar();
        bar.add(this.makeFileMenu());
        bar.add(this.makeToolsMenu());
        bar.add(this.makeHelpMenu());
        return bar;
    }

    private JMenu makeFileMenu() {
        JMenu menu = new JMenu("File");
        menu.add(Commands.makeMenuItem(this.back));
        menu.add(Commands.makeMenuItem(this.forward));
        menu.add(Commands.makeMenuItem(this.up));
        menu.add(Commands.makeMenuItem(this.refresh));
        menu.add(new JSeparator());
        menu.add(Commands.makeMenuItem(this.save));
        menu.add(new JSeparator());
        menu.add(Commands.makeMenuItem(this.exit));
        return menu;
    }

    private JMenu makeToolsMenu() {
        JMenu menu = new JMenu("Tools");
        menu.add(Commands.makeMenuItem(this.localHost));
        menu.add(Commands.makeMenuItem(this.sessions));
        menu.add(new JSeparator());
        menu.add(Commands.makeMenuItem(this.verbose));
        menu.add(Commands.makeMenuItem(this.useWritable));
        return menu;
    }

    private JMenu makeHelpMenu() {
        JMenu menu = new JMenu("Help");
        menu.add(Commands.makeMenuItem(this.about));
        return menu;
    }

    public static JMenuItem makeMenuItem(Command cmd) {
        JMenuItem item;
        if (cmd instanceof ToggleCommand) {
            item = new JCheckBoxMenuItem(cmd);
            item.setSelected(((ToggleCommand)cmd).isSelected());
        } else {
            item = new JMenuItem(cmd);
        }
        cmd.bind(item);
        return item;
    }

    public JToolBar makeToolBar() {
        JToolBar bar = new JToolBar();
        bar.setFloatable(false);
        bar.add(Commands.makeToolBarButton(this.back));
        bar.add(Commands.makeToolBarButton(this.forward));
        bar.add(Commands.makeToolBarButton(this.up));
        bar.add(Commands.makeToolBarButton(this.refresh));
        bar.add(new JSeparator());
        bar.add(Commands.makeToolBarButton(this.save));
        return bar;
    }

    public static AbstractButton makeToolBarButton(Command cmd) {
        AbstractButton b;
        if (cmd instanceof ToggleCommand) {
            b = new JToggleButton(cmd);
            b.setSelected(((ToggleCommand)cmd).isSelected());
        } else {
            b = new JButton(cmd);
        }
        b.setFocusable(false);
        b.setText(null);
        b.setBorderPainted(false);
        cmd.bind(b);
        return b;
    }

    public JPopupMenu makePopup(Obj obj) {
        JPopupMenu menu = new JPopupMenu();
        Op[] ops = (Op[])obj.list(Op.class);
        if (ops.length > 0) {
            JMenu sub = new JMenu("Operations");
            sub.setIcon(UiSession.iconOp);
            for (int i = 0; i < ops.length; ++i) {
                sub.add(new Invoke(ops[i]));
            }
            menu.add(sub);
        }
        if (obj.getHref() != null) {
            menu.add(new Goto(obj.getNormalizedHref()));
        }
        if (obj instanceof Op) {
            menu.add(new Invoke((Op)obj));
        }
        return menu;
    }

    public void update() {
        History history = this.shell.history;
        this.back.setEnabled(history.isBackEnabled());
        this.forward.setEnabled(history.isForwardEnabled());
        this.up.setEnabled(history.isUpEnabled());
    }

    public class Invoke
    extends MyCommand {
        Op op;

        Invoke(Op op) {
            super(op.toDisplayName(), "x16/exclaim.png", null);
            this.op = op;
        }

        @Override
        public void doInvoke() throws Exception {
            UiSession session = UiSession.make(Commands.this.shell, this.op.getNormalizedHref());
            session.invoke(Commands.this.shell, this.op);
        }
    }

    public class Goto
    extends MyCommand {
        Uri uri;

        Goto(Uri uri) {
            super("Goto", "x16/arrowRight.png", null);
            this.uri = uri;
        }

        @Override
        public void doInvoke() {
            Commands.this.shell.hyperlink(this.uri);
        }
    }

    public class About
    extends MyCommand {
        About() {
            super("About", "x16/questionMark.png", null);
        }

        @Override
        public void doInvoke() {
            Commands.this.shell.hyperlink("spy:splash");
        }
    }

    public class Sessions
    extends MyCommand {
        Sessions() {
            super("Sessions", null, null);
        }

        @Override
        public void doInvoke() {
            Commands.this.shell.hyperlink("spy:sessions");
        }
    }

    public class LocalHost
    extends MyCommand {
        LocalHost() {
            super("LocalHost", null, null);
        }

        @Override
        public void doInvoke() {
            Commands.this.shell.hyperlink("http://localhost/obix");
        }
    }

    public class UseWritable
    extends ToggleCommand {
        UseWritable() {
            super("Use Writable", null, null);
            this.setSelected(true);
        }

        @Override
        public void doInvoke() {
            Commands.this.refresh.invoke();
        }
    }

    public class Verbose
    extends ToggleCommand {
        Verbose() {
            super("Verbose", "x16/v.png", null);
            this.setSelected(true);
        }

        @Override
        public void doInvoke() {
            Commands.this.refresh.invoke();
        }
    }

    public class Exit
    extends MyCommand {
        Exit() {
            super("Exit", "x16/close.png", "control X");
        }

        @Override
        public void doInvoke() {
            Commands.this.shell.savePrefs();
            System.exit(0);
        }
    }

    public class Save
    extends MyCommand {
        Save() {
            super("Save", "x16/save.png", "control S");
        }

        @Override
        public void doInvoke() throws Exception {
            Commands.this.shell.activeView().save();
            this.setEnabled(false);
        }
    }

    public class Refresh
    extends MyCommand {
        Refresh() {
            super("Refresh", "x16/refresh.png", "control R");
        }

        @Override
        public void doInvoke() {
            Commands.this.shell.refresh();
        }
    }

    public class Up
    extends MyCommand {
        Up() {
            super("Up", "x16/upLevel.png", "alt UP");
        }

        @Override
        public void doInvoke() {
            int slash;
            String uriStr = Commands.this.shell.uri().toString();
            if (uriStr.startsWith("spy:") && (slash = uriStr.lastIndexOf(47)) > 0) {
                Commands.this.shell.hyperlink(uriStr.substring(0, slash));
                return;
            }
            Uri parent = new Uri(Commands.this.shell.uri()).parent();
            if (parent != null) {
                Commands.this.shell.hyperlink(parent.toString());
            }
        }
    }

    public class Forward
    extends MyCommand {
        Forward() {
            super("Forward", "x16/arrowRight.png", "alt RIGHT");
        }

        @Override
        public void doInvoke() {
            String uri = Commands.this.shell.history.forward();
            if (uri == null) {
                return;
            }
            Commands.this.shell.hyperlink(new HyperlinkInfo(uri, false));
        }
    }

    public class Back
    extends MyCommand {
        Back() {
            super("Back", "x16/arrowLeft.png", "alt LEFT");
        }

        @Override
        public void doInvoke() {
            String uri = Commands.this.shell.history.back();
            if (uri == null) {
                return;
            }
            Commands.this.shell.hyperlink(new HyperlinkInfo(uri, false));
        }
    }

    public abstract class ToggleCommand
    extends MyCommand {
        boolean selected;

        public ToggleCommand(String name, String icon, String accelerator) {
            super(name, icon, accelerator);
        }

        public ToggleCommand(String name) {
            super(name);
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean sel) {
            if (this.selected == sel) {
                return;
            }
            this.selected = sel;
            JComponent[] bindings = this.bindings();
            for (int i = 0; i < bindings.length; ++i) {
                this.setSelected(bindings[i], sel);
            }
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.setSelected(this.getSelected(event.getSource()));
            super.actionPerformed(event);
        }

        boolean getSelected(Object c) {
            if (c instanceof JToggleButton) {
                return ((JToggleButton)c).isSelected();
            }
            if (c instanceof JCheckBoxMenuItem) {
                return ((JCheckBoxMenuItem)c).getState();
            }
            throw new IllegalStateException(c.getClass().getName());
        }

        void setSelected(Object c, boolean sel) {
            if (c instanceof JToggleButton) {
                ((JToggleButton)c).setSelected(sel);
                return;
            }
            if (c instanceof JCheckBoxMenuItem) {
                ((JCheckBoxMenuItem)c).setState(sel);
                return;
            }
        }
    }

    public abstract class MyCommand
    extends Command {
        public MyCommand(String name, String icon, String accelerator) {
            super(null, name, icon, accelerator);
        }

        public MyCommand(String name) {
            this(name, null, null);
        }

        @Override
        public Shell shell() {
            return Commands.this.shell;
        }
    }
}

