/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.program.module;

import com.tridium.program.BProgram;
import java.util.Collections;
import java.util.HashSet;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.ModuleInfo;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;
import javax.baja.util.BNameMap;

public final class BProgramModule
extends BComponent {
    public static final Property moduleName = BProgramModule.newProperty((int)8, (String)"", (BFacets)BFacets.make((String)"mustBeSlotName", (boolean)true));
    public static final Property description = BProgramModule.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"max", (int)100));
    public static final Property vendor = BProgramModule.newProperty((int)0, (String)"", null);
    public static final Property vendorVersion = BProgramModule.newProperty((int)0, (String)"0", (BFacets)BFacets.make((String)"validator", (String)"baja:VersionValidator"));
    public static final Property dependencies = BProgramModule.newProperty((int)4, (BValue)BNameMap.DEFAULT, null);
    public static final Property programs = BProgramModule.newProperty((int)4, (BValue)new BFolder(), null);
    public static final Property permissions = BProgramModule.newProperty((int)4, (BValue)new BFolder(), null);
    public static final Type TYPE = Sys.loadType(BProgramModule.class);
    private static final BIcon icon = BIcon.make((BIcon)BIcon.std((String)"module.png"), (BIcon)BIcon.std((String)"badges/script.png"));

    public String getModuleName() {
        return this.getString(moduleName);
    }

    public void setModuleName(String v) {
        this.setString(moduleName, v, null);
    }

    public String getDescription() {
        return this.getString(description);
    }

    public void setDescription(String v) {
        this.setString(description, v, null);
    }

    public String getVendor() {
        return this.getString(vendor);
    }

    public void setVendor(String v) {
        this.setString(vendor, v, null);
    }

    public String getVendorVersion() {
        return this.getString(vendorVersion);
    }

    public void setVendorVersion(String v) {
        this.setString(vendorVersion, v, null);
    }

    public BNameMap getDependencies() {
        return (BNameMap)this.get(dependencies);
    }

    public void setDependencies(BNameMap v) {
        this.set(dependencies, (BValue)v, null);
    }

    public BFolder getPrograms() {
        return (BFolder)this.get(programs);
    }

    public void setPrograms(BFolder v) {
        this.set(programs, (BValue)v, null);
    }

    public BFolder getPermissions() {
        return (BFolder)this.get(permissions);
    }

    public void setPermissions(BFolder v) {
        this.set(permissions, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static BNameMap rationalizeDependencies(BProgramModule module) {
        String[] gone;
        BProgram[] programs;
        HashSet set = new HashSet();
        BNameMap depends = module.getDependencies();
        String[] currentNames = depends.list();
        Collections.addAll(set, currentNames);
        for (BProgram program : programs = module.listPrograms()) {
            String[] progDepends;
            for (String moduleName : progDepends = TextUtil.split((String)program.getCode().getDependencies(), (char)';')) {
                if (depends.get(moduleName) == null) {
                    if (!BProgram.isSpecialModule(moduleName)) {
                        try {
                            ModuleInfo mInfo = Sys.getRegistry().moduleForDependency(moduleName);
                            depends = BNameMap.make((BNameMap)depends, (String)moduleName, (String)mInfo.getVendorVersion().toString(2));
                        }
                        catch (ModuleNotFoundException moduleNotFoundException) {}
                    } else {
                        depends = BNameMap.make((BNameMap)depends, (String)moduleName, (String)Sys.getRegistry().getModule("baja", RuntimeProfile.rt).getVendorVersion().toString(2));
                    }
                }
                set.remove(moduleName);
            }
        }
        for (String aGone : gone = set.toArray(new String[set.size()])) {
            depends = BNameMap.remove((BNameMap)depends, (String)aGone);
        }
        return depends;
    }

    public RuntimeProfile getRuntimeProfile() {
        BNameMap depends = this.getDependencies();
        RuntimeProfile moduleProfile = RuntimeProfile.rt;
        for (String name : depends.list()) {
            try {
                ModuleInfo mInfo = Sys.getRegistry().moduleForDependency(name);
                RuntimeProfile runtime = mInfo.getRuntimeProfile();
                if (runtime.compareTo((Enum)moduleProfile) <= 0) continue;
                moduleProfile = runtime;
            }
            catch (ModuleNotFoundException moduleNotFoundException) {
                // empty catch block
            }
        }
        return moduleProfile;
    }

    public BProgram[] listPrograms() {
        return (BProgram[])this.getPrograms().getChildren(BProgram.class);
    }

    public String getPreferredSymbol() {
        return this.getModuleName();
    }

    public BIcon getIcon() {
        return icon;
    }
}

