/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.program.batch;

import com.tridium.program.batch.BBatchRoutine;
import java.io.PrintWriter;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="setOnParent", type="boolean", defaultValue="false"), @NiagaraProperty(name="slotName", type="String", defaultValue=""), @NiagaraProperty(name="slotFlags", type="int", defaultValue="0"), @NiagaraProperty(name="set", type="boolean", defaultValue="true")})
public class BSlotFlagsBatchRoutine
extends BBatchRoutine {
    public static final Property setOnParent = BSlotFlagsBatchRoutine.newProperty((int)0, (boolean)false, null);
    public static final Property slotName = BSlotFlagsBatchRoutine.newProperty((int)0, (String)"", null);
    public static final Property slotFlags = BSlotFlagsBatchRoutine.newProperty((int)0, (int)0, null);
    public static final Property set = BSlotFlagsBatchRoutine.newProperty((int)0, (boolean)true, null);
    public static final Type TYPE = Sys.loadType(BSlotFlagsBatchRoutine.class);

    public boolean getSetOnParent() {
        return this.getBoolean(setOnParent);
    }

    public void setSetOnParent(boolean v) {
        this.setBoolean(setOnParent, v, null);
    }

    public String getSlotName() {
        return this.getString(slotName);
    }

    public void setSlotName(String v) {
        this.setString(slotName, v, null);
    }

    public int getSlotFlags() {
        return this.getInt(slotFlags);
    }

    public void setSlotFlags(int v) {
        this.setInt(slotFlags, v, null);
    }

    public boolean getSet() {
        return this.getBoolean(set);
    }

    public void setSet(boolean v) {
        this.setBoolean(set, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public static BSlotFlagsBatchRoutine make(boolean setOnParent, String name, int flags, boolean set) {
        BSlotFlagsBatchRoutine routine = new BSlotFlagsBatchRoutine();
        routine.setSetOnParent(setOnParent);
        routine.setSlotName(name);
        routine.setSlotFlags(flags);
        routine.setSet(set);
        return routine;
    }

    @Override
    public void run(BComponent component, PrintWriter log, Lexicon lex, Context cx) {
        String slotName = this.getSlotName();
        int flag = this.getSlotFlags();
        boolean useComp = this.getSetOnParent();
        boolean set = this.getSet();
        if (useComp) {
            BComplex parent = component.getParent();
            Property prop = component.getPropertyInParent();
            if (parent != null && prop != null) {
                int origFlags = parent.getFlags((Slot)prop);
                int newFlags = set ? origFlags | flag : origFlags & ~flag;
                parent.setFlags((Slot)prop, newFlags, cx);
                log.println(lex.getText("batchEditor.log.setFlags") + ' ' + component.getSlotPathOrd() + ' ' + Flags.toDisplayString((int)origFlags, (Context)cx) + " -> " + Flags.toDisplayString((int)newFlags, (Context)cx));
            } else {
                log.println(lex.getText("batchEditor.log.setFlags") + lex.getText("batchEditor.log.error") + ' ' + lex.getText("batchEditor.log.missingSlot") + ' ' + component.getSlotPathOrd());
            }
        } else {
            Slot slot = component.getSlot(slotName);
            if (slot != null) {
                int origFlags = component.getFlags(slot);
                int newFlags = set ? origFlags | flag : origFlags & ~flag;
                component.setFlags(slot, newFlags, cx);
                log.println(lex.getText("batchEditor.log.setFlags") + ' ' + component.getSlotPathOrd() + '.' + slotName + ' ' + Flags.toDisplayString((int)origFlags, (Context)cx) + " -> " + Flags.toDisplayString((int)newFlags, (Context)cx));
            } else {
                log.println(lex.getText("batchEditor.log.setFlags") + lex.getText("batchEditor.log.error") + ' ' + lex.getText("batchEditor.log.missingSlot") + ' ' + component.getSlotPathOrd() + '.' + slotName);
            }
        }
    }
}

