/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.program;

import com.tridium.crypto.core.cert.CertificateNotTrustedException;
import com.tridium.crypto.core.io.CoreCryptoManager;
import com.tridium.crypto.core.io.CoreTrustStore;
import com.tridium.crypto.core.io.ICoreTrustStore;
import com.tridium.nre.security.ISecurityInfoProvider;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.program.BCode;
import com.tridium.program.BProgram;
import com.tridium.program.ProgramBase;
import java.security.AccessController;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import javax.baja.status.BStatus;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BProgramCode
extends BCode {
    public static final Property className = BProgramCode.newProperty((int)BCode.className.getDefaultFlags(), (String)"ProgramImpl");
    public static final Property checksum = BProgramCode.newProperty((int)1, (int)0, null);
    public static final Property source = BProgramCode.newProperty((int)1, (String)"", null);
    public static final Property userDefinedImports = BProgramCode.newProperty((int)1, (String)"", null);
    public static final Type TYPE = Sys.loadType(BProgramCode.class);
    private ReloadProgramListener listener;

    public int getChecksum() {
        return this.getInt(checksum);
    }

    public void setChecksum(int v) {
        this.setInt(checksum, v, null);
    }

    public String getSource() {
        return this.getString(source);
    }

    public void setSource(String v) {
        this.setString(source, v, null);
    }

    public String getUserDefinedImports() {
        return this.getString(userDefinedImports);
    }

    public void setUserDefinedImports(String v) {
        this.setString(userDefinedImports, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void stopped() {
        this.removeListener();
    }

    public final BProgram getProgram() {
        return (BProgram)this.getParent();
    }

    public ProgramBase newProgramInstance() {
        if (this.getClassFile().length() > 0) {
            BProgram program = this.getProgram();
            try {
                ProgramBase instance = (ProgramBase)this.newInstance();
                this.setStatus(BStatus.ok);
                this.setFaultCause("");
                this.removeListener();
                return instance;
            }
            catch (Throwable e) {
                Throwable cause = e.getCause();
                if (cause instanceof CertificateNotTrustedException) {
                    this.addListener();
                }
                log.log(Level.SEVERE, "Cannot load program code: " + this.toPathString(), e);
            }
        }
        return new ProgramBase();
    }

    private void addListener() {
        if (this.listener != null) {
            return;
        }
        this.listener = new ReloadProgramListener();
        AccessController.doPrivileged(() -> {
            try {
                CoreCryptoManager ccm = CoreCryptoManager.get((ISecurityInfoProvider)SecurityInitializer.getInstance().getSecurityInfoProvider());
                ICoreTrustStore store = ccm.getUserTrustStore();
                if (store instanceof CoreTrustStore) {
                    ((CoreTrustStore)store).registerCertAddedListener((CoreTrustStore.CertificateAddedListener)this.listener);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        });
    }

    private void removeListener() {
        if (this.listener == null) {
            return;
        }
        AccessController.doPrivileged(() -> {
            try {
                CoreCryptoManager ccm = CoreCryptoManager.get((ISecurityInfoProvider)SecurityInitializer.getInstance().getSecurityInfoProvider());
                ICoreTrustStore store = ccm.getUserTrustStore();
                if (store instanceof CoreTrustStore) {
                    ((CoreTrustStore)store).unregisterCertAddedListener((CoreTrustStore.CertificateAddedListener)this.listener);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        });
        this.listener = null;
    }

    class ReloadProgramListener
    implements CoreTrustStore.CertificateAddedListener {
        ReloadProgramListener() {
        }

        public void certificateAdded(X509Certificate cert) {
            BProgramCode.this.getProgram().stop();
            BProgramCode.this.getProgram().start();
        }
    }
}

