/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tunnel;

import com.tridium.authn.BAuthenticationService;
import com.tridium.session.NiagaraSession;
import com.tridium.session.SessionManager;
import com.tridium.tunnel.BTestTunnel;
import com.tridium.tunnel.BTunnel;
import com.tridium.tunnel.BTunnelConnection;
import com.tridium.tunnel.TunnelConst;
import com.tridium.tunnel.TunnelException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.PrivilegedActionException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.authn.BAuthenticationScheme;
import javax.baja.data.BIDataValue;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.security.ServerTlsParameters;
import javax.baja.security.crypto.BSslTlsEnum;
import javax.baja.security.crypto.BTlsCipherSuiteGroup;
import javax.baja.security.crypto.ICryptoManager;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIService;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tunnel.authn.BTunnelCallbackHandler;
import javax.baja.user.BUser;
import javax.baja.util.IFuture;
import javax.baja.util.Queue;
import javax.baja.util.Worker;
import javax.net.ServerSocketFactory;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;

@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="tlsServerCertificate", type="String", defaultValue="tridium", facets={@Facet(name="BFacets.FIELD_EDITOR", value="BString.make(\"workbench:CertificateAliasFE\")"), @Facet(name="BFacets.UX_FIELD_EDITOR", value="BString.make(\"webEditors:CertificateAliasEditor\")"), @Facet(name="BFacets.SECURITY", value="true")}), @NiagaraProperty(name="tlsMinProtocol", type="BSslTlsEnum", defaultValue="BSslTlsEnum.DEFAULT", facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="cipherSuiteGroup", type="BTlsCipherSuiteGroup", defaultValue="BTlsCipherSuiteGroup.recommended", facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="serverPort", type="int", defaultValue="9973"), @NiagaraProperty(name="status", type="baja:Status", flags=67, defaultValue="BStatus.ok"), @NiagaraProperty(name="faultCause", type="String", flags=67, defaultValue=""), @NiagaraProperty(name="connections", type="int", flags=67, defaultValue="0")})
@NiagaraAction(name="pingConnections", flags=20)
public class BTunnelService
extends BComponent
implements BIService,
BIStatus,
TunnelConst {
    public static final Property enabled = BTunnelService.newProperty((int)0, (boolean)true, null);
    public static final Property tlsServerCertificate = BTunnelService.newProperty((int)0, (String)"tridium", (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"workbench:CertificateAliasFE")), (BFacets)BFacets.make((String)"uxFieldEditor", (BIDataValue)BString.make((String)"webEditors:CertificateAliasEditor"))), (BFacets)BFacets.make((String)"security", (boolean)true)));
    public static final Property tlsMinProtocol = BTunnelService.newProperty((int)0, (BValue)BSslTlsEnum.DEFAULT, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    public static final Property cipherSuiteGroup = BTunnelService.newProperty((int)0, (BValue)BTlsCipherSuiteGroup.recommended, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    public static final Property serverPort = BTunnelService.newProperty((int)0, (int)9973, null);
    public static final Property status = BTunnelService.newProperty((int)67, (BValue)BStatus.ok, null);
    public static final Property faultCause = BTunnelService.newProperty((int)67, (String)"", null);
    public static final Property connections = BTunnelService.newProperty((int)67, (int)0, null);
    public static final Action pingConnections = BTunnelService.newAction((int)20, null);
    public static final Type TYPE = Sys.loadType(BTunnelService.class);
    static final BIcon icon = BIcon.std((String)"cloud.png");
    private static final BTestTunnel UNKNOWN_TUNNEL = new BTestTunnel();
    private boolean alive = false;
    public static Logger log = Logger.getLogger("tunnel");
    private final Object mutex = new Object();
    private Clock.Ticket pingTicket;
    private Socket socket;
    private Server server;
    private final Hashtable<BAbsTime, BTunnelConnection> sessions = new Hashtable();
    private boolean threadAvailable = false;
    private Hashtable<String, BTunnel> tunnels = new Hashtable();
    private Worker workQueue = new Worker((Worker.ITodo)new Queue(100));

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public String getTlsServerCertificate() {
        return this.getString(tlsServerCertificate);
    }

    public void setTlsServerCertificate(String v) {
        this.setString(tlsServerCertificate, v, null);
    }

    public BSslTlsEnum getTlsMinProtocol() {
        return (BSslTlsEnum)this.get(tlsMinProtocol);
    }

    public void setTlsMinProtocol(BSslTlsEnum v) {
        this.set(tlsMinProtocol, (BValue)v, null);
    }

    public BTlsCipherSuiteGroup getCipherSuiteGroup() {
        return (BTlsCipherSuiteGroup)this.get(cipherSuiteGroup);
    }

    public void setCipherSuiteGroup(BTlsCipherSuiteGroup v) {
        this.set(cipherSuiteGroup, (BValue)v, null);
    }

    public int getServerPort() {
        return this.getInt(serverPort);
    }

    public void setServerPort(int v) {
        this.setInt(serverPort, v, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public int getConnections() {
        return this.getInt(connections);
    }

    public void setConnections(int v) {
        this.setInt(connections, v, null);
    }

    public void pingConnections() {
        this.invoke(pingConnections, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property p, Context c) {
        if (c != Context.decoding) {
            if (p == enabled || p == serverPort || p == tlsMinProtocol || p == tlsServerCertificate) {
                this.stopServer();
                try {
                    this.waitForPort(this.getServerPort());
                    this.startServer();
                }
                catch (ConnectException e) {
                    this.setStatus(BStatus.fault);
                    this.setFaultCause(e.getMessage());
                }
            }
            if (p == status && this.getStatus() == BStatus.ok) {
                this.setFaultCause("");
            }
        }
        super.changed(p, c);
    }

    public void doPingConnections() {
        Runnable r = this::implPingConnections;
        this.postAsync(r);
    }

    public void implPingConnections() {
        BTunnelConnection[] connections = this.connections();
        int i = connections.length;
        while (--i >= 0) {
            long now = System.currentTimeMillis();
            BTunnelConnection conn = connections[i];
            if (!conn.isConnected()) continue;
            if (conn.getLastRead().getMillis() + 60000L < now) {
                log.info("Disconnecting idle connection " + SlotPath.unescape((String)conn.toPathString()));
                conn.disconnect();
                continue;
            }
            if (conn.getLastWrite().getMillis() + 15000L >= now) continue;
            try {
                conn.sendPing();
            }
            catch (Exception x) {
                if (!conn.isConnected()) continue;
                log.severe("While pinging " + SlotPath.unescape((String)conn.toPathString()));
            }
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public void serviceStarted() throws Exception {
    }

    public void serviceStopped() throws Exception {
    }

    public void started() throws Exception {
        super.started();
        this.workQueue.start("Tunnel.Async");
        this.startServer();
    }

    public void stopped() throws Exception {
        super.stopped();
        this.stopServer();
        this.workQueue.stop();
    }

    public final IFuture postAsync(Runnable t) {
        if (!this.workQueue.isRunning()) {
            throw new NotRunningException();
        }
        ((Queue)this.workQueue.getTodo()).enqueue((Object)t);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BTunnelConnection[] connections() {
        Hashtable<BAbsTime, BTunnelConnection> hashtable = this.sessions;
        synchronized (hashtable) {
            int size = this.sessions.size();
            BTunnelConnection[] ret = new BTunnelConnection[size];
            Enumeration<BTunnelConnection> e = this.sessions.elements();
            for (int i = 0; i < size; ++i) {
                ret[i] = e.nextElement();
            }
            return ret;
        }
    }

    /*
     * Exception decompiling
     */
    protected void process(Socket request) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void register(BTunnel tunnel) {
        String id = tunnel.getIdentifier();
        if (this.tunnels.get(id) != null) {
            throw new IllegalArgumentException(id + " already in use.");
        }
        this.tunnels.put(id, tunnel);
    }

    protected void startPing() {
        if (this.pingTicket != null) {
            return;
        }
        this.pingTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.make((long)15000L), (Action)pingConnections, null);
    }

    protected void startServer() {
        if (this.alive) {
            return;
        }
        if (!this.getEnabled()) {
            this.setStatus(BStatus.disabled);
        } else {
            this.setStatus(BStatus.ok);
            this.alive = true;
            this.server = new Server();
            this.server.start();
        }
    }

    protected void stopPing() {
        if (this.pingTicket == null) {
            return;
        }
        this.pingTicket.cancel();
        this.pingTicket = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopServer() {
        this.alive = false;
        Object object = this.mutex;
        synchronized (object) {
            this.mutex.notifyAll();
        }
        if (this.server != null) {
            this.server.close();
        }
        this.server = null;
    }

    protected void unregister(BTunnel tunnel) {
        this.tunnels.remove(tunnel.getIdentifier());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addConnection(BTunnelConnection session) {
        Hashtable<BAbsTime, BTunnelConnection> hashtable = this.sessions;
        synchronized (hashtable) {
            this.sessions.put(session.getEstablished(), session);
            this.setConnections(this.sessions.size());
            if (this.sessions.size() == 1) {
                this.startPing();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeConnection(BTunnelConnection session) {
        Hashtable<BAbsTime, BTunnelConnection> hashtable = this.sessions;
        synchronized (hashtable) {
            this.sessions.remove(session.getEstablished());
            this.setConnections(this.sessions.size());
            if (this.sessions.size() == 0) {
                this.stopPing();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Socket dequeue() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.threadAvailable) {
                return null;
            }
            this.threadAvailable = true;
            while (this.alive && this.socket == null) {
                try {
                    this.mutex.wait();
                }
                catch (Exception exception) {}
            }
            Socket ret = this.socket;
            this.socket = null;
            this.threadAvailable = false;
            this.mutex.notifyAll();
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueue(Socket s) {
        Object object = this.mutex;
        synchronized (object) {
            while (this.alive && this.socket != null) {
                try {
                    this.mutex.wait();
                }
                catch (Exception exception) {}
            }
            this.socket = s;
            if (this.threadAvailable) {
                this.mutex.notifyAll();
            } else {
                new ServiceThread().start();
            }
        }
    }

    private BUser authenticateUser(BTunnelConnection session, DataInputStream in, DataOutputStream out) throws TunnelException {
        BUser requestedUser = session.getUser();
        BAuthenticationScheme authnScheme = null;
        BTunnelCallbackHandler handler = null;
        if (requestedUser != null && (authnScheme = requestedUser.getAuthenticationScheme()) != null) {
            handler = (BTunnelCallbackHandler)authnScheme.getAgentOn(BTunnelCallbackHandler.class);
        }
        if (handler == null) {
            throw new TunnelException(47, String.format("User <%s> does not support tunnel logins.", requestedUser));
        }
        handler.init(in, out);
        SessionManager.addSession((NiagaraSession)session);
        BAuthenticationService authenticationService = (BAuthenticationService)Sys.getService((Type)BAuthenticationService.TYPE);
        return authenticationService.authenticate((NiagaraSession)session, requestedUser, (CallbackHandler)((Object)handler), authnScheme);
    }

    /*
     * Loose catch block
     */
    private void waitForPort(int port) throws ConnectException {
        for (int i = 0; i < 2; ++i) {
            Socket socket = null;
            try {
                socket = new Socket("localhost", port);
                Thread.sleep(1000L);
                continue;
            }
            catch (IOException ignore) {
                return;
            }
            catch (InterruptedException e) {
                throw new ConnectException("Could not connect to socket. Cause is: " + e.getLocalizedMessage());
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        throw new ConnectException("Timed out waiting for socket to become available.");
    }

    private static /* synthetic */ Void lambda$process$2(BTunnelConnection finalSession, BTunnel finalBTunnel) {
        try {
            Subject subject = SessionManager.getAuthenticatedSubjectFromSession((String)finalSession.getSuperId());
            Subject.doAs(subject, () -> {
                finalBTunnel.service(finalSession);
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            log.log(Level.SEVERE, finalBTunnel.getIdentifier(), e.getException());
        }
        return null;
    }

    private static /* synthetic */ void lambda$process$0(String message) {
        log.severe(message);
    }

    private class ServiceThread
    extends Thread {
        boolean stopRequested;

        public ServiceThread() {
            super("TunnelService:ServiceThread");
            this.stopRequested = false;
        }

        @Override
        public void run() {
            try {
                while (!this.stopRequested) {
                    Socket s = BTunnelService.this.dequeue();
                    if (s == null) {
                        return;
                    }
                    BTunnelService.this.process(s);
                }
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Exception occurred processing serial tunnel queue, service thread terminating", t);
            }
        }

        public void requestStop() {
            this.stopRequested = true;
        }
    }

    private class Server
    extends Thread {
        ServerSocket srvr;

        public Server() {
            super("TunnelService:Server");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Server server = this;
            synchronized (server) {
                if (this.srvr != null) {
                    try {
                        this.srvr.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.srvr = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (BTunnelService.this.alive) {
                try {
                    if (this.srvr == null) {
                        Server server = this;
                        synchronized (server) {
                            ICryptoManager cryptoService;
                            int port = BTunnelService.this.getServerPort();
                            try {
                                cryptoService = (ICryptoManager)Sys.getService((Type)Sys.getType((String)"platCrypto:CertManagerService"));
                            }
                            catch (Exception e) {
                                throw new IOException("Unable to get crypto service instance");
                            }
                            ServerTlsParameters tlsParams = new ServerTlsParameters(BTunnelService.this.getTlsMinProtocol().getTag(), BTunnelService.this.getTlsServerCertificate(), BTunnelService.this.getCipherSuiteGroup().getCipherSuiteGroup());
                            ServerSocketFactory fact = cryptoService.getServerSocketFactory(tlsParams);
                            this.srvr = fact.createServerSocket(BTunnelService.this.getServerPort());
                            log.info("Tunnel server started on port " + port);
                        }
                    }
                    BTunnelService.this.setStatus(BStatus.ok);
                }
                catch (Exception x) {
                    BTunnelService.this.setStatus(BStatus.fault);
                    BTunnelService.this.setFaultCause("Cannot create server socket.");
                    log.log(Level.SEVERE, "Cannot create server socket", x);
                    BTunnelService.this.alive = false;
                    Object object = BTunnelService.this.mutex;
                    synchronized (object) {
                        BTunnelService.this.mutex.notifyAll();
                    }
                    BTunnelService.this.server = null;
                    return;
                }
                try {
                    Socket req = this.srvr.accept();
                    try {
                        req.setTcpNoDelay(true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    log.fine("Request received: " + req.getInetAddress().getHostAddress());
                    BTunnelService.this.enqueue(req);
                }
                catch (Exception x) {
                    if (!BTunnelService.this.alive) continue;
                    log.log(Level.SEVERE, "Server socket accept", x);
                }
            }
            log.fine("Tunnel server stopped.");
        }
    }
}

