/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.videoStream.fox;

import com.tridium.fox.session.FoxSession;
import com.tridium.fox.sys.BFoxChannelRegistry;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.videoDriver.enums.BFoxVideoStreamEnum;
import com.tridium.videoDriver.enums.BVideoAspectRatioEnum;
import com.tridium.videoDriver.enums.BVideoCompressionEnum;
import com.tridium.videoDriver.enums.BVideoFrameRateEnum;
import com.tridium.videoDriver.enums.BVideoResolutionEnum;
import com.tridium.videoDriver.videoStream.BIVideoSource;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.IVideoDestination;
import com.tridium.videoDriver.videoStream.IVideoSession;
import com.tridium.videoDriver.videoStream.decoder.IVideoDecoder;
import com.tridium.videoDriver.videoStream.fox.BFoxVideoChannel;
import com.tridium.videoDriver.videoStream.fox.FoxVideoStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BFoxVideoSource
extends BVector
implements BIVideoSource {
    public static final Type TYPE = Sys.loadType(BFoxVideoSource.class);
    protected static Object videoStreamIdMonitor = new Object();
    protected static int nextVideoStreamId = 0;
    protected static Logger log = Logger.getLogger("fox.videoSource");

    public Type getType() {
        return TYPE;
    }

    public BIVideoSource getVideoSourceParent() {
        BComplex parent;
        for (parent = this.getParent(); parent != null && !(parent instanceof BIVideoSource); parent = parent.getParent()) {
        }
        return (BIVideoSource)parent;
    }

    @Override
    public BVideoCompressionEnum getPreferredCompression() {
        return this.getVideoSourceParent().getPreferredCompression();
    }

    @Override
    public BVideoFrameRateEnum getPreferredFrameRate() {
        return this.getVideoSourceParent().getPreferredFrameRate();
    }

    @Override
    public BVideoResolutionEnum getPreferredResolution() {
        return this.getVideoSourceParent().getPreferredResolution();
    }

    @Override
    public void initPlaybackParams(BPlaybackParams playbackParams, IVideoSession videoSession) {
        this.getVideoSourceParent().initPlaybackParams(playbackParams, videoSession);
    }

    @Override
    public boolean isFoxVideoStreamPreferred() {
        return this.getVideoSourceParent().isFoxVideoStreamPreferred();
    }

    @Override
    public boolean isTimestampPreferred() {
        return this.getVideoSourceParent().isTimestampPreferred();
    }

    @Override
    public BSimple getPreferredBackgroundColor() {
        return this.getVideoSourceParent().getPreferredBackgroundColor();
    }

    @Override
    public BVideoAspectRatioEnum getPreferredAspectRatio() {
        return this.getVideoSourceParent().getPreferredAspectRatio();
    }

    @Override
    public IVideoDecoder makeVideoDecoder(BPlaybackParams playbackParams) {
        return this.getVideoSourceParent().makeVideoDecoder(playbackParams);
    }

    @Override
    public void streamToDestination(BPlaybackParams playbackParams, IVideoDestination videoDestination) {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Stream to Destination.\n  Fox Video Source Ord = " + this.getSlotPathOrd() + "\n  Playback Ord = " + playbackParams.getVideoSourceOrd() + "\n  Video destination class = " + videoDestination.getClass().getName());
            }
            new FoxVideoStream(this, playbackParams, this.getNextVideoStreamId(), videoDestination);
        }
        catch (Exception e) {
            if (e instanceof BajaRuntimeException) {
                Throwable cause = e;
                while (cause != null && !(cause instanceof InterruptedException)) {
                    if (cause instanceof BajaRuntimeException) {
                        cause = ((BajaRuntimeException)cause).getCause();
                        continue;
                    }
                    cause = null;
                }
                if (cause != null && cause instanceof InterruptedException) {
                    return;
                }
            }
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    @Override
    public boolean supportsPlaybackControl() {
        return this.getVideoSourceParent().supportsPlaybackControl();
    }

    @Override
    public BFoxVideoStreamEnum getFoxVideoStreamSetting() {
        return this.getVideoSourceParent().getFoxVideoStreamSetting();
    }

    @Override
    public BRelTime getInterframeTimeout() {
        return this.getVideoSourceParent().getInterframeTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getNextVideoStreamId() {
        Object object = videoStreamIdMonitor;
        synchronized (object) {
            return nextVideoStreamId++;
        }
    }

    protected String getFoxWorkbenchRemoteSessionId() {
        return BFoxVideoSource.getFoxWorkbenchRemoteSessionId((BObject)this);
    }

    public static String getFoxWorkbenchRemoteSessionId(BObject proxyFromStation) {
        BFoxSession workbenchSession = (BFoxSession)BOrd.toSession((BObject)proxyFromStation);
        if (workbenchSession == null) {
            throw new SessionClosedException();
        }
        BFoxClientConnection connectionFromWorkbenchToStation = workbenchSession.getConnection();
        FoxSession stationSession = connectionFromWorkbenchToStation.session();
        String workbenchIdFromPerspectiveOfTheStation = stationSession.getRemoteId();
        return workbenchIdFromPerspectiveOfTheStation;
    }

    static {
        BFoxChannelRegistry foxRegistry = BFoxChannelRegistry.getPrototype();
        if (foxRegistry.get("FoxVideoChannel") == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Registering fox channel: FoxVideoChannel");
            }
            foxRegistry.add("FoxVideoChannel", (BValue)new BFoxVideoChannel());
        } else if (log.isLoggable(Level.FINE)) {
            log.fine("Not registering fox channel: FoxVideoChannel");
        }
    }

    public static class SessionClosedException
    extends RuntimeException {
    }
}

