/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.videoStream.fox;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.FoxCircuit;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.IVideoDestination;
import com.tridium.videoDriver.videoStream.fox.BFoxVideoSource;
import com.tridium.videoDriver.videoStream.fox.ClientSideVideoReceiver;
import com.tridium.videoDriver.videoStream.fox.ClientVideoInputStream;
import com.tridium.videoDriver.videoStream.fox.FoxVideoStream;
import com.tridium.videoDriver.videoStream.fox.StationSideVideoCoordinator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.sys.BComplex;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BFoxVideoChannel
extends BFoxChannel {
    public static final Type TYPE = Sys.loadType(BFoxVideoChannel.class);
    protected StationSideVideoCoordinator videoCoordinator;
    protected BInteger bWbProxyId = null;
    protected ClientSideVideoReceiver videoReceiver;
    protected static Logger clientLog = Logger.getLogger("fox.videoChannel.client");
    protected static Logger serverLog = Logger.getLogger("fox.videoChannel.server");
    public static final String CHANNEL_NAME = "FoxVideoChannel";

    public Type getType() {
        return TYPE;
    }

    public BFoxVideoChannel() {
        super(CHANNEL_NAME);
    }

    public void sessionOpened() throws Exception {
        if (this.videoCoordinator == null) {
            this.videoCoordinator = new StationSideVideoCoordinator();
        }
    }

    public void sessionClosed(Throwable cause) {
        if (this.videoCoordinator != null) {
            this.videoCoordinator.stopCoordinating();
        }
    }

    public BPlaybackParams getPlaybackParamsForStream(String videoClientId, int videoStreamId) throws Exception {
        if (clientLog.isLoggable(Level.FINE)) {
            this.trace(clientLog, videoClientId, videoStreamId, "getPlaybackParamsForStream.");
        }
        FoxResponse rsp = this.sendRequestFromClientToStation("getPlaybackParamsForStream", videoClientId, videoStreamId, false);
        String playbackParamsXml = rsp.getString("playbackParams", null);
        if (clientLog.isLoggable(Level.FINE)) {
            this.trace(clientLog, videoClientId, videoStreamId, "playbackParamsXml=" + playbackParamsXml);
        }
        if (playbackParamsXml == null) {
            return null;
        }
        return (BPlaybackParams)ValueDocDecoder.unmarshal((String)playbackParamsXml);
    }

    public void pauseVideoStream(String videoClientId, int videoStreamId) throws Exception {
        this.sendRequestFromClientToStation("pauseVideoStream", videoClientId, videoStreamId, true);
    }

    public void resumeVideoStream(String videoClientId, int videoStreamId) throws Exception {
        this.sendRequestFromClientToStation("resumeVideoStream", videoClientId, videoStreamId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FoxResponse resumeVideoStream(FoxRequest request) throws Exception {
        String videoClient;
        block6: {
            videoClient = request.getString("videoClient", "Wb");
            try {
                int videoClientId = request.getInt("videoClientId");
                videoClient = videoClient + ':' + videoClientId;
            }
            catch (IOException ioe) {
                if (!serverLog.isLoggable(Level.FINE)) break block6;
                serverLog.fine("NOTE: Resuming video stream...this video client does not have a unique integer in this server. This must be enterprise video support. Using unique name instead: " + videoClient);
            }
        }
        int videoStreamId = request.getInt("videoStreamId");
        try {
            this.videoCoordinator.resumeVideoStream(videoClient, videoStreamId);
            FoxResponse foxResponse = new FoxResponse(request);
            return foxResponse;
        }
        finally {
            if (serverLog.isLoggable(Level.FINE)) {
                this.trace(serverLog, videoClient, videoStreamId, "DONE: resumeVideoStream.");
            }
        }
    }

    public InputStream openVideoStream(BObject proxyObject, String videoClient, BPlaybackParams playbackParams, int videoStreamId, IVideoDestination videoDestination, FoxVideoStream foxVideoStream) throws Exception {
        FoxRequest request;
        block8: {
            if (clientLog.isLoggable(Level.FINE)) {
                this.trace(clientLog, videoClient, videoStreamId, "Open Video Stream{Video Source Ord = " + playbackParams.getVideoSourceOrd() + "}");
            }
            request = this.makeRequest("openVideoStream");
            try {
                this.bWbProxyId = BInteger.make((String)BFoxVideoSource.getFoxWorkbenchRemoteSessionId(proxyObject));
                request.add("videoClientId", this.bWbProxyId.getInt());
            }
            catch (Exception e) {
                if (!clientLog.isLoggable(Level.FINE)) break block8;
                this.trace(clientLog, videoClient, videoStreamId, "Unable to look-up videoClientId. This is ok if the video server's videoDriver.jar is created after April 1, 2009.");
            }
        }
        request.add("videoClient", videoClient);
        request.add("videoStreamId", videoStreamId);
        ByteArrayOutputStream bogOut = new ByteArrayOutputStream();
        ValueDocEncoder bog = new ValueDocEncoder((OutputStream)bogOut);
        bog.encodeDocument((BValue)playbackParams);
        bog.flush();
        bog.close();
        request.add("playbackParams", new String(bogOut.toByteArray()));
        if (this.videoReceiver == null || this.videoReceiver.isDone()) {
            if (clientLog.isLoggable(Level.FINE)) {
                this.trace(clientLog, videoClient, videoStreamId, "openVideoStream() start videoReceiver");
            }
            this.videoReceiver = new ClientSideVideoReceiver(this, videoClient, this.bWbProxyId);
            this.videoReceiver.startVideoReceiver();
        }
        ClientVideoInputStream cin = this.videoReceiver.getInputStream(videoStreamId, videoDestination, foxVideoStream);
        try {
            FoxResponse rsp = this.sendSync(request);
            if (clientLog.isLoggable(Level.FINE)) {
                this.trace(clientLog, videoClient, videoStreamId, "openVideoStream() sent openVideoStream request ");
            }
            playbackParams.copyFrom((BComplex)this.extractPlaybackParms((FoxMessage)rsp));
            return cin;
        }
        catch (Exception e) {
            cin.close();
            throw e;
        }
    }

    protected void closeVideoStream(String videoClientId, int videoStreamId) throws Exception {
        BFoxClientConnection foxConnection;
        if (clientLog.isLoggable(Level.FINE)) {
            this.trace(clientLog, videoClientId, videoStreamId, "Close Video Stream");
        }
        if ((foxConnection = this.getClientConnection()) == null) {
            return;
        }
        BFoxSession foxSession = foxConnection.getFoxSession();
        if (foxSession == null) {
            return;
        }
        if (foxSession.isConnected()) {
            FoxRequest request = this.makeRequest("closeVideoStream");
            if (this.bWbProxyId != null) {
                request.add("videoClientId", this.bWbProxyId.getInt());
                String extraSuffix = ":" + this.bWbProxyId;
                if (videoClientId.endsWith(extraSuffix)) {
                    request.add("videoClient", videoClientId.substring(0, videoClientId.length() - extraSuffix.length()));
                } else {
                    request.add("videoClient", videoClientId);
                }
            } else {
                request.add("videoClient", videoClientId);
            }
            request.add("videoStreamId", videoStreamId);
            if (clientLog.isLoggable(Level.FINE)) {
                this.trace(clientLog, request, "Send:closeVideoStream");
            }
            this.sendAsync(request);
        } else if (clientLog.isLoggable(Level.FINE)) {
            clientLog.fine("Unable to ask station to close video stream - connection lost. Video stream id = " + videoStreamId + " Video client id = " + videoClientId);
        }
    }

    private BPlaybackParams extractPlaybackParms(FoxMessage videoOpenReq) {
        try {
            String bogText = videoOpenReq.getString("playbackParams", "");
            if (bogText.length() == 0) {
                return null;
            }
            ValueDocDecoder bogDecoder = new ValueDocDecoder((InputStream)new ByteArrayInputStream(bogText.getBytes()));
            return (BPlaybackParams)bogDecoder.decodeDocument();
        }
        catch (Exception e) {
            return null;
        }
    }

    private FoxResponse sendRequestFromClientToStation(String requestId, String videoClientId, int videoStreamId, boolean async) throws Exception {
        BFoxClientConnection foxConnection = this.getClientConnection();
        if (foxConnection == null) {
            return null;
        }
        BFoxSession foxSession = foxConnection.getFoxSession();
        if (foxSession == null || foxSession.isConnected()) {
            FoxRequest request = this.makeRequest(requestId);
            if (this.bWbProxyId != null) {
                request.add("videoClientId", this.bWbProxyId.getInt());
                String extraSuffix = ":" + this.bWbProxyId;
                if (videoClientId.endsWith(extraSuffix)) {
                    request.add("videoClient", videoClientId.substring(0, videoClientId.length() - extraSuffix.length()));
                } else {
                    request.add("videoClient", videoClientId);
                }
            } else {
                request.add("videoClient", videoClientId);
            }
            request.add("videoStreamId", videoStreamId);
            if (clientLog.isLoggable(Level.FINE)) {
                this.trace(clientLog, videoClientId, videoStreamId, "Send:" + requestId);
            }
            if (async) {
                this.sendAsync(request);
                return null;
            }
            return this.sendSync(request);
        }
        if (clientLog.isLoggable(Level.FINE)) {
            this.trace(clientLog, videoClientId, videoStreamId, "Request id " + requestId + " - connection lost.");
        }
        return null;
    }

    public void circuitOpened(FoxCircuit circuit) throws Throwable {
        if (circuit.command == "FoxVideoCircuit") {
            if (serverLog.isLoggable(Level.FINE)) {
                serverLog.fine("circuitOpened: FoxVideoCircuit");
            }
            if (this.videoCoordinator == null) {
                this.videoCoordinator = new StationSideVideoCoordinator();
            }
            this.videoCoordinator.coordinateVideoForClient(circuit);
        } else {
            super.circuitOpened(circuit);
        }
    }

    public FoxResponse process(FoxRequest request) throws Throwable {
        String command = request.command;
        if (serverLog.isLoggable(Level.FINE)) {
            this.trace(serverLog, request, "receive:" + command);
        }
        if (command == "openVideoStream") {
            return this.openVideoStream(request);
        }
        if (command == "closeVideoStream") {
            this.closeVideoStream(request);
            return null;
        }
        if (command == "pauseVideoStream") {
            return this.pauseVideoStream(request);
        }
        if (command == "resumeVideoStream") {
            return this.resumeVideoStream(request);
        }
        if (command == "getPlaybackParamsForStream") {
            return this.getPlaybackParamsForStream(request);
        }
        throw new InvalidCommandException(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FoxResponse openVideoStream(FoxRequest request) throws Exception {
        String videoClient;
        block7: {
            videoClient = request.getString("videoClient", "Wb");
            try {
                int videoClientId = request.getInt("videoClientId");
                videoClient = videoClient + ':' + videoClientId;
            }
            catch (IOException ioe) {
                if (!serverLog.isLoggable(Level.FINE)) break block7;
                serverLog.fine("NOTE: This video client does not have a unique integer in this server. This must be enterprise video support. Using unique name instead: " + videoClient);
            }
        }
        int videoStreamId = request.getInt("videoStreamId");
        try {
            BPlaybackParams playbackParams = this.extractPlaybackParms((FoxMessage)request);
            if (serverLog.isLoggable(Level.FINE)) {
                this.trace(serverLog, videoClient, videoStreamId, "Open Video Stream{Video Source Ord = " + playbackParams.getVideoSourceOrd() + "}");
            }
            this.videoCoordinator.openStreamAsync(playbackParams, videoClient, videoStreamId);
            FoxResponse rsp = new FoxResponse(request);
            ByteArrayOutputStream bogOut = new ByteArrayOutputStream();
            ValueDocEncoder bog = new ValueDocEncoder((OutputStream)bogOut);
            bog.encodeDocument((BValue)playbackParams);
            bog.flush();
            bog.close();
            rsp.add("playbackParams", new String(bogOut.toByteArray()));
            FoxResponse foxResponse = rsp;
            return foxResponse;
        }
        finally {
            if (serverLog.isLoggable(Level.FINE)) {
                this.trace(serverLog, videoClient, videoStreamId, "Done: openVideoStream.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FoxResponse pauseVideoStream(FoxRequest request) throws Exception {
        String videoClient = request.getString("videoClient", "Wb");
        int videoClientId = request.getInt("videoClientId", -1);
        if (videoClientId >= 0) {
            videoClient = videoClient + ':' + videoClientId;
        }
        int videoStreamId = request.getInt("videoStreamId");
        try {
            this.videoCoordinator.pauseVideoStream(videoClient, videoStreamId);
            FoxResponse foxResponse = new FoxResponse(request);
            return foxResponse;
        }
        finally {
            if (serverLog.isLoggable(Level.FINE)) {
                this.trace(serverLog, videoClient, videoStreamId, "DONE: pauseVideoStream.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FoxResponse getPlaybackParamsForStream(FoxRequest request) throws Exception {
        String videoClient;
        block7: {
            videoClient = request.getString("videoClient", "Wb");
            try {
                int videoClientId = request.getInt("videoClientId");
                videoClient = videoClient + ':' + videoClientId;
            }
            catch (IOException ioe) {
                if (!serverLog.isLoggable(Level.FINE)) break block7;
                serverLog.fine("Getting playback params for video stream...this video client does not have a unique integer in this server. This must be enterprise video support. Using unique name instead: " + videoClient);
            }
        }
        int videoStreamId = request.getInt("videoStreamId");
        try {
            BPlaybackParams playbackParams = this.videoCoordinator.getPlaybackParamsForStream(videoClient, videoStreamId);
            FoxResponse foxRsp = new FoxResponse(request);
            if (playbackParams != null) {
                foxRsp.add("playbackParams", ValueDocEncoder.marshal((BValue)playbackParams));
            }
            FoxResponse foxResponse = foxRsp;
            return foxResponse;
        }
        finally {
            if (serverLog.isLoggable(Level.FINE)) {
                this.trace(serverLog, videoClient, videoStreamId, "DONE: getPlaybackParamsForStream.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeVideoStream(FoxRequest request) throws Exception {
        String videoClient;
        block6: {
            videoClient = request.getString("videoClient", "Wb");
            try {
                int videoClientId = request.getInt("videoClientId");
                videoClient = videoClient + ':' + videoClientId;
            }
            catch (IOException ioe) {
                if (!serverLog.isLoggable(Level.FINE)) break block6;
                serverLog.fine("NOTE: This video client does not have a unique integer in this server. This must be enterprise video support. Using unique name instead: " + videoClient);
            }
        }
        int videoStreamId = request.getInt("videoStreamId");
        try {
            this.videoCoordinator.closeVideoStream(videoClient, videoStreamId);
        }
        finally {
            if (serverLog.isLoggable(Level.FINE)) {
                this.trace(serverLog, request, "DONE: closeVideoStream.");
            }
        }
    }

    protected void trace(Logger log, FoxRequest request, String traceStr) {
        String cl = "Wb";
        try {
            cl = request.getString("videoClient");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        int cId = -1;
        try {
            cId = request.getInt("videoClientId");
            cl = cl + ":" + cId;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        int sId = -1;
        try {
            sId = request.getInt("videoStreamId");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.trace(log, cl, sId, traceStr);
    }

    protected void trace(Logger log, String vcl, int sId, String traceStr) {
        log.fine(this.dtag(vcl, sId) + traceStr);
    }

    protected void trace(Logger log, String vcl, int sId, String traceStr, Exception e) {
        log.log(Level.FINE, this.dtag(vcl, sId) + traceStr, e);
    }

    private String dtag(String videoClient, int videoStreamId) {
        return videoClient + "{vsId:" + videoStreamId + "}";
    }
}

