/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.videoStream.decoder;

import com.tridium.videoDriver.videoStream.decoder.HttpStatusLineHelper;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

public class HttpMultipartMimeHelper {
    protected HttpStatusLineHelper statusLine;
    protected Hashtable<String, String> responseHeaderFields = new Hashtable();

    public HttpMultipartMimeHelper(InputStream in, String videoPushBoundary) throws IOException {
        this.readResponse(in, videoPushBoundary);
    }

    protected void readVideoBoundary(InputStream in, String videoPushBoundary) throws IOException {
        byte[] videoBoundaryBytes = new byte[videoPushBoundary.length()];
        for (int i = 0; i < videoBoundaryBytes.length; ++i) {
            int nextByte = in.read();
            if (nextByte == -1) {
                throw new EOFException("EOF while reading 'videoBoundaryReceived'");
            }
            videoBoundaryBytes[i] = (byte)nextByte;
        }
        String videoBoundaryReceived = new String(videoBoundaryBytes, "ASCII");
        if (!videoBoundaryReceived.equals(videoPushBoundary)) {
            throw new IOException("The received video boundary string does not match what was expected. Received=" + videoBoundaryReceived + " Expected=" + videoPushBoundary);
        }
    }

    protected void readResponse(InputStream in, String videoPushBoundary) throws IOException {
        int ch;
        if (videoPushBoundary != null && videoPushBoundary.length() > 0) {
            this.readVideoBoundary(in, videoPushBoundary);
        }
        this.statusLine = new HttpStatusLineHelper(in);
        StringBuffer sbuf = new StringBuffer(30);
        while (true) {
            String name = null;
            String value = null;
            sbuf.setLength(0);
            ch = in.read();
            if (ch == -1 || ch == 13) break;
            while (ch != -1 && ch != 58) {
                sbuf.append((char)ch);
                ch = in.read();
            }
            name = sbuf.toString();
            ch = in.read();
            while (ch != -1 && ch == 32) {
                ch = in.read();
            }
            sbuf.setLength(0);
            while (ch != -1 && ch != 13) {
                sbuf.append((char)ch);
                ch = in.read();
            }
            ch = in.read();
            value = sbuf.toString();
            if (name == null || value == null) continue;
            this.responseHeaderFields.put(name.toLowerCase(), value);
        }
        ch = in.read();
    }

    public HttpStatusLineHelper getStatusLine() {
        return this.statusLine;
    }

    public Hashtable<String, String> getResponseHeaderFields() {
        return this.responseHeaderFields;
    }
}

