/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.alarm.monitoring;

import com.tridium.videoDriver.alarm.monitoring.BMonitorNotification;
import java.util.logging.Logger;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIMixIn;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BMonitor
extends BComponent
implements BIMixIn {
    public static final Property enabled = BMonitor.newProperty((int)0, (boolean)true, null);
    public static final Property sourceToMonitor = BMonitor.newProperty((int)0, (BValue)BOrd.DEFAULT, null);
    public static final Property lastValueSignaled = BMonitor.newProperty((int)4, (BValue)new BComponent(), null);
    public static final Action signalNotification = BMonitor.newAction((int)4, (BValue)new BComponent(), null);
    public static final Type TYPE = Sys.loadType(BMonitor.class);
    private Logger log = Logger.getLogger("monitor");

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BOrd getSourceToMonitor() {
        return (BOrd)this.get(sourceToMonitor);
    }

    public void setSourceToMonitor(BOrd v) {
        this.set(sourceToMonitor, (BValue)v, null);
    }

    public BValue getLastValueSignaled() {
        return this.get(lastValueSignaled);
    }

    public void setLastValueSignaled(BValue v) {
        this.set(lastValueSignaled, v, null);
    }

    public void signalNotification(BValue value) {
        this.invoke(signalNotification, value, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doSignalNotification(BValue value) {
        if (!this.getEnabled()) {
            return;
        }
        if (!this.monitorSourceValid()) {
            this.log.info("The monitor source type is invalid for use with this monitor (" + this.getType() + ")");
            return;
        }
        this.setLastValueSignaled(value.newCopy());
        this.raiseNotification();
    }

    private boolean monitorSourceValid() {
        BObject source = this.getMonitorSource();
        if (source == null) {
            return false;
        }
        return source.getType().is(this.getMonitorSourceType());
    }

    public BObject getMonitorSource() {
        if (this.getSourceToMonitor().isNull()) {
            return null;
        }
        BObject source = this.getSourceToMonitor().get((BObject)this);
        return source;
    }

    private void raiseNotification() {
        Type notificationType = this.getNotificationType();
        if (!notificationType.is(BMonitorNotification.TYPE)) {
            return;
        }
        BMonitorNotification notification = (BMonitorNotification)notificationType.getInstance();
        notification.setMonitorOrd(this.getHandleOrd());
        notification.raise(true);
    }

    protected abstract Type getMonitorSourceType();

    protected abstract Type getNotificationType();
}

