/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.alarm;

import com.tridium.videoDriver.alarm.BIVideoAlarmRecorder;
import com.tridium.videoDriver.camera.BIRemoteVideoCamera;
import com.tridium.videoDriver.camera.control.BIVideoMoveToPresetControl;
import javax.baja.agent.AgentList;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.status.BStatusBoolean;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BVideoAlarmExtParameters
extends BComponent {
    public static final Property videoCamera = BVideoAlarmExtParameters.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"uxFieldEditor", (BIDataValue)BString.make((String)"nmodule/videoDriver/rc/alarm/VideoCameraChooser")));
    public static final Property startRecording = BVideoAlarmExtParameters.newProperty((int)8, (BValue)new BStatusBoolean(true), null);
    public static final Property gotoPreset = BVideoAlarmExtParameters.newProperty((int)0, (boolean)false, null);
    public static final Property cameraPreset = BVideoAlarmExtParameters.newProperty((int)0, (BValue)BString.make((String)""), null);
    public static final Property wasThisAlarmExtParametersJustAdded = BVideoAlarmExtParameters.newProperty((int)69, (boolean)false, null);
    public static final Property sendAlarmToDisplay = BVideoAlarmExtParameters.newProperty((int)0, (boolean)false, null);
    public static final Type TYPE = Sys.loadType(BVideoAlarmExtParameters.class);
    protected AlarmExtSubscriber alarmExtSubscriber;
    protected BAlarmSourceExt alarmSourceExt;
    private static final BIcon icon = BIcon.make((String)"module://videoDriver/icons/alarmExtParmeters.png");

    public BOrd getVideoCamera() {
        return (BOrd)this.get(videoCamera);
    }

    public void setVideoCamera(BOrd v) {
        this.set(videoCamera, (BValue)v, null);
    }

    public BStatusBoolean getStartRecording() {
        return (BStatusBoolean)this.get(startRecording);
    }

    public void setStartRecording(BStatusBoolean v) {
        this.set(startRecording, (BValue)v, null);
    }

    public boolean getGotoPreset() {
        return this.getBoolean(gotoPreset);
    }

    public void setGotoPreset(boolean v) {
        this.setBoolean(gotoPreset, v, null);
    }

    public BValue getCameraPreset() {
        return this.get(cameraPreset);
    }

    public void setCameraPreset(BValue v) {
        this.set(cameraPreset, v, null);
    }

    public boolean getWasThisAlarmExtParametersJustAdded() {
        return this.getBoolean(wasThisAlarmExtParametersJustAdded);
    }

    public void setWasThisAlarmExtParametersJustAdded(boolean v) {
        this.setBoolean(wasThisAlarmExtParametersJustAdded, v, null);
    }

    public boolean getSendAlarmToDisplay() {
        return this.getBoolean(sendAlarmToDisplay);
    }

    public void setSendAlarmToDisplay(boolean v) {
        this.setBoolean(sendAlarmToDisplay, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public AgentList getAgents(Context cx) {
        AgentList al = super.getAgents(cx);
        al.add("workbench:NavMenuAgent");
        return al;
    }

    public void started() {
        this.alarmExtSubscriber = new AlarmExtSubscriber();
        this.autoConfigureCamera();
        this.mergeMetaData();
    }

    protected BIVideoAlarmRecorder getParentCamera() {
        BComplex parent;
        for (parent = this.getParent(); parent != null && !(parent instanceof BIVideoAlarmRecorder); parent = parent.getParent()) {
        }
        return (BIVideoAlarmRecorder)parent;
    }

    protected void autoConfigureCamera() {
        BIVideoAlarmRecorder camera = this.getParentCamera();
        if (camera != null) {
            if (camera instanceof BComponent) {
                this.setVideoCamera(BOrd.make((String)("station:|" + ((BComponent)camera).getSlotPathOrd().toString())));
            } else {
                throw new IllegalStateException("Nav ancestor is a BIVideoAlarmRecorder but is not a BComponent.");
            }
        }
    }

    public void changed(Property property, Context context) {
        if (this.isRunning() && context != Context.decoding) {
            if (property.equals(videoCamera)) {
                try {
                    BObject resolvedObject = this.getVideoCamera().get((BObject)this);
                    if (resolvedObject instanceof BComponent) {
                        BComponent resolvedComponent = (BComponent)resolvedObject;
                        if (resolvedObject instanceof BIVideoMoveToPresetControl) {
                            BIVideoMoveToPresetControl presettable = (BIVideoMoveToPresetControl)resolvedObject;
                            Action moveToPresetAction = presettable.getMoveToPresetAction();
                            BValue moveToPresetDefault = resolvedComponent.getActionParameterDefault(moveToPresetAction);
                            this.setCameraPreset(moveToPresetDefault);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.mergeMetaData();
        }
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BAlarmSourceExt;
    }

    public boolean isNavChild() {
        Property parentProp = this.getPropertyInParent();
        if (parentProp == null) {
            return false;
        }
        BComplex parentComplexObject = this.getParent();
        if (parentComplexObject == null) {
            return false;
        }
        BFacets parentPropFacets = parentComplexObject.getSlotFacets((Slot)parentProp);
        boolean forceNav = parentPropFacets.getb("forceNav", false);
        return forceNav;
    }

    public BAlarmSourceExt getAlarmExt() {
        if (this.alarmSourceExt == null) {
            this.alarmSourceExt = (BAlarmSourceExt)this.getParent();
        }
        return this.alarmSourceExt;
    }

    protected void cleanupMetaData() {
        BFacets alarmSourceMetaDataAtTopOfThisMethod = this.getAlarmExt().getMetaData();
        BFacets updatedMetaData = alarmSourceMetaDataAtTopOfThisMethod;
        if (updatedMetaData.get("cameraOrd") != null) {
            updatedMetaData = BFacets.makeRemove((BFacets)updatedMetaData, (String)"cameraOrd");
        }
        if (updatedMetaData.get("cameraHandleOrd") != null) {
            updatedMetaData = BFacets.makeRemove((BFacets)updatedMetaData, (String)"cameraHandleOrd");
        }
        if (updatedMetaData.get("cameraPreset") != null) {
            updatedMetaData = BFacets.makeRemove((BFacets)updatedMetaData, (String)"cameraPreset");
        }
        if (updatedMetaData.get("startRecording") != null) {
            updatedMetaData = BFacets.makeRemove((BFacets)updatedMetaData, (String)"startRecording");
        }
        if (updatedMetaData != alarmSourceMetaDataAtTopOfThisMethod) {
            this.getAlarmExt().setMetaData(updatedMetaData);
        }
    }

    protected String getAbsoluteOrdSting(BComponent camera) {
        BOrd videoCameraOrd = camera.getAbsoluteOrd();
        String absoluteOrdString = videoCameraOrd.toString();
        if (absoluteOrdString.startsWith("local:|")) {
            return absoluteOrdString.substring(7);
        }
        return absoluteOrdString;
    }

    protected BOrd checkForRemoteCameraOrd(BOrd videoCameraOrd, BComponent videoCameraComponent, boolean handleOrd) {
        if (videoCameraComponent instanceof BIRemoteVideoCamera) {
            BIRemoteVideoCamera remoteVideoCamera = (BIRemoteVideoCamera)videoCameraComponent;
            return remoteVideoCamera.getRemoteVideoOrd();
        }
        return null;
    }

    protected void mergeMetaData() {
        BFacets alarmSourceMetaData = this.getAlarmExt().getMetaData();
        BOrd videoCameraOrd = this.getVideoCamera();
        boolean startRecording = this.getStartRecording().getValue();
        boolean gotoPreset = this.getGotoPreset();
        boolean sendAlarmToDisplay = this.getSendAlarmToDisplay();
        BValue cameraPreset = this.getCameraPreset();
        if (videoCameraOrd != null && !videoCameraOrd.isNull() && videoCameraOrd.toString().trim().length() > 0) {
            BOrd remoteVideoOrd;
            BObject videoCameraObject = videoCameraOrd.get((BObject)this);
            if (videoCameraObject instanceof BComponent && (remoteVideoOrd = this.checkForRemoteCameraOrd(videoCameraOrd, (BComponent)videoCameraObject, false)) != null) {
                videoCameraOrd = remoteVideoOrd;
            }
            BFacets updatedMetaData = BVideoAlarmExtParameters.mergeCameraOrd(alarmSourceMetaData, videoCameraOrd);
            if (videoCameraObject instanceof BComponent) {
                BOrd remoteVideoHandleOrd;
                BOrd cameraHandleOrd = videoCameraObject.asComponent().getHandleOrd();
                if (Sys.atSteadyState() && (remoteVideoHandleOrd = this.checkForRemoteCameraOrd(videoCameraOrd, (BComponent)videoCameraObject, true)) != null) {
                    cameraHandleOrd = remoteVideoHandleOrd;
                }
                updatedMetaData = BVideoAlarmExtParameters.mergeCameraHandleOrd(updatedMetaData, cameraHandleOrd);
            }
            updatedMetaData = BVideoAlarmExtParameters.mergeStartRecording(updatedMetaData, startRecording);
            updatedMetaData = BVideoAlarmExtParameters.mergeCameraPreset(updatedMetaData, startRecording, cameraPreset, gotoPreset, videoCameraOrd);
            if ((updatedMetaData = BVideoAlarmExtParameters.mergeSendAlarmToDisplay(updatedMetaData, sendAlarmToDisplay)) != alarmSourceMetaData) {
                this.getAlarmExt().setMetaData(updatedMetaData);
            }
        }
    }

    protected static BFacets mergeCameraPreset(BFacets alarmSourceMetaData, boolean startRecording, BValue cameraPreset, boolean gotoPreset, BOrd videoCameraOrd) {
        BObject alarmSourceCameraPreset = alarmSourceMetaData.get("cameraPreset");
        if (!videoCameraOrd.equals((Object)BOrd.NULL) && gotoPreset && startRecording) {
            if (alarmSourceCameraPreset == null && cameraPreset != null || alarmSourceCameraPreset != null && !alarmSourceCameraPreset.equals((Object)cameraPreset.toDataValue())) {
                alarmSourceMetaData = BFacets.make((BFacets)alarmSourceMetaData, (BFacets)BFacets.make((String)"cameraPreset", (BIDataValue)cameraPreset.toDataValue()));
            }
        } else if (alarmSourceMetaData.get("cameraPreset") != null) {
            alarmSourceMetaData = BFacets.makeRemove((BFacets)alarmSourceMetaData, (String)"cameraPreset");
        }
        return alarmSourceMetaData;
    }

    protected static BFacets mergeStartRecording(BFacets alarmSourceMetaData, boolean startRecording) {
        BObject startRecordingFV = alarmSourceMetaData.get("startRecording");
        if (startRecordingFV == null) {
            alarmSourceMetaData = BFacets.make((BFacets)alarmSourceMetaData, (String)"startRecording", (BIDataValue)BBoolean.make((boolean)startRecording));
        } else if (startRecordingFV instanceof BBoolean) {
            if (((BBoolean)startRecordingFV).getBoolean() != startRecording) {
                alarmSourceMetaData = BFacets.make((BFacets)alarmSourceMetaData, (String)"startRecording", (BIDataValue)BBoolean.make((boolean)startRecording));
            }
        } else {
            alarmSourceMetaData = BFacets.make((BFacets)alarmSourceMetaData, (String)"startRecording", (BIDataValue)BBoolean.make((boolean)startRecording));
        }
        return alarmSourceMetaData;
    }

    protected static BFacets mergeSendAlarmToDisplay(BFacets alarmSourceMetaData, boolean sendAlarmToDisplay) {
        BObject sendAlarmToDisplayFV = alarmSourceMetaData.get("sendAlarmToDisplay");
        if (sendAlarmToDisplayFV == null) {
            alarmSourceMetaData = BFacets.make((BFacets)alarmSourceMetaData, (String)"sendAlarmToDisplay", (BIDataValue)BBoolean.make((boolean)sendAlarmToDisplay));
        } else if (sendAlarmToDisplayFV instanceof BBoolean) {
            if (((BBoolean)sendAlarmToDisplayFV).getBoolean() != sendAlarmToDisplay) {
                alarmSourceMetaData = BFacets.make((BFacets)alarmSourceMetaData, (String)"sendAlarmToDisplay", (BIDataValue)BBoolean.make((boolean)sendAlarmToDisplay));
            }
        } else {
            alarmSourceMetaData = BFacets.make((BFacets)alarmSourceMetaData, (String)"sendAlarmToDisplay", (BIDataValue)BBoolean.make((boolean)sendAlarmToDisplay));
        }
        return alarmSourceMetaData;
    }

    protected static BFacets mergeCameraHandleOrd(BFacets alarmSourceMetaData, BOrd cameraHandleOrd) {
        String alarmSourceExtCameraHandle = alarmSourceMetaData.gets("cameraHandleOrd", null);
        if (alarmSourceExtCameraHandle == null) {
            if (cameraHandleOrd.equals((Object)BOrd.NULL)) {
                return alarmSourceMetaData;
            }
            return BFacets.make((BFacets)alarmSourceMetaData, (BFacets)BFacets.make((String)"cameraHandleOrd", (String)cameraHandleOrd.toString()));
        }
        if (cameraHandleOrd.equals((Object)BOrd.NULL)) {
            return BFacets.makeRemove((BFacets)alarmSourceMetaData, (String)"cameraHandleOrd");
        }
        if (cameraHandleOrd.toString().equals(alarmSourceExtCameraHandle)) {
            return alarmSourceMetaData;
        }
        return BFacets.make((BFacets)alarmSourceMetaData, (BFacets)BFacets.make((String)"cameraHandleOrd", (String)cameraHandleOrd.toString()));
    }

    protected static BFacets mergeCameraOrd(BFacets alarmSourceMetaData, BOrd videoCameraOrd) {
        String alarmSourceExtCamera = alarmSourceMetaData.gets("cameraOrd", null);
        if (alarmSourceExtCamera == null) {
            if (videoCameraOrd.equals((Object)BOrd.NULL)) {
                return alarmSourceMetaData;
            }
            return BFacets.make((BFacets)alarmSourceMetaData, (BFacets)BFacets.make((String)"cameraOrd", (BIDataValue)videoCameraOrd.toDataValue()));
        }
        if (videoCameraOrd.equals((Object)BOrd.NULL)) {
            return BFacets.makeRemove((BFacets)alarmSourceMetaData, (String)"cameraOrd");
        }
        if (videoCameraOrd.toString().equals(alarmSourceExtCamera)) {
            return alarmSourceMetaData;
        }
        return BFacets.make((BFacets)alarmSourceMetaData, (BFacets)BFacets.make((String)"cameraOrd", (BIDataValue)videoCameraOrd.toDataValue()));
    }

    public BIcon getIcon() {
        return icon;
    }

    class AlarmExtSubscriber
    extends Subscriber {
        AlarmExtSubscriber() {
            this.subscribe((BComponent)BVideoAlarmExtParameters.this.getAlarmExt());
        }

        public void event(BComponentEvent event) {
            if (event.getId() == 0) {
                if (event.getSourceComponent() == BVideoAlarmExtParameters.this.getAlarmExt() && (event.getSlot().equals((Object)BAlarmSourceExt.metaData) || event.getSlot().equals((Object)BAlarmSourceExt.status))) {
                    BVideoAlarmExtParameters.this.mergeMetaData();
                }
            } else if (event.getId() == 2 && event.getValue() == BVideoAlarmExtParameters.this) {
                this.unsubscribeAll();
                BVideoAlarmExtParameters.this.cleanupMetaData();
            }
        }
    }
}

