/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.hierarchy.wb;

import com.tridium.workbench.fieldeditors.BDialogFE;
import java.util.ArrayList;
import javax.baja.hierarchy.BHierarchy;
import javax.baja.hierarchy.BHierarchyService;
import javax.baja.hierarchy.BRoleHierarchies;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.role.BAdminRole;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.list.BCheckList;
import javax.baja.ui.list.ListRenderer;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;

@NiagaraType(agent={@AgentOn(types={"hierarchy:RoleHierarchies"})})
public class BRoleHierarchiesFE
extends BDialogFE {
    public static final Type TYPE = Sys.loadType(BRoleHierarchiesFE.class);
    static final Lexicon lex = Lexicon.make(BRoleHierarchiesFE.class);
    private BRoleHierarchies roleHierarchies;
    private BCheckList hierarchySelection;
    private BLabel propSheetDisplay;
    private Context cx;
    private BRoleHierarchies workingSet;

    public Type getType() {
        return TYPE;
    }

    public BRoleHierarchiesFE() {
        BFlowPane pane = new BFlowPane();
        this.propSheetDisplay = new BLabel("");
        pane.add("lbl", (BValue)this.propSheetDisplay);
        pane.add("btn", (BValue)this.getEditButton());
        this.setContent((BWidget)pane);
    }

    protected void doLoadValue(BObject v, Context cx) {
        this.cx = cx;
        if (!(v instanceof BRoleHierarchies)) {
            return;
        }
        this.roleHierarchies = (BRoleHierarchies)v;
        if (this.roleHierarchies.getRole() != null && this.roleHierarchies.getRole() instanceof BAdminRole) {
            this.propSheetDisplay.setText(lex.getText("roleHierarchiesFE.allHierarchies"));
            this.getEditButton().setEnabled(false);
        } else {
            this.propSheetDisplay.setText(this.roleHierarchies.toString(cx));
        }
    }

    protected BObject doSaveValue(BObject v, Context cx) {
        this.roleHierarchies = (BRoleHierarchies)v;
        if (this.workingSet != null) {
            this.roleHierarchies.setHierarchyNames(this.workingSet.getHierarchyNames());
        }
        return this.roleHierarchies;
    }

    public void doEditPressed() {
        BEdgePane pane = new BEdgePane();
        this.hierarchySelection = new BCheckList();
        this.hierarchySelection.setRenderer((ListRenderer)new roleHierarchiesRenderer());
        pane.setCenter((BWidget)this.hierarchySelection);
        BObject base = null;
        BWbShell shell = this.getWbShell();
        if (shell != null) {
            base = shell.getActiveOrdTarget().get();
        }
        BHierarchyService svc = (BHierarchyService)BOrd.make((String)"service:hierarchy:HierarchyService").get(base);
        svc.lease();
        BHierarchy[] hierarchyDefs = (BHierarchy[])svc.getChildren(BHierarchy.class);
        ArrayList<Integer> selectedIdx = new ArrayList<Integer>();
        for (int i = 0; i < hierarchyDefs.length; ++i) {
            this.hierarchySelection.addItem((Object)hierarchyDefs[i]);
            if (!this.roleHierarchies.hasHierarchy(hierarchyDefs[i].getName())) continue;
            selectedIdx.add(new Integer(i));
        }
        int[] selection = new int[selectedIdx.size()];
        for (int i = 0; i < selectedIdx.size(); ++i) {
            selection[i] = (Integer)selectedIdx.get(i);
        }
        this.hierarchySelection.getSelection().select(selection);
        int retVal = BDialog.open((BWidget)this, (String)lex.get("roleHierarchiesFE.editHierarchies", "Edit Hierarchies"), (Object)pane, (int)3);
        if (retVal == 1) {
            Object[] selected = this.hierarchySelection.getSelectedItems();
            BHierarchy[] selectedHierarchies = new BHierarchy[selected.length];
            for (int i = 0; i < selectedHierarchies.length; ++i) {
                selectedHierarchies[i] = (BHierarchy)selected[i];
            }
            this.workingSet = new BRoleHierarchies(selectedHierarchies);
            if (!this.workingSet.equivalent((Object)this.roleHierarchies)) {
                this.propSheetDisplay.setText(this.workingSet.toString(this.cx));
                this.setModified();
            }
        }
    }

    class roleHierarchiesRenderer
    extends BCheckList.CheckListRenderer {
        roleHierarchiesRenderer() {
        }

        public String getItemText(ListRenderer.Item item) {
            if (item.value instanceof BHierarchy) {
                return ((BHierarchy)item.value).getDisplayName(null);
            }
            return String.valueOf(item.value);
        }
    }
}

