/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.entityIo.rpc;

import java.io.IOException;
import java.util.Map;
import javax.baja.entityIo.json.JsonEntityEncoder;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;

@NiagaraType
public class BEntityRpc
extends BComponent {
    public static final Type TYPE = Sys.loadType(BEntityRpc.class);

    public Type getType() {
        return TYPE;
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box), @Transport(type=TransportType.fox)})
    public static String getEntityInfo(String encodedEntityOrd, Map<String, Boolean> options, Context cx) throws UnresolvedException, IOException, SyntaxException {
        BOrd entityOrd = (BOrd)BOrd.DEFAULT.decodeFromString(encodedEntityOrd);
        BComponent entity = entityOrd.get((BObject)BLocalHost.INSTANCE, cx).asComponent();
        if (!entity.getPermissions(cx).hasOperatorRead()) {
            throw new UnresolvedException(encodedEntityOrd);
        }
        JsonEntityEncoder.Options encoderOptions = new JsonEntityEncoder.Options(options.getOrDefault("jsonEntityEncoderShouldEncodeTags", true), options.getOrDefault("jsonEntityEncoderShouldEncodeRelations", true));
        return JsonEntityEncoder.encodeToString((Entity)entity, encoderOptions);
    }
}

