/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.driver.ui.point;

import java.util.ArrayList;
import java.util.List;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BEnumWritable;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BNumericWritable;
import javax.baja.control.BStringPoint;
import javax.baja.control.BStringWritable;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.driver.point.BIPointFolder;
import javax.baja.driver.point.BPointFolder;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.ui.point.BPointManager;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrTypeInfo;
import javax.baja.workbench.mgr.folder.BFolderManager;
import javax.baja.workbench.mgr.folder.FolderModel;

public class PointModel
extends FolderModel {
    public static final MgrTypeInfo BOOLEAN_POINT = MgrTypeInfo.make((BComponent)new BBooleanPoint());
    public static final MgrTypeInfo BOOLEAN_WRITABLE = MgrTypeInfo.make((BComponent)new BBooleanWritable());
    public static final MgrTypeInfo NUMERIC_POINT = MgrTypeInfo.make((BComponent)new BNumericPoint());
    public static final MgrTypeInfo NUMERIC_WRITABLE = MgrTypeInfo.make((BComponent)new BNumericWritable());
    public static final MgrTypeInfo ENUM_POINT = MgrTypeInfo.make((BComponent)new BEnumPoint());
    public static final MgrTypeInfo ENUM_WRITABLE = MgrTypeInfo.make((BComponent)new BEnumWritable());
    public static final MgrTypeInfo STRING_POINT = MgrTypeInfo.make((BComponent)new BStringPoint());
    public static final MgrTypeInfo STRING_WRITABLE = MgrTypeInfo.make((BComponent)new BStringWritable());
    Lexicon lex = Lexicon.make(BPointManager.class);
    String lexOut = this.lex.getText("out");
    BIPointFolder folder;
    Type proxyExtType = BProxyExt.TYPE;
    Type pointFolderType = BPointFolder.TYPE;

    public PointModel(BPointManager manager) {
        super((BFolderManager)manager);
    }

    public Type getFolderType() {
        return this.pointFolderType;
    }

    public Type getBaseNewType() {
        return BControlPoint.TYPE;
    }

    public int getSubscribeDepth() {
        return 2;
    }

    protected MgrColumn[] makeColumns() {
        return new MgrColumn[]{new MgrColumn.Path(2), new MgrColumn.Name(), new MgrColumn.Type(), new MgrColumn.ToString(this.lexOut, 0), new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.enabled}, 3), new MgrColumn.PropPath(new Property[]{BControlPoint.facets}, 3), new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.tuningPolicyName}, 1), new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.deviceFacets}, 3), new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.conversion}, 3), new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.faultCause}, 2), new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.readValue}, 2), new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.writeValue}, 2)};
    }

    public Type[] getIncludeTypes() {
        return new Type[]{BControlPoint.TYPE, this.pointFolderType};
    }

    public boolean accept(BComponent c) {
        if (c instanceof BControlPoint) {
            return ((BControlPoint)c).getProxyExt().getType().is(this.proxyExtType);
        }
        return true;
    }

    public void load(BComponent target) {
        this.folder = (BIPointFolder)target;
        try {
            this.proxyExtType = this.folder.getProxyExtType();
            this.pointFolderType = this.folder.getPointFolderType();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.load(target);
    }

    public BComponent newInstance(MgrTypeInfo type) throws Exception {
        BControlPoint pt = (BControlPoint)type.newInstance();
        BAbstractProxyExt ext = (BAbstractProxyExt)this.proxyExtType.getInstance();
        pt.setProxyExt(ext);
        return pt;
    }

    public MgrTypeInfo[] getNewTypes() {
        ArrayList<MgrTypeInfo> list = new ArrayList<MgrTypeInfo>();
        PointModel.addBooleanPointTypes(list, true);
        PointModel.addNumericPointTypes(list, true);
        PointModel.addEnumPointTypes(list, true);
        PointModel.addStringPointTypes(list, true);
        return list.toArray(new MgrTypeInfo[list.size()]);
    }

    public static void addPointTypes(TypeInfo type, List<MgrTypeInfo> list, boolean writable) {
        if (type.is(BIBoolean.TYPE)) {
            PointModel.addBooleanPointTypes(list, writable);
        }
        if (type.is(BINumeric.TYPE)) {
            PointModel.addNumericPointTypes(list, writable);
        }
        if (type.is(BIEnum.TYPE)) {
            PointModel.addEnumPointTypes(list, writable);
        }
        PointModel.addStringPointTypes(list, writable);
    }

    public static void addBooleanPointTypes(List<MgrTypeInfo> list, boolean writable) {
        if (writable) {
            list.add(BOOLEAN_WRITABLE);
        }
        list.add(BOOLEAN_POINT);
    }

    public static void addNumericPointTypes(List<MgrTypeInfo> list, boolean writable) {
        if (writable) {
            list.add(NUMERIC_WRITABLE);
        }
        list.add(NUMERIC_POINT);
    }

    public static void addEnumPointTypes(List<MgrTypeInfo> list, boolean writable) {
        if (writable) {
            list.add(ENUM_WRITABLE);
        }
        list.add(ENUM_POINT);
    }

    public static void addStringPointTypes(List<MgrTypeInfo> list, boolean writable) {
        if (writable) {
            list.add(STRING_WRITABLE);
        }
        list.add(STRING_POINT);
    }

    public static void mapPointFacets(MgrEditRow row, MgrColumn col, Object source) {
        BFacets orig = (BFacets)row.getCell(col);
        BFacets facets = PointModel.mapPointFacets(orig, source);
        row.setCell(col, (BValue)facets);
    }

    public static BFacets mapPointFacets(BFacets orig, Object source) {
        BFacets f = orig;
        if (source instanceof BIBoolean) {
            return ((BIBoolean)source).getBooleanFacets();
        }
        if (source instanceof BINumeric) {
            return ((BINumeric)source).getNumericFacets();
        }
        if (source instanceof BIEnum) {
            return ((BIEnum)source).getEnumFacets();
        }
        return BFacets.make((BFacets)f);
    }
}

