/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.driver.ui.device;

import com.tridium.ui.theme.Theme;
import java.util.HashMap;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceExt;
import javax.baja.driver.BDeviceFolder;
import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.Slot;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.component.table.BComponentTable;
import javax.baja.workbench.component.table.ComponentTableCellRenderer;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrColumn;

public class DeviceExtsColumn
extends MgrColumn {
    static final BImage defaultIcon = BImage.make((String)"module://icons/x16/object.png");
    TableCellRenderer renderer = new CellRenderer();
    BImage[] icons;
    String[] names;
    double prefWidth;
    boolean dynamicExts = false;

    public DeviceExtsColumn(BDevice protoType) {
        this(protoType, 0, false);
    }

    public DeviceExtsColumn(BDevice protoType, int flags) {
        this(protoType, flags, false);
    }

    public DeviceExtsColumn(BDevice protoType, boolean dynamicExts) {
        this(protoType, 0, dynamicExts);
    }

    public DeviceExtsColumn(BDevice protoType, int flags, boolean dynamicExts) {
        super(Lexicon.make(DeviceExtsColumn.class).getText("deviceExtsColumn"), flags);
        this.dynamicExts = dynamicExts;
        this.icons = DeviceExtsColumn.initIcons(protoType);
        this.names = DeviceExtsColumn.initNames(protoType);
        this.prefWidth = 4 + this.icons.length * 20 + 4;
    }

    public void setDynamicExts(boolean dynamicExts) {
        this.dynamicExts = dynamicExts;
    }

    public Object get(Object row) {
        return row;
    }

    public TableCellRenderer getCellRenderer() {
        return this.renderer;
    }

    void cellDoubleClicked(BMgrTable table, BMouseEvent event, int row, int col) {
        BWbShell shell;
        RectGeom rect = table.getCellBounds(row, col);
        BComponent component = table.getComponentAt(row);
        if (component instanceof BDeviceFolder) {
            return;
        }
        String[] n = null;
        n = this.dynamicExts && component instanceof BDevice ? DeviceExtsColumn.initNames((BDevice)component) : this.names;
        int x = (int)(event.getX() - rect.x);
        int index = (x - 4) / 20;
        if (0 <= index && index < n.length && (shell = table.getManager().getWbShell()) != null) {
            BOrd ord = BOrd.make((String)(component.getNavOrd().toString() + "/" + n[index]));
            shell.hyperlink(new HyperlinkInfo(ord, (BInputEvent)event));
        }
    }

    static BImage[] initIcons(BDevice protoType) {
        BDeviceExt[] exts = protoType.getDeviceExts();
        Array result = new Array(BImage.class);
        for (int i = 0; i < exts.length; ++i) {
            if ((protoType.getFlags((Slot)exts[i].getPropertyInParent()) & 4) != 0) continue;
            BImage icon = BImage.make((BIcon)exts[i].getIcon());
            if (icon == null || icon.isNull()) {
                icon = defaultIcon;
            }
            result.add((Object)icon);
        }
        return (BImage[])result.trim();
    }

    static String[] initNames(BDevice protoType) {
        BDeviceExt[] exts = protoType.getDeviceExts();
        Array result = new Array(String.class);
        for (int i = 0; i < exts.length; ++i) {
            if ((protoType.getFlags((Slot)exts[i].getPropertyInParent()) & 4) != 0) continue;
            result.add((Object)exts[i].getName());
        }
        return (String[])result.trim();
    }

    class CellRenderer
    extends ComponentTableCellRenderer {
        HashMap<Object, BImage[]> cache = new HashMap();

        CellRenderer() {
        }

        public BBrush getBackground(TableCellRenderer.Cell cell) {
            if (cell.value instanceof BDeviceFolder) {
                return Theme.table().getGridBrush();
            }
            return super.getBackground(cell);
        }

        public double getPreferredCellWidth(TableCellRenderer.Cell cell) {
            if (DeviceExtsColumn.this.dynamicExts && cell.value instanceof BDevice) {
                BImage[] images = this.cache.get(cell.value);
                if (images == null) {
                    images = DeviceExtsColumn.initIcons((BDevice)cell.value);
                    this.cache.put(cell.value, images);
                }
                return 4 + images.length * 20 + 4;
            }
            return DeviceExtsColumn.this.prefWidth;
        }

        public void paintCell(Graphics g, TableCellRenderer.Cell cell) {
            this.paintCellBackground(g, cell);
            if (cell.value instanceof BDeviceFolder) {
                return;
            }
            BImage[] images = null;
            if (DeviceExtsColumn.this.dynamicExts && cell.value instanceof BDevice) {
                images = this.cache.get(cell.value);
                if (images == null) {
                    images = DeviceExtsColumn.initIcons((BDevice)cell.value);
                    this.cache.put(cell.value, images);
                }
            } else {
                images = DeviceExtsColumn.this.icons;
            }
            for (int i = 0; i < images.length; ++i) {
                g.drawImage(images[i], (double)(4 + i * 20), (cell.height - 16.0) / 2.0);
            }
        }

        protected BComponentTable getComponentTable() {
            return DeviceExtsColumn.this.getManager().getModel().getTable();
        }
    }
}

