/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.driver.ui.point;

import javax.baja.driver.point.conv.BLinearWithUnitConversion;
import javax.baja.gx.BBrush;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.list.ListRenderer;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.LexiconModule;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BLinearWithUnitConversionFE
extends BWbFieldEditor {
    public static final Type TYPE = Sys.loadType(BLinearWithUnitConversionFE.class);
    private static final LexiconModule LEXICON = LexiconModule.make((String)"driver");
    BTextField scale;
    BTextField offset;
    BListDropDown combo;
    BBrush fg = BBrush.NULL;
    BBrush bg = BBrush.NULL;

    public Type getType() {
        return TYPE;
    }

    public BLinearWithUnitConversionFE() {
        this.scale = new BTextField("1", 10);
        this.linkTo((BComponent)this.scale, (Slot)BTextField.textModified, (Slot)setModified);
        this.linkTo((BComponent)this.scale, (Slot)BTextField.actionPerformed, (Slot)actionPerformed);
        this.offset = new BTextField("0", 10);
        this.linkTo((BComponent)this.offset, (Slot)BTextField.textModified, (Slot)setModified);
        this.linkTo((BComponent)this.offset, (Slot)BTextField.actionPerformed, (Slot)actionPerformed);
        this.combo = new BListDropDown();
        this.combo.getList().setRenderer((ListRenderer)new Renderer());
        this.linkTo((BComponent)this.combo, (Slot)BListDropDown.valueModified, (Slot)setModified);
        this.linkTo((BComponent)this.combo, (Slot)BListDropDown.actionPerformed, (Slot)actionPerformed);
        String scaleLabel = LEXICON.get("LinearConversion.scale", null);
        String offsetLabel = LEXICON.get("LinearConversion.offset", null);
        String conversionLabel = LEXICON.get("LinearWithUnitConversion.unit.conversion", null);
        BGridPane grid = new BGridPane(6);
        grid.add("a", (BValue)new BLabel(scaleLabel));
        grid.add("b", (BValue)this.scale);
        grid.add("c", (BValue)new BLabel(offsetLabel));
        grid.add("d", (BValue)this.offset);
        grid.add("e", (BValue)new BLabel(conversionLabel));
        grid.add("f", (BValue)this.combo);
        this.setContent((BWidget)grid);
    }

    protected void doSetReadonly(boolean readonly) {
        this.scale.setEditable(!readonly);
        this.offset.setEditable(!readonly);
        this.combo.setDropDownEnabled(!readonly);
    }

    protected void doLoadValue(BObject value, Context cx) {
        BLinearWithUnitConversion conversion = (BLinearWithUnitConversion)value;
        this.scale.setText(BDouble.encode((double)conversion.getScale()));
        this.offset.setText(BDouble.encode((double)conversion.getOffset()));
        String deviceText = LEXICON.get("LinearWithUnitConversion.unit.conversion.device", cx);
        String proxyText = LEXICON.get("LinearWithUnitConversion.unit.conversion.proxy", cx);
        this.combo.getList().removeAllItems();
        this.combo.getList().addItem((Object)deviceText);
        this.combo.getList().addItem((Object)proxyText);
        this.combo.setSelectedItem((Object)(conversion.getApplyUnitsToDevice() ? deviceText : proxyText));
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        String selectedItem = (String)this.combo.getSelectedItem();
        String deviceText = LEXICON.get("LinearWithUnitConversion.unit.conversion.device", cx);
        return BLinearWithUnitConversion.make((double)BDouble.decode((String)this.scale.getText()), (double)BDouble.decode((String)this.offset.getText()), (boolean)selectedItem.equals(deviceText));
    }

    class Renderer
    extends ListRenderer {
        Renderer() {
        }

        public BBrush getBackground(ListRenderer.Item item) {
            if (BLinearWithUnitConversionFE.this.bg.isNull()) {
                return super.getBackground(item);
            }
            return BLinearWithUnitConversionFE.this.bg;
        }

        public BBrush getForeground(ListRenderer.Item item) {
            if (BLinearWithUnitConversionFE.this.fg.isNull()) {
                return super.getForeground(item);
            }
            return BLinearWithUnitConversionFE.this.fg;
        }
    }
}

