/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.driver.file.ui;

import com.tridium.driver.file.BFileDevice;
import com.tridium.driver.file.history.BCsvFileImport;
import com.tridium.driver.file.history.BDelimitedFileImport;
import com.tridium.driver.file.history.BExcelCsvFileImport;
import com.tridium.driver.file.history.BFileHistoryDeviceExt;
import javax.baja.data.BIDataValue;
import javax.baja.driver.history.BIArchiveFolder;
import javax.baja.driver.ui.history.ArchiveManagerController;
import javax.baja.driver.ui.history.BHistoryImportManager;
import javax.baja.driver.ui.history.ImportModel;
import javax.baja.history.BCollectionInterval;
import javax.baja.history.BHistoryId;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class BDelimitedFileImportManager
extends BHistoryImportManager {
    public static final Type TYPE = Sys.loadType(BDelimitedFileImportManager.class);
    static final Lexicon lex = Lexicon.make((String)"driver");
    private BFileHistoryDeviceExt deviceExt;
    MgrColumn fileCol = new MgrColumn.Prop(BDelimitedFileImport.file, 1);
    MgrColumn delimiterCol = new DelimiterImportProp(BDelimitedFileImport.delimiter, 1);
    MgrColumn tstampFormatCol = new MgrColumn.Prop(BDelimitedFileImport.timestampFormat, 3);
    MgrColumn valueFormatCol = new MgrColumn.Prop(BDelimitedFileImport.valueFormat, 1);
    MgrColumn tstampIndexCol = new MgrColumn.Prop(BDelimitedFileImport.timestampColumnIndex, 3);
    MgrColumn valueIndexCol = new MgrColumn.Prop(BDelimitedFileImport.valueColumnIndex, 3);
    MgrColumn statusIndexCol = new MgrColumn.Prop(BDelimitedFileImport.statusColumnIndex, 3);
    MgrColumn rowStartCol = new MgrColumn.Prop(BDelimitedFileImport.rowStart, 3);
    MgrColumn rowEndCol = new MgrColumn.Prop(BDelimitedFileImport.rowEnd, 3);
    MgrColumn rowIdCol = new MgrColumn.Prop(BDelimitedFileImport.identifierPattern, 3);
    MgrColumn rowIdIndexCol = new MgrColumn.Prop(BDelimitedFileImport.identifierColumnIndex, 3);
    MgrColumn fullImportCol = new MgrColumn.Prop(BDelimitedFileImport.fullImportOnExecute, 3);
    MgrColumn[] mcols = new MgrColumn[]{this.fileCol, this.fullImportCol, this.rowStartCol, this.rowEndCol, this.delimiterCol, this.tstampIndexCol, this.tstampFormatCol, this.valueIndexCol, this.valueFormatCol, this.statusIndexCol, this.rowIdIndexCol, this.rowIdCol};

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    protected ImportModel makeImportModel() {
        return new DelimitedFileImportModel(this);
    }

    public MgrController makeController() {
        return new ArchiveManagerController(this);
    }

    private BFileHistoryDeviceExt getDeviceExt() {
        if (this.deviceExt != null) {
            return this.deviceExt;
        }
        this.deviceExt = (BFileHistoryDeviceExt)((BIArchiveFolder)this.getCurrentValue()).getDeviceExt();
        return this.deviceExt;
    }

    private BFileDevice getDevice() {
        BFileHistoryDeviceExt devExt = this.getDeviceExt();
        if (devExt == null) {
            return null;
        }
        return (BFileDevice)devExt.getDevice();
    }

    private static class TimeZoneConfigColumn
    extends ImportModel.ConfigColumn {
        public TimeZoneConfigColumn(String propName, String displayName, int flags, BValue defaultValue) {
            super(propName, displayName, flags, defaultValue);
        }

        @Override
        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) throws Exception {
            BValue val = rows[0].getCell(colIndex);
            BFacets facets = BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"driver:TimeZoneSelectionFE"));
            BWbFieldEditor editor = BWbFieldEditor.makeFor((BObject)val, (Context)facets);
            if (currentEditor != null && currentEditor.getClass() == editor.getClass()) {
                editor = (BWbFieldEditor)currentEditor;
            }
            editor.loadValue((BObject)val, (Context)facets);
            return editor;
        }
    }

    private static class DelimiterImportProp
    extends MgrColumn.Prop {
        public DelimiterImportProp(String name, Property prop, int flags) {
            super(name, prop, flags);
        }

        public DelimiterImportProp(Property prop, int flags) {
            super(prop, flags);
        }

        public DelimiterImportProp(Property prop) {
            super(prop);
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            if (rows != null) {
                for (int i = 0; i < rows.length; ++i) {
                    if (!rows[i].getTarget().getType().is(BCsvFileImport.TYPE)) continue;
                    return null;
                }
            }
            return super.toEditor(rows, colIndex, currentEditor);
        }
    }

    private class DelimitedFileImportModel
    extends ImportModel {
        public DelimitedFileImportModel(BHistoryImportManager manager) {
            super(manager);
        }

        @Override
        public Type[] getIncludeTypes() {
            BObject val = this.getManager().getCurrentValue();
            if (val instanceof BIArchiveFolder) {
                BIArchiveFolder folder = (BIArchiveFolder)val;
                Type folderType = folder.getArchiveFolderType();
                return new Type[]{BDelimitedFileImport.TYPE, folderType};
            }
            return new Type[]{BDelimitedFileImport.TYPE};
        }

        @Override
        public MgrTypeInfo[] getNewTypes() {
            MgrTypeInfo[] types = MgrTypeInfo.makeArray((Type)BDelimitedFileImport.TYPE);
            MgrTypeInfo excelImportType = MgrTypeInfo.make((Type)BExcelCsvFileImport.TYPE);
            int size = types.length;
            for (int i = 0; i < size; ++i) {
                if (!types[i].equals((Object)excelImportType)) continue;
                MgrTypeInfo[] sorted = new MgrTypeInfo[size];
                sorted[0] = types[i];
                int count = 1;
                for (int j = 0; j < size; ++j) {
                    if (j == i) continue;
                    sorted[count] = types[j];
                    ++count;
                }
                types = sorted;
                break;
            }
            return types;
        }

        @Override
        protected MgrColumn[] makeColumns() {
            int i;
            MgrColumn[] superCols = super.makeColumns();
            int resultSize = superCols.length + BDelimitedFileImportManager.this.mcols.length + 3;
            MgrColumn[] result = new MgrColumn[resultSize];
            int index = 0;
            for (i = 0; i < superCols.length; ++i) {
                result[index] = superCols[i];
                ++index;
            }
            result[index] = new ImportModel.ConfigColumn("interval", lex.getText("HistoryConfig.interval"), 3, (BValue)BCollectionInterval.IRREGULAR);
            result[++index] = new ImportModel.ConfigColumn("valueFacets", lex.getText("HistoryConfig.valueFacets"), 3, (BValue)BFacets.DEFAULT);
            result[++index] = new TimeZoneConfigColumn("timeZone", lex.getText("HistoryConfig.timeZone"), 3, (BValue)BTimeZone.DEFAULT);
            ++index;
            for (i = 0; i < BDelimitedFileImportManager.this.mcols.length; ++i) {
                result[index] = BDelimitedFileImportManager.this.mcols[i];
                ++index;
            }
            return result;
        }

        @Override
        public BComponent newInstance(MgrTypeInfo type) throws Exception {
            BDelimitedFileImport descriptor = (BDelimitedFileImport)super.newInstance(type);
            BComponent overrides = descriptor.getConfigOverrides();
            overrides.add("interval", (BValue)BCollectionInterval.IRREGULAR, 0);
            overrides.add("valueFacets", (BValue)BFacets.make((String)"units", (BIDataValue)BUnit.NULL), 0);
            BTimeZone tz = BTimeZone.getLocal();
            overrides.add("timeZone", (BValue)tz, 0, BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"driver:TimeZoneSelectionFE")), null);
            try {
                String escDevice = SlotPath.escape((String)BDelimitedFileImportManager.this.getDevice().getName());
                descriptor.setHistoryId(BHistoryId.make((String)escDevice, (String)""));
            }
            catch (Exception e) {
                System.out.println("Cannot set default History Id for new Delimited File Import Descriptor.");
                e.printStackTrace();
            }
            return descriptor;
        }
    }
}

