/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.event;

import com.tridium.event.BEventChannel;
import com.tridium.event.BEventSourceFolder;
import com.tridium.event.BNiagaraEventDeviceExt;
import com.tridium.fox.sys.BFoxChannelRegistry;
import com.tridium.fox.sys.BFoxServerConnection;
import com.tridium.fox.sys.BFoxService;
import com.tridium.fox.sys.BServerConnections;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.baja.agent.AgentList;
import javax.baja.event.BEvent;
import javax.baja.event.BEventSource;
import javax.baja.event.BIEventRoutable;
import javax.baja.license.Feature;
import javax.baja.sys.Action;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.IllegalNameException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.Queue;
import javax.baja.util.ThreadPoolWorker;
import javax.baja.util.Worker;

public class BEventService
extends BAbstractService
implements BIEventRoutable,
BIRestrictedComponent {
    public static final Property defaultSource = BEventService.newProperty((int)0, (BValue)new BEventSource(), null);
    public static final Action process = BEventService.newAction((int)8, (BValue)new BEvent(), null);
    public static final Type TYPE = Sys.loadType(BEventService.class);
    private static final BIcon icon = BIcon.make((String)"module://event/icons/eventService.png");
    public static final Logger log;
    Queue queue = new Queue();
    private Worker worker = new ThreadPoolWorker((Worker.ITodo)this.queue);

    public BEventSource getDefaultSource() {
        return (BEventSource)this.get(defaultSource);
    }

    public void setDefaultSource(BEventSource v) {
        this.set(defaultSource, (BValue)v, null);
    }

    @Override
    public void process(BEvent event) {
        this.invoke(process, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public void serviceStarted() {
        this.worker.start(Thread.currentThread().getThreadGroup(), "EventService");
        BFoxService foxService = (BFoxService)Sys.getService((Type)BFoxService.TYPE);
        BServerConnections connectionsContainer = foxService.getServerConnections();
        BFoxServerConnection[] serverConnections = (BFoxServerConnection[])connectionsContainer.getChildren(BFoxServerConnection.class);
        for (int i = 0; i < serverConnections.length; ++i) {
            serverConnections[i].getChannels().get("Event", BEventChannel.TYPE);
        }
        this.getComponentSpace().enableMixIn(BNiagaraEventDeviceExt.TYPE);
    }

    public void serviceStopped() {
        this.worker.stop();
        this.getComponentSpace().disableMixIn(BNiagaraEventDeviceExt.TYPE);
    }

    public boolean isChildLegal(BComponent child) {
        if (child.getType().is(BFolder.TYPE) && !child.getType().is(BEventSourceFolder.TYPE)) {
            return false;
        }
        return super.isChildLegal(child);
    }

    public void checkAdd(String newName, BValue value, int flags, BFacets facets, Context context) {
        if (this.isRunning() && value.getType().is(BEventSource.TYPE)) {
            BEventSource existingSource = this.getEventSource(newName);
            if (newName.equals("defaultSource") || !existingSource.getName().equals("defaultSource")) {
                throw new LocalizableRuntimeException("event", "DuplicateEventSource", (Object[])new String[]{newName});
            }
        }
        super.checkAdd(newName, value, flags, facets, context);
    }

    public void checkRename(Property property, String newName, Context context) {
        if (this.isRunning() && property.getType().is(BEventSource.TYPE)) {
            BEventSource existingClass = this.getEventSource(newName);
            if (newName.equals("defaultSource") || !existingClass.getName().equals("defaultSource")) {
                throw new IllegalNameException("event", "DuplicateEventSource", (Object[])new String[]{newName});
            }
        }
        super.checkRename(property, newName, context);
    }

    public final void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        BIRestrictedComponent.checkContextForSuperUser((BIRestrictedComponent)this, (Context)cx);
        BIRestrictedComponent.checkParentForRestrictedComponent((BComponent)parent, (BIRestrictedComponent)this);
    }

    public static BEventService get() {
        return (BEventService)Sys.getService((Type)TYPE);
    }

    public void doProcess(BEvent event) {
        if (!this.isOperational()) {
            return;
        }
        log.fine("Processing message.");
        this.getDefaultSource().process(event);
    }

    public final BEventSource[] getEventSources() {
        ArrayList eventSources = new ArrayList();
        return this.getEventSources(eventSources, (BComponent)this);
    }

    private final <T extends BEventSource> BEventSource[] getEventSources(List<T> eventSources, BComponent folder) {
        folder.lease();
        BEventSource[] direct = (BEventSource[])folder.getChildren(BEventSource.class);
        for (int i = 0; i < direct.length; ++i) {
            eventSources.add(direct[i]);
        }
        BEventSourceFolder[] folders = (BEventSourceFolder[])folder.getChildren(BEventSourceFolder.class);
        for (int j = 0; j < folders.length; ++j) {
            this.getEventSources(eventSources, (BComponent)folders[j]);
        }
        return eventSources.toArray(new BEventSource[eventSources.size()]);
    }

    public final BEventSource getEventSource(String eventSourceName) {
        BEventSource source = this.getEventSource((BComponent)this, eventSourceName);
        if (source == null) {
            source = this.getDefaultSource();
        }
        return source;
    }

    private final BEventSource getEventSource(BComponent folder, String eventSourceName) {
        folder.lease();
        Property acp = folder.getProperty(eventSourceName);
        if (acp == null) {
            BEventSourceFolder[] folders = (BEventSourceFolder[])folder.getChildren(BEventSourceFolder.class);
            for (int i = 0; i < folders.length; ++i) {
                BEventSource temp = this.getEventSource((BComponent)folders[i], eventSourceName);
                if (temp == null) continue;
                return temp;
            }
        } else {
            return (BEventSource)folder.get(acp);
        }
        return null;
    }

    @Override
    public final BIEventRoutable routeTo(BIEventRoutable routable) {
        return this.getDefaultSource().routeTo(null, routable);
    }

    @Override
    public final BIEventRoutable routeTo(String name, BIEventRoutable routable) {
        return this.getDefaultSource().routeTo(name, routable);
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "eventService");
    }

    public AgentList getAgents(Context cx) {
        AgentList list = super.getAgents(cx);
        list.toTop("wiresheet:WireSheet");
        return list;
    }

    public BIcon getIcon() {
        return icon;
    }

    static {
        BFoxChannelRegistry.getPrototype().add("Event", (BValue)new BEventChannel());
        log = Logger.getLogger("event");
    }
}

