/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.event.recipients;

import java.util.logging.Level;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.data.BIDataValue;
import javax.baja.event.BEvent;
import javax.baja.event.BEventRecipient;
import javax.baja.event.BEventService;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BAlarmRecipient
extends BEventRecipient
implements BIAlarmSource {
    public static final Property alarmClass = BAlarmRecipient.newProperty((int)0, (String)"defaultAlarmClass", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"alarm:AlarmClassFE"), (String)"uxFieldEditor", (BIDataValue)BString.make((String)"alarm:AlarmClassEditor")));
    public static final Type TYPE = Sys.loadType(BAlarmRecipient.class);
    private static final BIcon icon = BIcon.make((BIcon)BIcon.std((String)"alarm.png"), (BIcon)BIcon.make((String)"module://event/icons/eventBadge.png"));
    public static final String EVENT_ID = "eventId";
    public static final String EVENT_VALUE = "eventValue";
    public static final String EVENT_SOURCE = "eventSource";
    protected AlarmSupport support;

    public String getAlarmClass() {
        return this.getString(alarmClass);
    }

    public void setAlarmClass(String v) {
        this.setString(alarmClass, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void eventReceived(BEvent event) {
        try {
            BFacets alarmFacets = BFacets.make((String)EVENT_ID, (BIDataValue)event.getUuid().toDataValue(), (String)EVENT_SOURCE, (BIDataValue)event.getSource().toDataValue(), (String)EVENT_VALUE, (BIDataValue)event.getValue().toDataValue());
            this.support.newAlert(alarmFacets);
        }
        catch (Exception e) {
            BEventService.log.log(Level.SEVERE, "Unable to generate alarm.", e);
        }
    }

    public BBoolean ackAlarm(BAlarmRecord ackRequest) {
        return BBoolean.TRUE;
    }

    public void started() {
        this.support = new AlarmSupport((BIAlarmSource)this, this.getAlarmClass());
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(alarmClass) && this.support != null) {
            this.support.setAlarmClass(this.getAlarmClass());
        }
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }
}

