/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.event.filters;

import com.tridium.bql.compiler.BqlTokenizer;
import com.tridium.bql.compiler.ExprParser;
import com.tridium.bql.expression.ExprEngine;
import java.util.logging.Level;
import javax.baja.event.BEvent;
import javax.baja.event.BEventFilter;
import javax.baja.event.BEventService;
import javax.baja.query.BExpression;
import javax.baja.status.BStatus;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BBqlEventFilter
extends BEventFilter {
    public static final Property status = BBqlEventFilter.newProperty((int)9, (BValue)BStatus.ok, null);
    public static final Property queryText = BBqlEventFilter.newProperty((int)8, (String)"", null);
    public static final Type TYPE = Sys.loadType(BBqlEventFilter.class);
    private BExpression expr = null;
    private final ExprEngine exprEngine = new ExprEngine(null);
    private static final ExprParser parser = new ExprParser();

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getQueryText() {
        return this.getString(queryText);
    }

    public void setQueryText(String v) {
        this.setString(queryText, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public static BBqlEventFilter make(String query) {
        BBqlEventFilter filter = new BBqlEventFilter();
        filter.setQueryText(query);
        return filter;
    }

    public void started() {
        try {
            this.expr = parser.parse(new BqlTokenizer(this.getQueryText()));
            this.setStatus(BStatus.ok);
        }
        catch (Exception e) {
            if (this.getQueryText().length() > 0) {
                BEventService.log.log(Level.WARNING, "Invalid BQL expression.", e);
            }
            this.setStatus(BStatus.fault);
            this.expr = null;
        }
    }

    public void changed(Property property, Context context) {
        if (this.isRunning() && property.equals(queryText)) {
            try {
                this.expr = parser.parse(new BqlTokenizer(this.getQueryText()));
                this.setStatus(BStatus.ok);
            }
            catch (Exception e) {
                if (this.getQueryText().length() > 0) {
                    BEventService.log.log(Level.WARNING, "Invalid BQL expression.", e);
                }
                this.setStatus(BStatus.fault);
                this.expr = null;
            }
        }
        super.changed(property, context);
    }

    @Override
    public void doProcess(BEvent event) {
        if (this.expr != null && ((BBoolean)this.exprEngine.evaluate(this.expr, (BObject)event, null)).getBoolean()) {
            this.fireEvent(event);
        }
    }
}

