/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aaphp.util;

import com.tridium.aaphp.BAaPhpDevice;
import com.tridium.aaphp.BAaPhpNetwork;
import com.tridium.aaphp.messages.AaPhpAckTransactionAlarmReq;
import com.tridium.aaphp.messages.AaPhpAckTransactionAlarmResponse;
import com.tridium.aaphp.messages.AaPhpReadMessageTextRequest;
import com.tridium.aaphp.messages.AaPhpReadMessageTextResponse;
import java.util.logging.Level;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.data.BIDataValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BAaPhpNativeEventsProcessor
extends BAlarmSourceInfo
implements BIAlarmSource {
    public static final Action ackAlarm = BAaPhpNativeEventsProcessor.newAction((int)5, (BValue)new BAlarmRecord(), null);
    public static final Type TYPE = Sys.loadType(BAaPhpNativeEventsProcessor.class);
    AlarmSupport alarmSupport;
    String nextAlarmText = "";
    BFacets aaphpEventFacets = null;
    BAbsTime aaphpEventTime = null;

    public BBoolean ackAlarm(BAlarmRecord ackRequest) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)ackRequest, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.alarmSupport = new AlarmSupport((BIAlarmSource)this, (BAlarmSourceInfo)this);
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BAaPhpDevice;
    }

    public BAaPhpDevice getAaPhpDevice() {
        return (BAaPhpDevice)this.getParent();
    }

    public BAaPhpNetwork getAaPhpNetwork() {
        return (BAaPhpNetwork)this.getAaPhpDevice().getNetwork();
    }

    public synchronized boolean readAaPhpAlarms() {
        BAaPhpDevice d = this.getAaPhpDevice();
        AaPhpReadMessageTextResponse[] replies = AaPhpReadMessageTextRequest.readAllMessages(this.getAaPhpNetwork(), this.getAaPhpNetwork().translateAddress(d.getAddress()));
        if (replies != null) {
            this.processReplies(replies);
        }
        return replies != null;
    }

    private void generateAlarm() {
        try {
            BFacets niagaraAlarmFacets = BFacets.make((String)"msgText", (String)this.nextAlarmText);
            if (this.aaphpEventFacets != null) {
                niagaraAlarmFacets = BFacets.make((BFacets)niagaraAlarmFacets, (BFacets)this.aaphpEventFacets);
            }
            this.alarmSupport.newOffnormalAlarm(niagaraAlarmFacets);
        }
        catch (Exception e) {
            this.getAaPhpDevice().getNetwork().getLogger().log(Level.SEVERE, "Error forwarding AaPhp alarm to Niagara AX", e);
        }
        finally {
            this.aaphpEventFacets = null;
            this.nextAlarmText = "";
            this.aaphpEventTime = null;
        }
    }

    private void processAaPhpTransactionAlarm(AaPhpReadMessageTextResponse aaphpAlarmRsp) {
        this.aaphpEventTime = aaphpAlarmRsp.isStructuredTransaction() ? aaphpAlarmRsp.getAbsTime() : null;
        this.aaphpEventFacets = BFacets.make((String)"transaction", (BIDataValue)BInteger.make((int)aaphpAlarmRsp.getTransactionId()), (String)"aaphpTime", (BIDataValue)this.aaphpEventTime);
        this.nextAlarmText = aaphpAlarmRsp.getMessageText();
    }

    private void processAaPhpContinuationMsg(AaPhpReadMessageTextResponse aaphpContinuationRsp) {
        this.nextAlarmText = this.nextAlarmText + "\r\n" + aaphpContinuationRsp.getText();
    }

    private void processAaPhpUnrestrictedEvent(AaPhpReadMessageTextResponse aaphpUnrestrictedMsgRsp) {
        this.aaphpEventTime = null;
        this.aaphpEventFacets = null;
        this.nextAlarmText = aaphpUnrestrictedMsgRsp.getMessageText();
    }

    private static boolean isAaPhpEvent(AaPhpReadMessageTextResponse eventRsp) {
        return eventRsp.getResponseType() == '=';
    }

    private void processAaPhpEvent(AaPhpReadMessageTextResponse aaphpEvtRsp) {
        if (aaphpEvtRsp.isTransaction()) {
            this.processAaPhpTransactionAlarm(aaphpEvtRsp);
        } else if (aaphpEvtRsp.isContinuation()) {
            this.processAaPhpContinuationMsg(aaphpEvtRsp);
        } else if (aaphpEvtRsp.isUnrestricted()) {
            this.processAaPhpUnrestrictedEvent(aaphpEvtRsp);
        }
        this.generateAlarm();
    }

    private void processReply(AaPhpReadMessageTextResponse thisRsp) {
        if (BAaPhpNativeEventsProcessor.isAaPhpEvent(thisRsp)) {
            this.processAaPhpEvent(thisRsp);
        }
    }

    private void processReplies(AaPhpReadMessageTextResponse[] aaphpReplies) {
        for (int i = 0; i < aaphpReplies.length; ++i) {
            this.processReply(aaphpReplies[i]);
        }
    }

    public BBoolean doAckAlarm(final BAlarmRecord alarmRecord) {
        BInteger alarmTransaction = (BInteger)alarmRecord.getAlarmData().get("transaction");
        if (alarmTransaction == null) {
            return BBoolean.TRUE;
        }
        final int transaction = alarmTransaction.getInt();
        final BAaPhpNetwork aaphpNet = (BAaPhpNetwork)this.getAaPhpDevice().getNetwork();
        final int unitNumber = aaphpNet.translateAddress(this.getAaPhpDevice().getAddress());
        aaphpNet.post(new Runnable(){

            @Override
            public void run() {
                AaPhpAckTransactionAlarmReq req = new AaPhpAckTransactionAlarmReq(unitNumber, transaction);
                AaPhpAckTransactionAlarmResponse rsp = (AaPhpAckTransactionAlarmResponse)aaphpNet.sendSync(req);
                if (rsp == null) {
                    aaphpNet.getLog().error("AaPhp Timeout. Unable to acknowledge alarm transaction from device " + unitNumber + ". AaPhp transaction id=" + transaction);
                } else if (rsp.isError()) {
                    aaphpNet.getLog().error("AaPhp Error. Unable to acknowledge alarm transaction from device " + unitNumber + ". AaPhp transaction id=" + transaction + ". AaPhp error =" + rsp.getErrorMsg());
                } else {
                    try {
                        BAaPhpNativeEventsProcessor.this.alarmSupport.ackAlarm(alarmRecord);
                    }
                    catch (Exception e) {
                        aaphpNet.getLog().error("Niagara AX alarming error. Unable to acknowlege alarm transaction from device " + unitNumber + " ,aaphp tranaction=" + transaction, (Throwable)e);
                    }
                }
            }
        });
        return BBoolean.FALSE;
    }
}

