/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aaphp.job;

import com.tridium.aaphp.BAaPhpNetwork;
import com.tridium.aaphp.datatypes.BAaPhpAttribute;
import com.tridium.aaphp.messages.AaPhpReadNextAttributeRequest;
import com.tridium.aaphp.messages.AaPhpReadNextAttributeResponse;
import javax.baja.job.BSimpleJob;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BAaPhpLearnAttributesJob
extends BSimpleJob {
    public static final Type TYPE = Sys.loadType(BAaPhpLearnAttributesJob.class);
    final BAaPhpNetwork aaphpNet;
    final int unitNumberAddress;
    final String[] aaphpOrds;
    static final String QUOTE_STR = "'";
    static final String DEFAULT_ATTRIBUTE_NAME = "Attribute$20?";

    public Type getType() {
        return TYPE;
    }

    public BAaPhpLearnAttributesJob(BAaPhpNetwork aaphpNet, int unitNumberAddress, String[] aaphpOrds) {
        this.aaphpNet = aaphpNet;
        this.unitNumberAddress = unitNumberAddress;
        this.aaphpOrds = aaphpOrds;
    }

    public void run(Context cx) throws Exception {
        for (int i = 0; i < this.aaphpOrds.length; ++i) {
            new LearnAttributes(this.aaphpOrds[i]).learnAttibutes();
            this.progress(i / this.aaphpOrds.length);
        }
    }

    public BAaPhpAttribute[] getLearnedAttributes() {
        return (BAaPhpAttribute[])this.getChildren(BAaPhpAttribute.class);
    }

    class LearnAttributes {
        String previousAaPhpOrd;

        LearnAttributes(String aaphpOrd) {
            this.previousAaPhpOrd = aaphpOrd;
        }

        BAaPhpAttribute learnNextAttribute() {
            AaPhpReadNextAttributeRequest req = new AaPhpReadNextAttributeRequest(BAaPhpLearnAttributesJob.this.unitNumberAddress, this.previousAaPhpOrd);
            AaPhpReadNextAttributeResponse rsp = (AaPhpReadNextAttributeResponse)BAaPhpLearnAttributesJob.this.aaphpNet.sendSync(req);
            if (rsp != null && !rsp.isError()) {
                String nextAaPhpOrd = rsp.getNextAaPhpOrd();
                BAaPhpAttribute a = new BAaPhpAttribute();
                a.setAaPhpOrd(nextAaPhpOrd);
                a.setRawDataHex(rsp.getRawDataHex());
                a.setNumericEncodingType(rsp.getEncodingValue());
                this.previousAaPhpOrd = nextAaPhpOrd;
                return a;
            }
            return null;
        }

        void learnAttibutes() {
            BAaPhpAttribute nextAttribute = this.learnNextAttribute();
            while (nextAttribute != null) {
                BAaPhpLearnAttributesJob.this.add(BAaPhpLearnAttributesJob.DEFAULT_ATTRIBUTE_NAME, (BValue)nextAttribute);
                nextAttribute = this.learnNextAttribute();
            }
        }
    }
}

