/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aaphp;

import com.tridium.aaphp.BAaPhpNetwork;
import com.tridium.aaphp.datatypes.BAaPhpGatherSetupInfoJobParam;
import com.tridium.aaphp.datatypes.BAaPhpRecvFileJobParam;
import com.tridium.aaphp.datatypes.BAaPhpSendFileJobParam;
import com.tridium.aaphp.job.BAaPhpGatherSetupInfoJob;
import com.tridium.aaphp.job.BAaPhpReadFileJob;
import com.tridium.aaphp.job.BAaPhpVirtualTerminalJob;
import com.tridium.aaphp.job.BAaPhpWriteFileJob;
import com.tridium.aaphp.messages.AaPhpSayHelloRequest;
import com.tridium.aaphp.messages.AaPhpSayHelloResponse;
import com.tridium.aaphp.messages.AaPhpTimeSyncRequest;
import com.tridium.aaphp.point.BAaPhpPointDeviceExt;
import com.tridium.aaphp.util.AaPhpFileSupport;
import com.tridium.aaphp.util.BAaPhpNativeEventsProcessor;
import com.tridium.basicdriver.BBasicDevice;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBlob;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public abstract class BAaPhpDevice
extends BBasicDevice {
    public static final Property address = BAaPhpDevice.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt(null, (int)0, (int)255, (int)16));
    public static final Property points = BAaPhpDevice.newProperty((int)0, (BValue)new BAaPhpPointDeviceExt(), null);
    public static final Property aaPhpAlarmInfo = BAaPhpDevice.newProperty((int)0, (BValue)new BAaPhpNativeEventsProcessor(), null);
    public static final Property terminalModeInterMessageDelay = BAaPhpDevice.newProperty((int)0, (BValue)BRelTime.make((long)200L), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE));
    public static final Property allowTimeSync = BAaPhpDevice.newProperty((int)0, (boolean)true, null);
    public static final Property recentSetupInfoFileOrd = BAaPhpDevice.newProperty((int)2117, (BValue)BOrd.NULL, null);
    public static final Property earlierSetupInfoFileOrd = BAaPhpDevice.newProperty((int)2117, (BValue)BOrd.NULL, null);
    public static final Action submitSendFileJob = BAaPhpDevice.newAction((int)4, (BValue)new BAaPhpSendFileJobParam(), null);
    public static final Action submitRecvFileJob = BAaPhpDevice.newAction((int)4, (BValue)new BAaPhpRecvFileJobParam(), null);
    public static final Action submitVirtualTerminalJob = BAaPhpDevice.newAction((int)4, null);
    public static final Action syncTime = BAaPhpDevice.newAction((int)0, null);
    public static final Action submitGatherSetupInfoJob = BAaPhpDevice.newAction((int)4, (BValue)new BAaPhpGatherSetupInfoJobParam(), null);
    public static final Type TYPE = Sys.loadType(BAaPhpDevice.class);
    public static Lexicon LEXICON = Lexicon.make((String)"aaphp");
    public static final BasicContext CONTEXT_DEVICE_GATHER_CHANGES_ACTION = new BasicContext(){

        public String toString() {
            return "DeviceGatherChangesAction";
        }
    };

    public int getAddress() {
        return this.getInt(address);
    }

    public void setAddress(int v) {
        this.setInt(address, v, null);
    }

    public BAaPhpPointDeviceExt getPoints() {
        return (BAaPhpPointDeviceExt)this.get(points);
    }

    public void setPoints(BAaPhpPointDeviceExt v) {
        this.set(points, (BValue)v, null);
    }

    public BAaPhpNativeEventsProcessor getAaPhpAlarmInfo() {
        return (BAaPhpNativeEventsProcessor)this.get(aaPhpAlarmInfo);
    }

    public void setAaPhpAlarmInfo(BAaPhpNativeEventsProcessor v) {
        this.set(aaPhpAlarmInfo, (BValue)v, null);
    }

    public BRelTime getTerminalModeInterMessageDelay() {
        return (BRelTime)this.get(terminalModeInterMessageDelay);
    }

    public void setTerminalModeInterMessageDelay(BRelTime v) {
        this.set(terminalModeInterMessageDelay, (BValue)v, null);
    }

    public boolean getAllowTimeSync() {
        return this.getBoolean(allowTimeSync);
    }

    public void setAllowTimeSync(boolean v) {
        this.setBoolean(allowTimeSync, v, null);
    }

    public BOrd getRecentSetupInfoFileOrd() {
        return (BOrd)this.get(recentSetupInfoFileOrd);
    }

    public void setRecentSetupInfoFileOrd(BOrd v) {
        this.set(recentSetupInfoFileOrd, (BValue)v, null);
    }

    public BOrd getEarlierSetupInfoFileOrd() {
        return (BOrd)this.get(earlierSetupInfoFileOrd);
    }

    public void setEarlierSetupInfoFileOrd(BOrd v) {
        this.set(earlierSetupInfoFileOrd, (BValue)v, null);
    }

    public BOrd submitSendFileJob(BAaPhpSendFileJobParam params) {
        return (BOrd)this.invoke(submitSendFileJob, (BValue)params, null);
    }

    public BOrd submitRecvFileJob(BAaPhpRecvFileJobParam params) {
        return (BOrd)this.invoke(submitRecvFileJob, (BValue)params, null);
    }

    public BOrd submitVirtualTerminalJob() {
        return (BOrd)this.invoke(submitVirtualTerminalJob, null, null);
    }

    public void syncTime() {
        this.invoke(syncTime, null, null);
    }

    public BOrd submitGatherSetupInfoJob(BAaPhpGatherSetupInfoJobParam gatherSetupInfoParam) {
        return (BOrd)this.invoke(submitGatherSetupInfoJob, (BValue)gatherSetupInfoParam, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BAaPhpDevice() {
        this.setFlags((Slot)upload, 4);
        this.setFlags((Slot)download, 4);
    }

    public final BAaPhpNetwork getAaPhpNetwork() {
        return (BAaPhpNetwork)this.getNetwork();
    }

    public Type getNetworkType() {
        return BAaPhpNetwork.TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.syncTime();
    }

    public void doPing() {
        if (this.getAaPhpAlarmInfo().readAaPhpAlarms()) {
            this.pingOk();
        } else {
            this.simplePing();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simplePing() {
        BAaPhpNetwork network = (BAaPhpNetwork)this.getNetwork();
        AaPhpSayHelloRequest req = null;
        AaPhpSayHelloResponse rsp = null;
        try {
            req = new AaPhpSayHelloRequest(network.translateAddress(this.getAddress()));
            rsp = (AaPhpSayHelloResponse)network.sendSync(req);
            if (rsp != null) {
                this.pingOk();
            } else {
                this.pingFail("AaPhp timeout");
            }
        }
        catch (Exception e) {
            this.pingFail("Caught exception: " + e);
            e.printStackTrace();
        }
        finally {
            network = null;
        }
    }

    public void pingOk() {
        if (this.isDown()) {
            this.doSyncTime();
        }
        super.pingOk();
    }

    public BOrd doSubmitSendFileJob(BAaPhpSendFileJobParam param) {
        BBlob aaphpBytes = param.getFileBytes();
        if (aaphpBytes.equals((Object)BBlob.DEFAULT)) {
            aaphpBytes = AaPhpFileSupport.getFirmwareBlob(param.getSendFileParam().getSource());
        }
        return new BAaPhpWriteFileJob((BAaPhpNetwork)this.getNetwork(), ((BAaPhpNetwork)this.getNetwork()).translateAddress(this.getAddress()), aaphpBytes, param.getSendFileParam().getDestination()).submit(null);
    }

    public BOrd doSubmitRecvFileJob(BAaPhpRecvFileJobParam params) throws Exception {
        return new BAaPhpReadFileJob((BAaPhpNetwork)this.getNetwork(), ((BAaPhpNetwork)this.getNetwork()).translateAddress(this.getAddress()), params.getRecvFileParam().getSource(), params.getRecvFileParam().getDestination(), params.getOutputStreamForServer()).submit(null);
    }

    public BOrd doSubmitVirtualTerminalJob(Context cx) {
        return new BAaPhpVirtualTerminalJob(this).submit(cx);
    }

    public void doSyncTime() {
        if (this.getAllowTimeSync()) {
            AaPhpTimeSyncRequest req = new AaPhpTimeSyncRequest(((BAaPhpNetwork)this.getNetwork()).translateAddress(this.getAddress()), BAbsTime.now());
            this.getAaPhpNetwork().sendSync(req);
        }
    }

    public BOrd doSubmitGatherSetupInfoJob(BAaPhpGatherSetupInfoJobParam gatherSetupInfoJobParam) throws Exception {
        BBlob terminalCommandsBytes = gatherSetupInfoJobParam.getTerminalCommandsfileBlob();
        if (terminalCommandsBytes.equals((Object)BBlob.DEFAULT)) {
            terminalCommandsBytes = AaPhpFileSupport.getFirmwareBlob(gatherSetupInfoJobParam.getTerminalCommandsFileOrd());
        }
        return new BAaPhpGatherSetupInfoJob(this, terminalCommandsBytes, gatherSetupInfoJobParam.getOutputStreamForServer(), gatherSetupInfoJobParam.getResultsFileOrd(), this.getRecentSetupInfoFileOrd()).submit((Context)CONTEXT_DEVICE_GATHER_CHANGES_ACTION);
    }
}

