/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.mysql;

import com.tridium.rdb.BAbstractConnectionPool;
import com.tridium.rdb.mysql.BMySQLDatabase;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import org.apache.commons.dbcp2.BasicDataSource;

@NiagaraType
public class BMySQLConnectionPool
extends BAbstractConnectionPool {
    public static final Type TYPE = Sys.loadType(BMySQLConnectionPool.class);
    private BasicDataSource ds;

    public Type getType() {
        return TYPE;
    }

    public void doUpdateConnectionStats() {
        if (this.ds != null) {
            this.setNumActive(this.ds.getNumActive());
            if (this.getNumActive() > this.getPeakNumActive()) {
                this.setPeakNumActive(this.getNumActive());
            }
            this.setNumIdle(this.ds.getNumIdle());
        }
    }

    protected Connection obtainConnection(String userName, String password) throws SQLException {
        BMySQLDatabase db = (BMySQLDatabase)this.getParent();
        if (!db.isRunning()) {
            throw new BajaRuntimeException("Database not running");
        }
        String url = BMySQLConnectionPool.makeUrl(db);
        if (this.ds == null) {
            Logger.getLogger("rdb").fine("initializing connection pool for " + url);
            this.ds = this.makeDataSource(url, userName, password);
        } else if (!(this.ds.getUrl().equals(url) && this.ds.getUsername().equals(userName) && this.ds.getPassword().equals(password))) {
            Logger.getLogger("rdb").fine("re-initializing connection pool for " + url);
            this.ds.close();
            this.ds = this.makeDataSource(url, userName, password);
        }
        try {
            return AccessController.doPrivileged(() -> this.ds.getConnection());
        }
        catch (NoClassDefFoundError | PrivilegedActionException connectionIssue) {
            String faultCause = "";
            if (connectionIssue.getCause() instanceof SQLException) {
                Throwable e = connectionIssue.getCause().getCause();
                if (e instanceof ClassNotFoundException) {
                    faultCause = this.getLexicon().getText("rdbMySql.throwable.mySqlConnectorJarIssue");
                }
            } else {
                faultCause = connectionIssue instanceof NoClassDefFoundError ? this.getLexicon().getText("rdbMySql.throwable.mySqlConnectorJarIssue") : connectionIssue.getLocalizedMessage();
            }
            db.pingFail(faultCause);
            db.getLogger().log(Level.SEVERE, faultCause, connectionIssue);
            throw new BajaRuntimeException(faultCause);
        }
    }

    private BasicDataSource makeDataSource(String url, String userName, String password) {
        BasicDataSource ds = new BasicDataSource();
        ds.setDriverClassName("com.mysql.cj.jdbc.Driver");
        ds.setUrl(url);
        ds.setUsername(userName);
        ds.setPassword(password);
        ds.setMaxTotal(this.getMaxActive());
        ds.setMaxIdle(this.getMaxIdle());
        ds.setMaxWaitMillis((long)this.getMaxWait());
        return ds;
    }

    private static String makeUrl(BMySQLDatabase db) throws SQLException {
        String extra;
        String separator;
        StringBuffer url = new StringBuffer("jdbc:mysql:");
        url.append("//").append(db.getHostname());
        url.append(':').append(db.getPort());
        String dbName = db.getDatabaseName();
        if (!dbName.isEmpty()) {
            url.append('/').append(dbName);
        }
        String string = separator = !(extra = db.getExtraConnectionProperties()).isEmpty() ? "&" : "?";
        if (!extra.isEmpty()) {
            url.append('?').append(extra);
        }
        if (url.indexOf("serverTimezone=") == -1) {
            url.append(separator).append("serverTimezone=UTC");
            separator = "&";
        }
        if (db.getUseUnicodeEncodingScheme()) {
            url.append(separator).append("useUnicode=true&characterEncoding=UTF-8");
            separator = "&";
        }
        String ssl = db.getUseEncryptedConnection() ? "true" : "false";
        String sslProperties = "useSSL=" + ssl + "&requireSSL=" + ssl;
        url.append(separator).append(sslProperties);
        if (db.getUseEncryptedConnection()) {
            String trustCertificateKeyStoreURI = db.getMySqlServerCert().trim();
            boolean verifyCA = trustCertificateKeyStoreURI != null && !trustCertificateKeyStoreURI.isEmpty();
            url.append('&').append("verifyServerCertificate=" + verifyCA);
            if (verifyCA) {
                url.append('&').append("trustCertificateKeyStoreUrl=" + db.getTrustCertificateKeyStoreURI());
                try {
                    url.append('&').append("trustCertificateKeyStorePassword=" + new String(db.getTrustCertificateKeyStorePassword().get()));
                    url.append('&').append("trustCertificateKeyStoreType=" + db.getTrustCertificateKeyStoreType());
                }
                catch (Exception e) {
                    throw new SQLException("Failed to configure trust store connection parameters");
                }
            }
        }
        return url.toString();
    }
}

