/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.flexSerial.comm;

import com.tridium.basicdriver.UnsolicitedMessageListener;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.flexSerial.BFlexSerialNetwork;
import com.tridium.flexSerial.comm.MessageElement;
import com.tridium.flexSerial.comm.TLinkedListManager;
import com.tridium.flexSerial.messages.SerialMessageConst;
import com.tridium.flexSerial.messages.SerialReceivedMessage;
import javax.baja.sys.BBlob;

public class FlexSerialUnsolicitedReceive
implements Runnable,
UnsolicitedMessageListener,
SerialMessageConst {
    private static Integer DEFAULT_TAG = new Integer(-1);
    private TLinkedListManager unsolicitedMessageManager = null;
    private BFlexSerialNetwork host;
    private boolean timeToDie = true;
    private Thread myThread;

    public FlexSerialUnsolicitedReceive(BFlexSerialNetwork host) {
        this.host = host;
    }

    public final void init() {
    }

    public final void cleanup() {
    }

    public final void start() {
        this.timeToDie = false;
        this.myThread = new Thread((Runnable)this, "FlexSerialUnsolicitedReceive");
        this.myThread.start();
    }

    public final void stop() {
        this.timeToDie = true;
        this.myThread.interrupt();
    }

    public boolean isDying() {
        return this.timeToDie;
    }

    @Override
    public void run() {
        this.unsolicitedMessageManager = new TLinkedListManager("FlexSerialUnsolicitedReceive Manager");
        while (!this.timeToDie) {
            MessageElement unsolicitedMsg;
            try {
                unsolicitedMsg = (MessageElement)this.unsolicitedMessageManager.removeFromHead(-1L);
            }
            catch (InterruptedException e) {
                System.out.println("\n processing message");
                unsolicitedMsg = null;
            }
            try {
                if (unsolicitedMsg == null) continue;
                SerialReceivedMessage newMessage = unsolicitedMsg.getMessage();
                this.processUnsolicitedMessage(newMessage);
            }
            catch (Exception e) {
                System.out.println(" FlexSerialUnsolicitedReceive thread caught Exception: " + e);
            }
        }
    }

    protected synchronized void processUnsolicitedMessage(SerialReceivedMessage message) {
        String rcvMessage = message.getStringMessage();
        this.host.getUnsolicitedMessage().setValue(rcvMessage);
        this.host.setUnsolicitedByteArray(BBlob.make((byte[])message.getBytes(), (int)0, (int)message.getLength()));
        this.host.fireUnsolicitedMessageReceived(null);
    }

    public void receiveMessage(ReceivedMessage message) {
        MessageElement msgElement = new MessageElement((SerialReceivedMessage)message);
        if (this.unsolicitedMessageManager != null) {
            this.unsolicitedMessageManager.addToTail(msgElement);
        }
    }

    public Object getUnsolicitedListenerCode() {
        return DEFAULT_TAG;
    }
}

