/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.flexSerial;

import com.tridium.flexSerial.BFlexSerialNetwork;
import com.tridium.flexSerial.messages.SerialMessage;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusString;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

public class BSerialSend
extends BComponent
implements BIStatus {
    public static final Property in = BSerialSend.newProperty((int)264, (BValue)new BStatusString(""), null);
    public static final Property addFrameStart = BSerialSend.newProperty((int)0, (boolean)true, null);
    public static final Property addFrameEnd = BSerialSend.newProperty((int)0, (boolean)true, null);
    public static final Property status = BSerialSend.newProperty((int)11, (BValue)BStatus.ok, null);
    public static final Action send = BSerialSend.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BSerialSend.class);
    BFlexSerialNetwork network;

    public BStatusString getIn() {
        return (BStatusString)this.get(in);
    }

    public void setIn(BStatusString v) {
        this.set(in, (BValue)v, null);
    }

    public boolean getAddFrameStart() {
        return this.getBoolean(addFrameStart);
    }

    public void setAddFrameStart(boolean v) {
        this.setBoolean(addFrameStart, v, null);
    }

    public boolean getAddFrameEnd() {
        return this.getBoolean(addFrameEnd);
    }

    public void setAddFrameEnd(boolean v) {
        this.setBoolean(addFrameEnd, v, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public void send() {
        this.invoke(send, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.network = this.getNetwork();
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (this.network == null ? 1 : 0) != 0));
    }

    public void changed(Property property, Context context) {
        if (this.isRunning() && property == in) {
            this.postSend();
        }
    }

    public IFuture post(Action action, BValue arg, Context cx) {
        if (action.equals(send)) {
            return this.postSend();
        }
        return super.post(action, arg, cx);
    }

    protected IFuture postSend() {
        if (this.isRunning()) {
            return this.getNetwork().postAsync((Runnable)new Invocation((BComponent)this, send, null, null));
        }
        return null;
    }

    public void doSend() {
        if (this.getNetwork() == null) {
            return;
        }
        String frameStart = new String(this.network.getMessageBlocks().getFrameStart().getByteArray());
        String frameEnd = new String(this.network.getMessageBlocks().getFrameEnd().getByteArray());
        String reqData = this.getIn().getValue();
        if (this.getAddFrameStart()) {
            reqData = frameStart + reqData;
        }
        if (this.getAddFrameEnd()) {
            reqData = reqData + frameEnd;
        }
        SerialMessage req = new SerialMessage(reqData);
        req.setResponseExpected(false);
        this.network.sendSync(req);
    }

    BFlexSerialNetwork getNetwork() {
        if (this.network != null) {
            return this.network;
        }
        for (BComplex parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof BFlexSerialNetwork)) continue;
            this.network = (BFlexSerialNetwork)parent;
            return this.network;
        }
        return null;
    }
}

