/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.flexSerial;

import com.tridium.flexSerial.BFlexSerialNetwork;
import com.tridium.flexSerial.messages.SerialMessage;
import com.tridium.flexSerial.messages.SerialResponse;
import javax.baja.status.BStatusString;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BSerialRequest
extends BComponent {
    public static final Property request = BSerialRequest.newProperty((int)264, (BValue)new BStatusString(""), null);
    public static final Property addFrameStart = BSerialRequest.newProperty((int)0, (boolean)true, null);
    public static final Property addFrameEnd = BSerialRequest.newProperty((int)0, (boolean)true, null);
    public static final Property response = BSerialRequest.newProperty((int)264, (BValue)new BStatusString(""), null);
    public static final Property responseExpected = BSerialRequest.newProperty((int)0, (boolean)true, null);
    public static final Property stripFrameStart = BSerialRequest.newProperty((int)0, (boolean)true, null);
    public static final Property stripFrameEnd = BSerialRequest.newProperty((int)0, (boolean)true, null);
    public static final Action sendRequest = BSerialRequest.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BSerialRequest.class);
    BFlexSerialNetwork network;
    static BStatusString nre = new BStatusString("Response Not Expected");

    public BStatusString getRequest() {
        return (BStatusString)this.get(request);
    }

    public void setRequest(BStatusString v) {
        this.set(request, (BValue)v, null);
    }

    public boolean getAddFrameStart() {
        return this.getBoolean(addFrameStart);
    }

    public void setAddFrameStart(boolean v) {
        this.setBoolean(addFrameStart, v, null);
    }

    public boolean getAddFrameEnd() {
        return this.getBoolean(addFrameEnd);
    }

    public void setAddFrameEnd(boolean v) {
        this.setBoolean(addFrameEnd, v, null);
    }

    public BStatusString getResponse() {
        return (BStatusString)this.get(response);
    }

    public void setResponse(BStatusString v) {
        this.set(response, (BValue)v, null);
    }

    public boolean getResponseExpected() {
        return this.getBoolean(responseExpected);
    }

    public void setResponseExpected(boolean v) {
        this.setBoolean(responseExpected, v, null);
    }

    public boolean getStripFrameStart() {
        return this.getBoolean(stripFrameStart);
    }

    public void setStripFrameStart(boolean v) {
        this.setBoolean(stripFrameStart, v, null);
    }

    public boolean getStripFrameEnd() {
        return this.getBoolean(stripFrameEnd);
    }

    public void setStripFrameEnd(boolean v) {
        this.setBoolean(stripFrameEnd, v, null);
    }

    public void sendRequest() {
        this.invoke(sendRequest, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.network = this.getNetwork();
    }

    public void changed(Property property, Context context) {
        if (this.isRunning() && property == request) {
            this.doSendRequest();
        }
    }

    public void doSendRequest() {
        if (this.getNetwork() == null) {
            return;
        }
        String frameStart = new String(this.network.getMessageBlocks().getFrameStart().getByteArray());
        String frameEnd = new String(this.network.getMessageBlocks().getFrameEnd().getByteArray());
        String reqData = this.getRequest().getValue();
        if (this.getAddFrameStart()) {
            reqData = frameStart + reqData;
        }
        if (this.getAddFrameEnd()) {
            reqData = reqData + frameEnd;
        }
        SerialMessage req = new SerialMessage(reqData);
        boolean isResponseExpected = this.getResponseExpected();
        req.setResponseExpected(isResponseExpected);
        if (isResponseExpected) {
            SerialResponse resp = (SerialResponse)this.network.sendSync(req);
            if (resp == null) {
                System.out.println(" null response received");
            }
            if (resp != null && resp.getBytes() != null) {
                String respString = new String(resp.getBytes());
                if (this.getStripFrameStart() && respString.startsWith(frameStart)) {
                    respString = respString.substring(frameStart.length());
                }
                if (this.getStripFrameEnd() && respString.endsWith(frameEnd)) {
                    respString = respString.substring(0, respString.length() - frameEnd.length());
                }
                this.getResponse().setValue(respString);
                this.getResponse().setStatusDown(false);
            } else {
                this.getResponse().setStatusDown(true);
            }
        } else {
            this.network.sendSync(req);
            this.setResponse(nre);
        }
    }

    BFlexSerialNetwork getNetwork() {
        if (this.network != null) {
            return this.network;
        }
        for (BComplex parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof BFlexSerialNetwork)) continue;
            this.network = (BFlexSerialNetwork)parent;
            return this.network;
        }
        return null;
    }
}

