/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.virtual;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.broker.BBrokerChannel;
import com.tridium.fox.sys.data.BDataChannel;
import com.tridium.fox.sys.spy.FoxLog;
import com.tridium.nd.point.BPointChannel;
import com.tridium.nd.virtual.BNiagaraVirtualChannel;
import com.tridium.nd.virtual.DefaultNiagaraVirtualStationAdapter;
import com.tridium.nv.BNiagaraVirtualGateway;
import com.tridium.nv.BSlotInfo;
import com.tridium.nv.INiagaraVirtualCommsAdapter;
import com.tridium.nv.point.BVirtualAction;
import com.tridium.nv.point.IProxyActionParent;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.baja.fox.BFoxProxySession;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.security.BIUserCredentials;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.util.Version;

public class FoxNiagaraVirtualCommsAdapter
implements INiagaraVirtualCommsAdapter {
    private BFoxClientConnection connection;
    private DefaultNiagaraVirtualStationAdapter stationAdapter;
    private static final BNiagaraVirtualGateway.PartialSlotInfo[] nullPartialSlotInfo = new BNiagaraVirtualGateway.PartialSlotInfo[0];
    private static final BVirtualAction[] nullProxyActions = new BVirtualAction[0];
    private static final Version VERSION_START = new Version("3.4");
    private static final Version VERSION_WRITABLE_START = new Version("3.5");
    private static final Version VERSION_PARTIAL_DISCOVERY_START = new Version("3.7");
    private static final FoxLog LOG = FoxLog.make((String)"fox.niagaraVirtual");
    private static final boolean FORCE_LEGACY_HANDLE_TO_PATH = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.virtual.forceLegacyHandleToPath"));

    public FoxNiagaraVirtualCommsAdapter(BFoxClientConnection connection, DefaultNiagaraVirtualStationAdapter stationAdapter) {
        this.connection = connection;
        this.stationAdapter = stationAdapter;
    }

    public BNiagaraVirtualGateway.FullSlotInfo[] loadSlots(BOrd ord, String connectionDescription) throws Exception {
        BNiagaraVirtualGateway.FullSlotInfo[] infos;
        BNiagaraVirtualChannel channel = this.getVirtualChannel();
        boolean supportsWritable = false;
        if (this.stationAdapter.getStationVersion(VERSION_START).compareTo(VERSION_START) < 0) {
            throw new Exception("Remote Station version incorrect (must be 3.4 or greater) (" + Sys.getStation().getStationName() + ") ->" + this.stationAdapter.getStationName());
        }
        FoxConnectInterest interest = new FoxConnectInterest(connectionDescription);
        try {
            this.connection.engageNoRetry((BFoxClientConnection.Interest)interest);
            if (this.connection.getRemoteVersion().compareTo(VERSION_WRITABLE_START) >= 0) {
                supportsWritable = true;
            }
            infos = channel.discover(ord);
        }
        catch (Exception e) {
            throw new Exception("Component removed (" + Sys.getStation().getStationName() + ")");
        }
        finally {
            this.connection.disengage((BFoxClientConnection.Interest)interest);
        }
        for (BNiagaraVirtualGateway.FullSlotInfo fullSlotInfo : infos) {
            FoxNiagaraVirtualCommsAdapter.configWritable(supportsWritable, fullSlotInfo.getSlotInfo());
            for (BSlotInfo childSlotInfo : fullSlotInfo.getChildren()) {
                FoxNiagaraVirtualCommsAdapter.configWritable(supportsWritable, childSlotInfo);
            }
        }
        return infos;
    }

    private static void configWritable(boolean supportsWritable, BSlotInfo slotInfo) {
        if (!supportsWritable && !slotInfo.getIsComponent()) {
            slotInfo.setIsWritable(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BNiagaraVirtualGateway.PartialSlotInfo[] loadPartial(BOrd rootOrd, BOrd[] vOrds, String connectionDescription) throws Exception {
        Version v = this.stationAdapter.getStationVersion(VERSION_PARTIAL_DISCOVERY_START);
        if (v.compareTo(VERSION_PARTIAL_DISCOVERY_START) >= 0) {
            BNiagaraVirtualChannel channel = this.getVirtualChannel();
            FoxConnectInterest interest = new FoxConnectInterest(connectionDescription + ": " + this.stationAdapter.getStationName());
            try {
                this.connection.engageNoRetry((BFoxClientConnection.Interest)interest);
                if (this.connection.getRemoteVersion().compareTo(VERSION_PARTIAL_DISCOVERY_START) >= 0) {
                    BNiagaraVirtualGateway.PartialSlotInfo[] partialSlotInfoArray = channel.discoverPartial(rootOrd, vOrds);
                    return partialSlotInfoArray;
                }
            }
            finally {
                this.connection.disengage((BFoxClientConnection.Interest)interest);
            }
        }
        return nullPartialSlotInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(BOrd ord, String name, BValue val, String connectionDescription) throws Exception {
        block7: {
            Version v = this.stationAdapter.getStationVersion(VERSION_WRITABLE_START);
            if (v.compareTo(VERSION_WRITABLE_START) < 0) {
                throw new Exception("Can only write Properties to Stations with version 3.5 and greater (" + this.stationAdapter.getStationName() + ") Version: " + v);
            }
            FoxConnectInterest interest = new FoxConnectInterest(connectionDescription);
            try {
                this.connection.engageNoRetry((BFoxClientConnection.Interest)interest);
                if (this.connection.getRemoteVersion().compareTo(VERSION_WRITABLE_START) >= 0) {
                    try {
                        this.getPointChannel().write(ord, name, val);
                        break block7;
                    }
                    catch (Exception e) {
                        throw new Exception("Cannot perform write (" + Sys.getStation().getStationName() + " -> " + this.stationAdapter.getStationName() + ")");
                    }
                }
                throw new Exception("Can only write Properties to Stations with version 3.5 and greater (" + this.stationAdapter.getStationName() + ") Version: " + this.connection.getRemoteVersion());
            }
            finally {
                this.connection.disengage((BFoxClientConnection.Interest)interest);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BValue getActionDefault(IProxyActionParent ext, BVirtualAction action, String connectionDescription) throws Exception {
        BValue val;
        BPointChannel pointChannel = this.getPointChannel();
        if (pointChannel == null) {
            return null;
        }
        FoxConnectInterest interest = new FoxConnectInterest(connectionDescription);
        try {
            this.connection.engageNoRetry((BFoxClientConnection.Interest)interest);
            val = pointChannel.getActionDefault(ext, action);
        }
        finally {
            this.connection.disengage((BFoxClientConnection.Interest)interest);
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BVirtualAction[] loadActions(IProxyActionParent ext, String connectionDescription) throws Exception {
        BPointChannel pointChannel = this.getPointChannel();
        if (pointChannel == null) {
            return nullProxyActions;
        }
        FoxConnectInterest interest = new FoxConnectInterest(connectionDescription);
        try {
            this.connection.engageNoRetry((BFoxClientConnection.Interest)interest);
            if (this.connection.getRemoteVersion().compareTo(VERSION_START) < 0) {
                BVirtualAction[] bVirtualActionArray = nullProxyActions;
                return bVirtualActionArray;
            }
            BVirtualAction[] bVirtualActionArray = pointChannel.getActions(ext);
            return bVirtualActionArray;
        }
        finally {
            this.connection.disengage((BFoxClientConnection.Interest)interest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BValue invokeAction(IProxyActionParent ext, BVirtualAction action, BValue arg, String connectionDescription) throws Exception {
        BPointChannel pointChannel = this.getPointChannel();
        if (pointChannel == null) {
            return null;
        }
        FoxConnectInterest interest = new FoxConnectInterest(connectionDescription);
        try {
            this.connection.engageNoRetry((BFoxClientConnection.Interest)interest);
            BValue bValue = pointChannel.invoke(ext, action, arg);
            return bValue;
        }
        finally {
            this.connection.disengage((BFoxClientConnection.Interest)interest);
        }
    }

    public Map<String, SlotPath> handleToPath(List<String> handles, String connectionDescription) {
        if (handles.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, SlotPath> handlesToPaths = new HashMap<String, SlotPath>(handles.size());
        boolean supportsVirtualHandleToPath = this.stationAdapter.getStationVersion(BNiagaraVirtualChannel.VER_4_6).compareTo(BNiagaraVirtualChannel.VER_4_6) >= 0;
        List<SlotPath> slotPaths = !supportsVirtualHandleToPath || FORCE_LEGACY_HANDLE_TO_PATH ? this.legacyHandleToPath(handles, connectionDescription) : this.virtualHandleToPath(handles, connectionDescription);
        for (int i = 0; i < slotPaths.size(); ++i) {
            if (slotPaths.get(i) == null) continue;
            handlesToPaths.put(handles.get(i), slotPaths.get(i));
        }
        return handlesToPaths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SlotPath> virtualHandleToPath(List<String> handles, String connectionDescription) {
        List<SlotPath> slotPaths = Collections.emptyList();
        FoxConnectInterest interest = new FoxConnectInterest(connectionDescription);
        BNiagaraVirtualChannel virtualChannel = this.getVirtualChannel();
        try {
            this.connection.engageNoRetry((BFoxClientConnection.Interest)interest);
            slotPaths = Arrays.asList(virtualChannel.handleToPath(handles.toArray()));
        }
        catch (Exception err) {
            this.error("Unable to convert handles to virtual paths using virtual channel", err);
        }
        finally {
            this.connection.disengage((BFoxClientConnection.Interest)interest);
        }
        return slotPaths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SlotPath> legacyHandleToPath(Collection<String> handles, String connectionDescription) {
        List<SlotPath> slotPaths = Collections.emptyList();
        Object[] handlesArray = handles.toArray(new String[handles.size()]);
        BFoxSession session = this.makeNewFoxSession();
        FoxConnectInterest interest = new FoxConnectInterest(connectionDescription);
        try {
            session.getConnection().engageNoRetry((BFoxClientConnection.Interest)interest);
            BBrokerChannel broker = this.getBrokerChannel(session);
            slotPaths = Arrays.asList(broker.handleToPath(handlesArray));
        }
        catch (Exception err) {
            this.error("Unable to convert handles to virtual paths using broker channel", err);
        }
        finally {
            session.getConnection().disengage((BFoxClientConnection.Interest)interest);
        }
        return slotPaths;
    }

    public BObject resolveBqlQuery(BOrd ord, String connectionDescription) throws Exception {
        FoxConnectInterest interest = new FoxConnectInterest(connectionDescription);
        BDataChannel dataChannel = this.getDataChannel();
        try {
            this.connection.engageNoRetry((BFoxClientConnection.Interest)interest);
            BObject bObject = dataChannel.resolve(ord);
            return bObject;
        }
        catch (Exception err) {
            this.error("Unable to resolve virtual BQL query: " + ord, err);
            throw err;
        }
        finally {
            this.connection.disengage((BFoxClientConnection.Interest)interest);
        }
    }

    protected BNiagaraVirtualChannel getVirtualChannel() {
        return (BNiagaraVirtualChannel)this.connection.getChannels().get("niagaraVirtual", BNiagaraVirtualChannel.TYPE);
    }

    protected BPointChannel getPointChannel() {
        return (BPointChannel)this.connection.getChannels().get("point", BPointChannel.TYPE);
    }

    protected BBrokerChannel getBrokerChannel(BFoxSession session) {
        BOrd.make((String)"station:").resolve((BObject)session);
        return (BBrokerChannel)session.getConnection().getChannels().get("station", BBrokerChannel.TYPE);
    }

    protected BDataChannel getDataChannel() {
        return (BDataChannel)this.connection.getChannels().get("data", BDataChannel.TYPE);
    }

    protected BFoxSession makeNewFoxSession() {
        return (BFoxSession)BFoxProxySession.make((BHost)this.connection.getRemoteHost(), (int)this.connection.getPort(), (boolean)this.connection.getUseFoxs(), (BIUserCredentials)this.connection.getCredentials());
    }

    public boolean isTraceOn() {
        return LOG.isTraceOn();
    }

    public void trace(String msg) {
        LOG.trace(msg);
    }

    public void message(String msg) {
        LOG.message(msg);
    }

    public void error(String msg, Exception e) {
        LOG.error(msg, (Throwable)e);
    }

    static {
        if (FORCE_LEGACY_HANDLE_TO_PATH) {
            System.out.println("*** Forcing Niagara Virtuals to use legacy handle to path ***");
        }
    }

    private static final class FoxConnectInterest
    implements BFoxClientConnection.Interest {
        private String name;

        FoxConnectInterest(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        void setName(String name) {
            this.name = name;
        }
    }
}

