/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.virtual;

import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.file.BFileOverwritePolicy;
import com.tridium.nv.BNiagaraVirtualPolicies;
import javax.baja.agent.BPxView;
import javax.baja.control.trigger.BManualTriggerMode;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.data.BIDataValue;
import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraSlots;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.registry.TypeInfo;
import javax.baja.status.BStatus;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraSlots(properties={@NiagaraProperty(name="importVirtualPxFilesOnDemand", type="boolean", defaultValue="false"), @NiagaraProperty(name="pxFileImportOverwritePolicy", type="niagaraDriver:FileOverwritePolicy", defaultValue="BFileOverwritePolicy.checksum"), @NiagaraProperty(name="pxFileImportExecutionTime", type="control:TriggerMode", defaultValue="BManualTriggerMode.make()"), @NiagaraProperty(name="virtualPxFileDirectory", type="baja:Ord", defaultValue="BOrd.make(\"file:^nstations\")", facets={@Facet(name="BFacets.TARGET_TYPE", value="BString.make(\"baja:IDirectory\")")}), @NiagaraProperty(name="virtualPxFileMediaDirectory", type="baja:Ord", defaultValue="BOrd.make(\"file:^nstations\")", facets={@Facet(name="BFacets.TARGET_TYPE", value="BString.make(\"baja:IDirectory\")")})})
public final class BNiagaraVirtualNetworkExt
extends BNiagaraVirtualPolicies {
    public static final Property importVirtualPxFilesOnDemand = BNiagaraVirtualNetworkExt.newProperty((int)0, (boolean)false, null);
    public static final Property pxFileImportOverwritePolicy = BNiagaraVirtualNetworkExt.newProperty((int)0, (BValue)BFileOverwritePolicy.checksum, null);
    public static final Property pxFileImportExecutionTime = BNiagaraVirtualNetworkExt.newProperty((int)0, (BValue)BManualTriggerMode.make(), null);
    public static final Property virtualPxFileDirectory = BNiagaraVirtualNetworkExt.newProperty((int)0, (BValue)BOrd.make((String)"file:^nstations"), (BFacets)BFacets.make((String)"targetType", (BIDataValue)BString.make((String)"baja:IDirectory")));
    public static final Property virtualPxFileMediaDirectory = BNiagaraVirtualNetworkExt.newProperty((int)0, (BValue)BOrd.make((String)"file:^nstations"), (BFacets)BFacets.make((String)"targetType", (BIDataValue)BString.make((String)"baja:IDirectory")));
    public static final Type TYPE = Sys.loadType(BNiagaraVirtualNetworkExt.class);
    private static TypeInfo abstractSubPxViewType = TYPE.getTypeInfo();
    private static TypeInfo reloadVirtualPxType = null;

    public boolean getImportVirtualPxFilesOnDemand() {
        return this.getBoolean(importVirtualPxFilesOnDemand);
    }

    public void setImportVirtualPxFilesOnDemand(boolean v) {
        this.setBoolean(importVirtualPxFilesOnDemand, v, null);
    }

    public BFileOverwritePolicy getPxFileImportOverwritePolicy() {
        return (BFileOverwritePolicy)this.get(pxFileImportOverwritePolicy);
    }

    public void setPxFileImportOverwritePolicy(BFileOverwritePolicy v) {
        this.set(pxFileImportOverwritePolicy, (BValue)v, null);
    }

    public BTriggerMode getPxFileImportExecutionTime() {
        return (BTriggerMode)this.get(pxFileImportExecutionTime);
    }

    public void setPxFileImportExecutionTime(BTriggerMode v) {
        this.set(pxFileImportExecutionTime, (BValue)v, null);
    }

    public BOrd getVirtualPxFileDirectory() {
        return (BOrd)this.get(virtualPxFileDirectory);
    }

    public void setVirtualPxFileDirectory(BOrd v) {
        this.set(virtualPxFileDirectory, (BValue)v, null);
    }

    public BOrd getVirtualPxFileMediaDirectory() {
        return (BOrd)this.get(virtualPxFileMediaDirectory);
    }

    public void setVirtualPxFileMediaDirectory(BOrd v) {
        this.set(virtualPxFileMediaDirectory, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BNiagaraNetwork;
    }

    protected final boolean checkLicense() {
        try {
            Feature f = Sys.getLicenseManager().checkFeature("tridium", "niagaraDriver");
            return f.getb("virtual", false);
        }
        catch (Exception e) {
            System.out.println("niagaraDriver for Niagara Virtuals not licensed...");
            e.printStackTrace();
            return false;
        }
    }

    public BStatus getStatus() {
        return this.getNiagaraNetwork().getStatus();
    }

    public void postAsync(Runnable runnable) {
        this.getNiagaraNetwork().getWorkers().process(runnable);
    }

    public String[] getStationNames() {
        Array nameArray = new Array(String.class);
        this.findStationNames((BComponent)this.getNiagaraNetwork(), (Array<String>)nameArray);
        return (String[])nameArray.trim();
    }

    private void findStationNames(BComponent comp, Array<String> nameArray) {
        if (comp == null) {
            return;
        }
        if (comp instanceof BNiagaraStation) {
            nameArray.add((Object)((BNiagaraStation)comp).getStationName());
            return;
        }
        BComponent[] kids = comp.getChildComponents();
        for (int i = 0; i < kids.length; ++i) {
            this.findStationNames(kids[i], nameArray);
        }
    }

    public boolean supportsRemoteType(Type type) {
        return true;
    }

    public boolean supportsRemoteAgentType(TypeInfo agentTypeInfo, BComponent target) {
        if (TYPE.getTypeInfo() == abstractSubPxViewType) {
            try {
                abstractSubPxViewType = BTypeSpec.make((String)"niagaraDriver", (String)"AbstractSubstitutePxView").getTypeInfo();
                reloadVirtualPxType = BTypeSpec.make((String)"niagaraDriver", (String)"ReloadVirtualPxAction").getTypeInfo();
            }
            catch (Exception e) {
                abstractSubPxViewType = null;
            }
        }
        if (!this.getImportVirtualPxFilesOnDemand() && (agentTypeInfo.is(BPxView.TYPE) || abstractSubPxViewType != null && agentTypeInfo.is(abstractSubPxViewType))) {
            try {
                BValue val = target.get("reloadNiagaraVirtualPxViews");
                if (val != null && val.getType().is(reloadVirtualPxType)) {
                    target.remove("reloadNiagaraVirtualPxViews");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    private BNiagaraNetwork getNiagaraNetwork() {
        return (BNiagaraNetwork)this.getParent();
    }
}

