/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.virtual;

import com.tridium.fox.message.FoxBoolean;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.message.FoxString;
import com.tridium.fox.message.FoxTuple;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.fox.sys.BFoxChannelRegistry;
import com.tridium.fox.sys.broker.BBrokerChannel;
import com.tridium.fox.sys.data.BDataChannel;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.virtual.BNiagaraVirtualNetworkExt;
import com.tridium.nv.BNiagaraVirtualComponent;
import com.tridium.nv.BNiagaraVirtualGateway;
import com.tridium.nv.BSlotInfo;
import com.tridium.nv.NiagaraVirtualUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.baja.agent.BPxView;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.BatchResolve;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.security.BPermissions;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BAction;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BTopic;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.BNameList;
import javax.baja.util.BNameMap;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BWsAnnotation;
import javax.baja.util.Version;
import javax.baja.virtual.BVirtualComponent;
import javax.baja.virtual.BVirtualGateway;
import javax.baja.virtual.VirtualPath;

public class BNiagaraVirtualChannel
extends BFoxChannel {
    public static final Type TYPE = Sys.loadType(BNiagaraVirtualChannel.class);
    public static final String CHANNEL_NAME = "niagaraVirtual";
    private static final String DISCOVER = "disc";
    private static final String DISCOVER_ORD = "o";
    private static final String DISCOVER_ROOT_ORD = "r";
    private static final String DISCOVER_COMP = "cp";
    private static final String DISCOVER_NAME = "n";
    private static final String DISCOVER_DISPLAY_NAME = "d";
    private static final String DISCOVER_FACETS = "a";
    private static final String DISCOVER_CONFIG_FLAGS = "c";
    private static final String DISCOVER_TYPE = "t";
    private static final String DISCOVER_IS_COMPONENT = "i";
    private static final String DISCOVER_IS_FROZEN = "f";
    private static final String DISCOVER_IS_NIAGARA_VIRTUAL = "nv";
    private static final String DISCOVER_DEFAULT_VALUE = "dv";
    private static final String DISCOVER_ICON = "di";
    private static final String DISCOVER_POINTS = "pointDiscovery";
    private static final String DISCOVER_PARTIAL = "discPl";
    private static final Logger log = Logger.getLogger("fox.niagaraVirtual");
    public static final Version VER_4_6 = new Version("4.6");
    private static final Version VER_4_3 = new Version("4.3");
    private static final BOrd STATION_ORD = BOrd.make((String)"station:");
    private static BNiagaraVirtualNetworkExt niagaraVirtualNetworkExt;

    public Type getType() {
        return TYPE;
    }

    public BNiagaraVirtualChannel() {
        super(CHANNEL_NAME);
    }

    protected boolean useSharedKeyEncryption() {
        return true;
    }

    public void checkProcess(FoxRequest req) throws Throwable {
    }

    public FoxResponse process(FoxRequest request) throws Throwable {
        String command = request.command;
        if (command == DISCOVER) {
            return this.discover(request);
        }
        if (command == DISCOVER_PARTIAL) {
            return this.discoverPartial(request);
        }
        if (command == "handleToPath") {
            return BBrokerChannel.handleToPath((BFoxChannel)this, (BComponentSpace)Sys.getStation().getComponentSpace(), (FoxRequest)request);
        }
        throw new InvalidCommandException(command);
    }

    public synchronized BNiagaraVirtualGateway.FullSlotInfo[] discover(BOrd ord) throws Exception {
        List<BNiagaraVirtualGateway.FullSlotInfo> infos = this.discover(ord, true);
        return infos.toArray(new BNiagaraVirtualGateway.FullSlotInfo[infos.size()]);
    }

    public synchronized BSlotInfo[] discoverPoints(BOrd ord) throws Exception {
        return (BSlotInfo[])this.discover(ord, true).stream().map(info -> info.getSlotInfo()).toArray(BSlotInfo[]::new);
    }

    private synchronized List<BNiagaraVirtualGateway.FullSlotInfo> discover(BOrd ord, boolean pointDiscovery) throws Exception {
        FoxRequest req = this.makeRequest(DISCOVER);
        req.add(DISCOVER_ORD, ord.toString());
        req.add(DISCOVER_POINTS, pointDiscovery);
        if (this.isTraceOn()) {
            this.trace("c:disc");
            req.dump();
        }
        FoxResponse resp = this.sendSync(req);
        FoxTuple[] respTuples = resp.list(DISCOVER_COMP);
        ArrayList<BNiagaraVirtualGateway.FullSlotInfo> slotInfos = new ArrayList<BNiagaraVirtualGateway.FullSlotInfo>(respTuples.length);
        Version remoteVersion = new Version(this.getConnection().session().getRemoteHello().getString("app.version", ""));
        boolean legacyPxViewMode = remoteVersion.compareTo(VER_4_3) < 0;
        for (FoxTuple tuple : respTuples) {
            FoxMessage message = (FoxMessage)tuple;
            FoxTuple[] children = message.list(DISCOVER_COMP);
            ArrayList<BSlotInfo> childList = children.length == 0 ? Collections.emptyList() : new ArrayList<BSlotInfo>(children.length);
            for (FoxTuple child : children) {
                childList.add(this.decodeFoxMessageToSlotInfo((FoxMessage)child, legacyPxViewMode, null));
            }
            BNiagaraVirtualGateway.FullSlotInfo info = new BNiagaraVirtualGateway.FullSlotInfo(this.decodeFoxMessageToSlotInfo(message, legacyPxViewMode, null), childList);
            slotInfos.add(info);
        }
        return slotInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FoxResponse discover(FoxRequest request) throws Exception {
        FoxResponse resp = new FoxResponse(request);
        BOrd ord = BOrd.make((String)request.getString(DISCOVER_ORD));
        boolean pointDiscovery = request.getBoolean(DISCOVER_POINTS, false);
        BObject resolvedObject = ord.get((BObject)Sys.getStation());
        if (resolvedObject instanceof BComponent) {
            BObject bObject = resolvedObject;
            synchronized (bObject) {
                BComponent resolvedComp = (BComponent)resolvedObject;
                resolvedComp.loadSlots();
                BPermissions permissions = this.getPermissionsFor(resolvedComp);
                if (permissions.hasOperatorRead()) {
                    if (resolvedComp instanceof BVirtualGateway) {
                        FoxMessage msg;
                        BVirtualComponent vComp;
                        BComponentSpace space = ((BVirtualGateway)resolvedComp).getVirtualSpace();
                        if (space != null && (vComp = (BVirtualComponent)space.getRootComponent()) != null && (msg = this.makeFoxMessageFromRootVirtualComponent(vComp)) != null) {
                            resp.add((FoxTuple)msg);
                        }
                    } else {
                        SlotCursor c = resolvedComp.getProperties();
                        while (c.next()) {
                            Version remoteVersion;
                            Property prop = c.property();
                            if (!pointDiscovery && NiagaraVirtualUtil.hasIllegalVirtualPathChars((String)prop.getName()) && (remoteVersion = new Version(this.getConnection().session().getRemoteHello().getString("app.version", ""))).compareTo(VER_4_6) < 0) {
                                StringBuffer buff = new StringBuffer();
                                String ordStr = resolvedComp.getNavOrd().toString();
                                buff.append("Cannot add Niagara Virtual: ").append(ordStr);
                                if (!ordStr.endsWith("/")) {
                                    buff.append("/");
                                }
                                buff.append(prop.getName()).append(" - Slot name '").append(SlotPath.unescape((String)prop.getName())).append("' has illegal virtual characters (/|:$)");
                                log.info(buff.toString());
                                continue;
                            }
                            FoxMessage message = this.makeFoxMessageHierarchyFromComponentProperty(resolvedComp, c.property(), NiagaraVirtualUtil.toSlotOrd((BOrd)ord, (BComponent)resolvedComp, (String)c.property().getName()).getOrd());
                            if (message == null) continue;
                            resp.add((FoxTuple)message);
                        }
                    }
                }
            }
        }
        if (this.isTraceOn()) {
            this.trace("s:disc");
            resp.dump();
        }
        return resp;
    }

    public synchronized BNiagaraVirtualGateway.PartialSlotInfo[] discoverPartial(BOrd rootOrd, BOrd[] vOrds) throws Exception {
        FoxRequest req = this.makeRequest(DISCOVER_PARTIAL);
        req.add(DISCOVER_ROOT_ORD, rootOrd.toString());
        for (int i = 0; i < vOrds.length; ++i) {
            req.add(DISCOVER_ORD, vOrds[i].toString());
        }
        if (this.isTraceOn()) {
            this.trace("c:discPl");
            req.dump();
        }
        FoxResponse resp = this.sendSync(req);
        FoxTuple[] tuples = resp.list(DISCOVER_COMP);
        ArrayList<BNiagaraVirtualGateway.PartialSlotInfo> infos = new ArrayList<BNiagaraVirtualGateway.PartialSlotInfo>(tuples.length);
        Version remoteVersion = new Version(this.getConnection().session().getRemoteHello().getString("app.version", ""));
        boolean legacyPxViewMode = remoteVersion.compareTo(VER_4_3) < 0;
        for (int i = 0; i < tuples.length; ++i) {
            FoxMessage message = (FoxMessage)tuples[i];
            BSlotInfo info = this.decodeFoxMessageToSlotInfo(message, legacyPxViewMode, null);
            infos.add(new BNiagaraVirtualGateway.PartialSlotInfo(info.getSlotOrd(), info));
        }
        return infos.toArray(new BNiagaraVirtualGateway.PartialSlotInfo[infos.size()]);
    }

    private FoxResponse discoverPartial(FoxRequest request) throws Exception {
        FoxResponse resp = new FoxResponse(request);
        BOrd rootOrd = BOrd.make((String)request.getString(DISCOVER_ROOT_ORD));
        BComponent root = (BComponent)BOrd.make((String)request.getString(DISCOVER_ROOT_ORD)).get((BObject)Sys.getStation());
        BOrd[] ords = (BOrd[])Stream.of(request.listStrings(DISCOVER_ORD)).map(vOrdStr -> NiagaraVirtualUtil.fromClientVirtualToServerOrd((BOrd)rootOrd, (BComponent)root, (VirtualPath)new VirtualPath(vOrdStr.substring(8)))).filter(ord -> !ord.isNull()).toArray(BOrd[]::new);
        if (ords.length == 0) {
            return resp;
        }
        BatchResolve batch = new BatchResolve(ords);
        batch.resolve((BObject)Sys.getStation());
        LinkedHashMap<String, FoxMessage> messageMap = new LinkedHashMap<String, FoxMessage>();
        for (int i = 0; i < ords.length; ++i) {
            try {
                FoxMessage message;
                BComponent parent;
                OrdTarget target = batch.getTarget(i);
                BComponent resolvedComp = target.getComponent();
                if (resolvedComp == null) continue;
                Property prop = null;
                if (target.getSlotInComponent() != null) {
                    if (!target.getSlotInComponent().isProperty()) continue;
                    prop = target.getSlotInComponent().asProperty();
                }
                if (prop == null && (parent = (BComponent)resolvedComp.getParent()) != null) {
                    prop = resolvedComp.getPropertyInParent();
                    resolvedComp = parent;
                }
                if ((message = this.makeFoxMessageHierarchyFromComponentProperty(resolvedComp, prop, ords[i])) == null) continue;
                messageMap.put(message.getString(DISCOVER_ORD), message);
                for (FoxTuple kid : message.list(DISCOVER_COMP)) {
                    FoxMessage kidMessage = (FoxMessage)kid;
                    messageMap.put(kidMessage.getString(DISCOVER_ORD), kidMessage);
                }
                message.remove(DISCOVER_COMP);
                continue;
            }
            catch (Exception target) {
                // empty catch block
            }
        }
        for (FoxMessage message : messageMap.values()) {
            resp.add((FoxTuple)message);
        }
        if (this.isTraceOn()) {
            this.trace("s:discPl");
            resp.dump();
        }
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FoxMessage makeFoxMessageHierarchyFromComponentProperty(BComponent resolvedComp, Property prop, BOrd ord) throws Exception {
        BPermissions permissions = this.getPermissionsFor(resolvedComp);
        if (!permissions.hasOperatorRead()) {
            return null;
        }
        FoxMessage message = null;
        BComponent bComponent = resolvedComp;
        synchronized (bComponent) {
            BValue value = resolvedComp.get(prop);
            BComponent childComponent = null;
            if (value instanceof BComponent) {
                childComponent = (BComponent)value;
            }
            if (prop == null && resolvedComp instanceof BVirtualComponent && resolvedComp.getComponentSpace() != null && resolvedComp.getComponentSpace().getRootComponent() == resolvedComp) {
                message = this.makeFoxMessageFromRootVirtualComponent((BVirtualComponent)resolvedComp);
            } else if (prop != null && (message = this.makeFoxMessageFromComponentProperty(resolvedComp, prop, ord, this.getSessionContext())) != null && childComponent != null) {
                BPxView[] pxViews;
                FoxMessage pointMessage;
                if (childComponent instanceof BControlPoint && (pointMessage = this.makeFoxMessageFromComponentProperty(childComponent, ((BControlPoint)childComponent).getOutProperty(), BOrd.make((String)(ord.toString() + "/out")), this.getSessionContext())) != null) {
                    message.add((FoxTuple)pointMessage);
                }
                for (BPxView view : pxViews = (BPxView[])childComponent.getChildren(BPxView.class)) {
                    FoxMessage viewMessage = this.makeFoxMessageFromComponentProperty(childComponent, view.getPropertyInParent(), BOrd.make((String)(ord.toString() + "/" + view.getName())), this.getSessionContext());
                    if (viewMessage == null) continue;
                    message.add((FoxTuple)viewMessage);
                }
            }
        }
        return message;
    }

    private static BNameMap getNameMapFromComponent(BComponent comp) {
        BNameMap nameMap = BNameMap.DEFAULT;
        BValue value = comp.get("displayNames");
        if (value != null && value instanceof BNameMap) {
            nameMap = (BNameMap)value;
        }
        return nameMap;
    }

    private FoxMessage makeFoxMessageFromComponentProperty(BComponent resolvedComp, Property prop, BOrd ord, Context cx) throws Exception {
        BFormat f;
        BValue val = resolvedComp.get(prop);
        BPermissions permissions = this.getPermissionsFor(val);
        if (!permissions.hasOperatorRead()) {
            return null;
        }
        if (Flags.isHidden((BComplex)resolvedComp, (Slot)prop)) {
            return null;
        }
        String name = prop.getName();
        Type type = val.getType();
        if (name.equals("displayNames") && type.is(BNameMap.TYPE)) {
            return null;
        }
        if (type.is(BWsAnnotation.TYPE) || type.is(BLink.TYPE) || type.is(BTopic.TYPE) || type.is(BAction.TYPE)) {
            return null;
        }
        FoxMessage message = new FoxMessage(DISCOVER_COMP);
        String displayName = null;
        boolean isComponent = false;
        BNameMap nameMap = BNiagaraVirtualChannel.getNameMapFromComponent(resolvedComp);
        if (nameMap != BNameMap.DEFAULT && (f = nameMap.get(name)) != null) {
            displayName = f.encodeToString();
        }
        if (type.is(BComponent.TYPE)) {
            isComponent = true;
            BComponent comp = val.asComponent();
            try {
                List<Object> pxViews = Arrays.asList(comp.getChildren(BPxView.class));
                if (!pxViews.isEmpty()) {
                    BNameList pxSlotNames = BNameList.make((String[])((String[])pxViews.stream().map(pxView -> pxView.getName()).toArray(String[]::new)));
                    message.add(DISCOVER_FACETS, BFacets.make((String)"nVirtualPxViewNames", (String)pxSlotNames.encodeToString()).encodeToString());
                }
            }
            catch (Exception pxViews) {
                // empty catch block
            }
            try {
                BValue icon = comp.get("icon");
                if (icon instanceof BIcon) {
                    message.add(DISCOVER_ICON, comp.getIcon().encodeToString());
                }
            }
            catch (Exception exception) {}
        } else {
            message.add(DISCOVER_FACETS, resolvedComp.getSlotFacets((Slot)prop).encodeToString());
            message.add(DISCOVER_CONFIG_FLAGS, resolvedComp.getFlags((Slot)prop));
            message.add(DISCOVER_DEFAULT_VALUE, this.marshal(val, cx));
        }
        message.add(DISCOVER_NAME, name);
        message.add(DISCOVER_IS_COMPONENT, isComponent);
        message.add(DISCOVER_ORD, ord.toString());
        if (isComponent && type.is(BNiagaraVirtualComponent.TYPE)) {
            BNiagaraVirtualComponent vComp = (BNiagaraVirtualComponent)val;
            message.add(DISCOVER_TYPE, vComp.getNiagaraVirtualCompInfo().getTypeSpec());
            message.add(DISCOVER_IS_FROZEN, resolvedComp.getSlotFacets((Slot)prop).getb("nVirtualFroz", false));
            message.add(DISCOVER_IS_NIAGARA_VIRTUAL, true);
        } else {
            message.add(DISCOVER_TYPE, type.getTypeSpec().toString());
            message.add(DISCOVER_IS_FROZEN, resolvedComp.getSlotFacets((Slot)prop).getb("nVirtualFroz", prop.isFrozen()));
            message.add(DISCOVER_IS_NIAGARA_VIRTUAL, resolvedComp instanceof BNiagaraVirtualComponent);
        }
        if (displayName != null) {
            message.add(DISCOVER_DISPLAY_NAME, displayName);
        }
        return message;
    }

    private FoxMessage makeFoxMessageFromRootVirtualComponent(BVirtualComponent vComp) {
        BPermissions permissions = this.getPermissionsFor(vComp);
        if (!permissions.hasOperatorRead()) {
            return null;
        }
        FoxMessage message = new FoxMessage(DISCOVER_COMP);
        message.add(DISCOVER_NAME, "virtual");
        message.add(DISCOVER_IS_COMPONENT, true);
        message.add(DISCOVER_ORD, NiagaraVirtualUtil.toSlotOrd((BOrd)BOrd.NULL, (BComponent)vComp, (String)"").toString());
        message.add(DISCOVER_TYPE, vComp.getType().getTypeSpec().toString());
        message.add(DISCOVER_IS_FROZEN, false);
        message.add(DISCOVER_IS_NIAGARA_VIRTUAL, vComp instanceof BNiagaraVirtualComponent);
        return message;
    }

    private BSlotInfo decodeFoxMessageToSlotInfo(FoxMessage message, boolean legacyPxViewMode, Context cx) throws Exception {
        FoxTuple niagaraVirtualTuple;
        BSlotInfo info = new BSlotInfo();
        info.setSlotName(message.getString(DISCOVER_NAME));
        info.setIsFrozen(message.getBoolean(DISCOVER_IS_FROZEN));
        info.setIsComponent(message.getBoolean(DISCOVER_IS_COMPONENT));
        info.setTypeSpec(message.getString(DISCOVER_TYPE));
        FoxTuple discoverOrdTuple = message.getOptional(DISCOVER_ORD);
        if (discoverOrdTuple != null) {
            info.setSlotOrd(BOrd.make((String)((FoxString)discoverOrdTuple).value));
        }
        if (!info.getIsComponent()) {
            info.setSlotFlags(info.getSlotFlags() | message.getInt(DISCOVER_CONFIG_FLAGS));
            info.setFacets((BFacets)BFacets.DEFAULT.decodeFromString(message.getString(DISCOVER_FACETS)));
        } else {
            try {
                if (legacyPxViewMode && BNiagaraVirtualChannel.importVirtualPxFilesOnDemand()) {
                    this.legacyAddPxViewNames(info);
                } else {
                    String pxViewFacets = message.getString(DISCOVER_FACETS, null);
                    if (pxViewFacets != null) {
                        BFacets facets = (BFacets)BFacets.DEFAULT.decodeFromString(pxViewFacets);
                        info.setFacets(BFacets.make((String)"nVirtualPxViewNames", (String)facets.gets("nVirtualPxViewNames", "")));
                    }
                }
            }
            catch (Exception pxViewFacets) {
                // empty catch block
            }
            try {
                String iconStr = message.getString(DISCOVER_ICON, null);
                if (iconStr != null) {
                    info.setSlotIcon((BIcon)BIcon.DEFAULT.decodeFromString(iconStr));
                }
            }
            catch (Exception iconStr) {
                // empty catch block
            }
        }
        FoxTuple displayNameTuple = message.getOptional(DISCOVER_DISPLAY_NAME);
        if (displayNameTuple != null) {
            info.setSlotDisplayName(BFormat.make((String)((FoxString)displayNameTuple).value));
        }
        if ((niagaraVirtualTuple = message.getOptional(DISCOVER_IS_NIAGARA_VIRTUAL)) != null) {
            info.setIsNiagaraVirtual(((FoxBoolean)niagaraVirtualTuple).value);
        }
        FoxTuple defaultValTuple = message.getOptional(DISCOVER_DEFAULT_VALUE);
        try {
            if (defaultValTuple != null) {
                info.setDefaultValue(this.unmarshal(((FoxString)defaultValTuple).value, cx));
            } else if (legacyPxViewMode && BNiagaraVirtualChannel.importVirtualPxFilesOnDemand()) {
                this.legacyAddPxViewValue(info);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return info;
    }

    private static boolean importVirtualPxFilesOnDemand() {
        if (niagaraVirtualNetworkExt == null || niagaraVirtualNetworkExt.getComponentSpace() == null) {
            try {
                niagaraVirtualNetworkExt = ((BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE)).getVirtualPolicies();
            }
            catch (ServiceNotFoundException e) {
                niagaraVirtualNetworkExt = null;
            }
        }
        if (niagaraVirtualNetworkExt != null) {
            return niagaraVirtualNetworkExt.getImportVirtualPxFilesOnDemand();
        }
        return false;
    }

    private BDataChannel getDataChannel() {
        return (BDataChannel)((BFoxChannelRegistry)this.getParent()).get("data", BDataChannel.TYPE);
    }

    private void legacyAddPxViewNames(BSlotInfo info) throws Exception {
        BOrd pxNameQuery = BOrd.make((BOrd)STATION_ORD, (BOrd)BOrd.make((BOrd)info.getSlotOrd(), (String)"bql:select name from baja:PxView depth=1"));
        BITable pxNameTable = (BITable)this.getDataChannel().resolve(pxNameQuery);
        Column pxNameColumn = pxNameTable.getColumns().get(0);
        ArrayList<String> pxViewNames = null;
        try (TableCursor cursor = pxNameTable.cursor();){
            while (cursor.next()) {
                if (pxViewNames == null) {
                    pxViewNames = new ArrayList<String>();
                }
                pxViewNames.add(cursor.cell(pxNameColumn).toString());
            }
        }
        if (pxViewNames != null) {
            BNameList pxViewNameList = BNameList.make((String[])pxViewNames.toArray(new String[pxViewNames.size()]));
            info.setFacets(BFacets.make((BFacets)info.getFacets(), (String)"nVirtualPxViewNames", (BIDataValue)BString.make((String)pxViewNameList.encodeToString())));
        }
    }

    private void legacyAddPxViewValue(BSlotInfo info) throws Exception {
        Type valType = BTypeSpec.make((String)info.getTypeSpec()).getResolvedType();
        if (valType.is(BPxView.TYPE)) {
            StringBuilder bqlQuery = new StringBuilder();
            bqlQuery.append("bql:select ");
            BPxView pxView = (BPxView)valType.getInstance();
            SlotCursor slotCursor = pxView.getProperties();
            ArrayList<Property> pxViewProps = new ArrayList<Property>();
            int simplePropCount = 0;
            while (slotCursor.next(BSimple.class)) {
                if (simplePropCount++ > 0) {
                    bqlQuery.append(", ");
                }
                Property prop = slotCursor.property();
                pxViewProps.add(prop);
                String pName = prop.getName();
                bqlQuery.append(pName).append(".encodeToString");
            }
            if (simplePropCount > 0) {
                bqlQuery.append(" from baja:PxView depth=1 where name = '").append(info.getSlotName()).append('\'');
                BOrd pxViewPropQuery = BOrd.make((BOrd)STATION_ORD, (BOrd)BOrd.make((BOrd)info.getSlotOrd().getParent(), (String)bqlQuery.toString()));
                BITable pxViewPropTable = (BITable)this.getDataChannel().resolve(pxViewPropQuery);
                try (TableCursor cursor = pxViewPropTable.cursor();){
                    if (cursor.next()) {
                        for (Property prop : pxViewProps) {
                            String columnVal;
                            Column column = pxViewPropTable.getColumns().get(prop.getName() + ".encodeToString");
                            if (column == null || (columnVal = cursor.cell(column).toString()).isEmpty() || "NULL".equals(columnVal)) continue;
                            pxView.set(prop, prop.getDefaultValue().asSimple().decodeFromString(columnVal).asValue());
                        }
                    }
                }
                info.setDefaultValue((BValue)pxView);
            }
        }
    }

    public SlotPath[] handleToPath(Object[] handles) throws Exception {
        Version remoteVersion = new Version(this.getConnection().session().getRemoteHello().getString("app.version", ""));
        if (remoteVersion.compareTo(VER_4_6) < 0) {
            throw new UnsupportedOperationException("virtuals handleToPath only supported in Niagara 4.6 onwards");
        }
        return BBrokerChannel.handleToPath((BFoxChannel)this, (Object[])handles);
    }
}

