/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.sysdef;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.sysdef.BNiagaraSysDefDeviceExt;
import com.tridium.nd.sysdef.SysDefException;
import com.tridium.util.BRetryableAction;
import javax.baja.data.BIDataValue;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

public class BSyncTask
extends BRetryableAction {
    public static final Property delay = BSyncTask.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)1), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.DEFAULT));
    public static final Property requestReciprocatedSync = BSyncTask.newProperty((int)4, (boolean)false, null);
    public static final Property signalPurge = BSyncTask.newProperty((int)4, (boolean)false, null);
    public static final Type TYPE = Sys.loadType(BSyncTask.class);

    public BRelTime getDelay() {
        return (BRelTime)this.get(delay);
    }

    public void setDelay(BRelTime v) {
        this.set(delay, (BValue)v, null);
    }

    public boolean getRequestReciprocatedSync() {
        return this.getBoolean(requestReciprocatedSync);
    }

    public void setRequestReciprocatedSync(boolean v) {
        this.setBoolean(requestReciprocatedSync, v, null);
    }

    public boolean getSignalPurge() {
        return this.getBoolean(signalPurge);
    }

    public void setSignalPurge(boolean v) {
        this.setBoolean(signalPurge, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    protected BNiagaraSysDefDeviceExt getExt() {
        return (BNiagaraSysDefDeviceExt)this.getParent();
    }

    protected BNiagaraStation getStation() {
        return (BNiagaraStation)this.getExt().getDevice();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecution() throws Exception {
        BNiagaraSysDefDeviceExt ext = this.getExt();
        BFoxClientConnection conn = ext.getClientConnection();
        BNiagaraSysDefDeviceExt.SysDefInterest interest = this.getExt().makeInterest("syncTask");
        try {
            if (!ext.isOperational()) {
                throw new SysDefException("The SysDef extension is not operational: " + ext.getStatus());
            }
            if (!ext.getRoleManager().isRoleSynced()) {
                throw new SysDefException("The role manager has not sync'd the roles yet. " + ext.getRoleManager().getFaultCause());
            }
            if (!ext.getRole().isPeer()) {
                conn.engageNoRetry((BFoxClientConnection.Interest)interest);
            }
            switch (ext.getRole().getOrdinal()) {
                case 1: {
                    ext.getSysDefChannel().syncToSubordinate(this);
                    break;
                }
                case 2: {
                    ext.getSysDefChannel().syncToSupervisor(this);
                    break;
                }
                case 0: {
                    this.getStation().getNiagaraNetwork().getSysDefProvider().purge();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected Role: " + (Object)((Object)ext.getRole()));
                }
            }
            this.setRequestReciprocatedSync(false);
            this.setSignalPurge(false);
        }
        finally {
            if (conn.isEngaged((BFoxClientConnection.Interest)interest)) {
                conn.disengage((BFoxClientConnection.Interest)interest);
            }
        }
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        BNiagaraStation station;
        if (action == execute && (station = this.getStation()) != null) {
            station.getWorker().postAsync((Runnable)new Invocation((BComponent)this, action, argument, cx));
            return null;
        }
        return super.post(action, argument, cx);
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property == requestReciprocatedSync) {
            if (this.getRequestReciprocatedSync()) {
                this.execute();
            }
        } else if (property == signalPurge && this.getSignalPurge()) {
            this.execute();
        }
    }
}

