/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.sysdef;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.sys.BBitString;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BResolveBits
extends BBitString {
    public static final int HOST = 1;
    public static final int SERVICES = 2;
    public static final int NETWORK = 4;
    public static final BResolveBits host = (BResolveBits)new BResolveBits(1).intern();
    public static final BResolveBits services = (BResolveBits)new BResolveBits(2).intern();
    public static final BResolveBits network = (BResolveBits)new BResolveBits(4).intern();
    public static final BResolveBits DEFAULT = new BResolveBits(7);
    public static final BResolveBits STATION = new BResolveBits(3);
    public static final BResolveBits ALL = DEFAULT;
    public static final BResolveBits NONE = new BResolveBits(0);
    private static BBitString.Support support = new BBitString.Support((BBitString)DEFAULT);
    public static final Type TYPE;
    private int bits;

    private BResolveBits(int bits) {
        this.bits = bits;
    }

    public static BResolveBits make(int bits) {
        if (bits == BResolveBits.DEFAULT.bits) {
            return DEFAULT;
        }
        return (BResolveBits)new BResolveBits(bits).intern();
    }

    public BResolveBits turnOff(BResolveBits turnOff) {
        return BResolveBits.make(this.bits & ~turnOff.bits);
    }

    public BResolveBits turnOn(BResolveBits turnOn) {
        return BResolveBits.make(this.bits | turnOn.bits);
    }

    public int getBitmask() {
        return this.bits;
    }

    public BObject decode(DataInput decoder) throws IOException {
        return BResolveBits.make(decoder.readInt());
    }

    public BObject decodeFromString(String s) throws IOException {
        try {
            return BResolveBits.make(Integer.parseInt(s, 16));
        }
        catch (Exception x) {
            throw new IOException("Invalid hex encoding of bits: " + s);
        }
    }

    public void encode(DataOutput encoder) throws IOException {
        encoder.writeInt(this.bits);
    }

    public String encodeToString() throws IOException {
        return Integer.toHexString(this.bits);
    }

    public int hashCode() {
        return this.bits;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BResolveBits) {
            return this.bits == ((BResolveBits)((Object)obj)).bits;
        }
        return false;
    }

    public boolean getBit(int ordinal) {
        return (this.bits & ordinal) != 0;
    }

    public boolean isBits(int bitmask) {
        return bitmask == 0 ? this.bits == 0 : (this.bits & bitmask) == bitmask;
    }

    public boolean isBits(BResolveBits other) {
        return this.isBits(other.getBitmask());
    }

    public boolean getBit(String tag) {
        return this.getBit(this.tagToOrdinal(tag));
    }

    public String getDisplayTag(int ordinal, Context cx) {
        return support.getDisplayTag(ordinal, cx);
    }

    public String getEmptyTag() {
        return "none";
    }

    public BBitString getInstance(int[] ordinals) {
        int b = 0;
        for (int i = 0; i < ordinals.length; ++i) {
            b |= ordinals[i];
        }
        return BResolveBits.make(b);
    }

    public int[] getOrdinals() {
        return support.getOrdinals();
    }

    public String getTag(int ordinal) {
        return support.getTag(ordinal);
    }

    public boolean isEmpty() {
        return this.bits == 0;
    }

    public boolean isStation() {
        return this.bits == BResolveBits.STATION.bits;
    }

    public boolean isNetwork() {
        return this.bits == BResolveBits.network.bits;
    }

    public boolean isOrdinal(int ordinal) {
        return support.isOrdinal(ordinal);
    }

    public boolean isTag(String tag) {
        return support.isTag(tag);
    }

    public int tagToOrdinal(String tag) {
        return support.tagToOrdinal(tag);
    }

    public String toString(Context context) {
        if (this.bits == 0) {
            return "{ }";
        }
        StringBuffer sb = new StringBuffer("{ ");
        if (this.getBit(1)) {
            sb.append(this.getTag(1)).append(" ");
        }
        if (this.getBit(2)) {
            sb.append(this.getTag(2)).append(" ");
        }
        if (this.getBit(4)) {
            sb.append(this.getTag(4)).append(" ");
        }
        sb.append("}");
        return sb.toString();
    }

    public Type getType() {
        return TYPE;
    }

    static {
        support.add(1, "host");
        support.add(2, "services");
        support.add(4, "network");
        TYPE = Sys.loadType(BResolveBits.class);
    }
}

