/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.schedule;

import com.tridium.data.BToDataTable;
import com.tridium.data.DataTableDecoder;
import com.tridium.data.DataTableEncoder;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.nd.BINiagaraDeviceExt;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.schedule.BNiagaraScheduleExport;
import com.tridium.nd.schedule.BNiagaraScheduleImportExt;
import com.tridium.nd.schedule.BNiagaraScheduleLearnJob;
import com.tridium.nd.schedule.BScheduleChannel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.collection.BITable;
import javax.baja.data.BIDataTable;
import javax.baja.driver.schedule.BScheduleDeviceExt;
import javax.baja.driver.schedule.BScheduleExport;
import javax.baja.driver.schedule.BScheduleImportExt;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.BOrd;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Version;

public class BNiagaraScheduleDeviceExt
extends BScheduleDeviceExt
implements BFoxClientConnection.Interest,
BINiagaraDeviceExt {
    public static final Action submitDiscoveryJob = BNiagaraScheduleDeviceExt.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BNiagaraScheduleDeviceExt.class);
    static Logger log = Logger.getLogger("niagaraDriver");

    public BOrd submitDiscoveryJob() {
        return (BOrd)this.invoke(submitDiscoveryJob, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    @Override
    public void clientOpened() {
    }

    @Override
    public void clientClosed() {
    }

    public BITable<?> discover() {
        try {
            this.openConnection(this);
            FoxRequest req = new FoxRequest(this.getChannel(), "learn");
            FoxResponse res = this.send(req);
            BITable<?> bITable = BNiagaraScheduleDeviceExt.decodeTable((FoxMessage)res);
            return bITable;
        }
        catch (RuntimeException x) {
            log.log(Level.SEVERE, "schedule", x);
            throw x;
        }
        catch (Exception x) {
            log.log(Level.SEVERE, "schedule", x);
            throw new BajaRuntimeException((Throwable)x);
        }
        finally {
            try {
                this.closeConnection(this);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    public BOrd doSubmitDiscoveryJob(Context cx) {
        return new BNiagaraScheduleLearnJob(this).submit(cx);
    }

    public String getChannel() {
        return "schedule";
    }

    public BScheduleExport makeExport(String sid) {
        return new BNiagaraScheduleExport(sid);
    }

    public BScheduleImportExt makeImportExt() {
        return new BNiagaraScheduleImportExt();
    }

    @Override
    public void serverOpened() {
    }

    @Override
    public void serverClosed() {
    }

    protected static BITable<?> decodeTable(FoxMessage msg) throws Exception {
        byte[] b = msg.getBlob("table", null);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(b));
        BIDataTable ret = DataTableDecoder.decode((DataInput)in);
        return ret;
    }

    protected static void encode(FoxMessage msg, BITable<?> table) throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        DataTableEncoder.encode((BIDataTable)BToDataTable.toDataTable(table), (DataOutput)dout, null);
        msg.add("table", bout.toByteArray());
    }

    protected static BAbstractSchedule getSupervisor(FoxMessage msg) throws Exception {
        byte[] blob = msg.getBlob("supervisor", null);
        if (blob != null) {
            return (BAbstractSchedule)BNiagaraScheduleDeviceExt.deserialize(blob);
        }
        return null;
    }

    protected static BAbsTime getSubordinateVersion(FoxMessage msg) throws Exception {
        String ver = msg.getString("supervisorVersion", null);
        if (ver == null) {
            return BAbsTime.NULL;
        }
        return (BAbsTime)BAbsTime.NULL.decodeFromString(ver);
    }

    protected static String getSupervisorId(FoxMessage msg) {
        return msg.getString("supervisorId", null);
    }

    protected static FoxMessage setSupervisor(FoxMessage envelope, BAbstractSchedule supervisor, Version bogVersion) throws Exception {
        envelope.add("supervisor", BNiagaraScheduleDeviceExt.serialize((BComponent)supervisor, bogVersion));
        return envelope;
    }

    protected static FoxMessage setSubordinateVersion(FoxMessage envelope, BAbsTime version) throws Exception {
        envelope.add("supervisorVersion", version.encodeToString());
        return envelope;
    }

    protected static FoxMessage setSupervisorId(FoxMessage envelope, String id) throws Exception {
        envelope.add("supervisorId", id);
        return envelope;
    }

    void closeConnection(BFoxClientConnection.Interest i) throws Exception {
        BScheduleChannel ch = this.getClientChannel();
        BFoxClientConnection conn = ch.getClientConnection();
        conn.disengage(i);
    }

    BScheduleChannel getClientChannel() {
        return (BScheduleChannel)((BNiagaraStation)this.getParent()).getClientConnection().getChannels().get(this.getChannel(), BScheduleChannel.TYPE);
    }

    BScheduleImportExt getExtForSupervisorId(String supervisorId) {
        return this.getExt(supervisorId);
    }

    BFoxClientConnection openConnection(BFoxClientConnection.Interest i) throws Exception {
        BScheduleChannel ch = this.getClientChannel();
        BFoxClientConnection conn = ch.getClientConnection();
        conn.engageNoRetry(i);
        return conn;
    }

    FoxResponse send(FoxRequest req) throws Exception {
        FoxResponse res = null;
        BFoxClientConnection conn = null;
        try {
            BScheduleChannel ch = this.getClientChannel();
            conn = ch.getClientConnection();
            res = ch.sendSync(req);
        }
        catch (Exception x) {
            log.log(Level.SEVERE, "schedule", x);
            try {
                ByteArrayOutputStream bo = new ByteArrayOutputStream();
                req.dump((OutputStream)bo);
                log.severe("Request: \n" + new String(bo.toByteArray()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw x;
        }
        return res;
    }

    private static BComponent deserialize(byte[] in) throws Exception {
        ByteArrayInputStream bin = new ByteArrayInputStream(in);
        BComponent c = (BComponent)new ValueDocDecoder((InputStream)bin).decodeDocument();
        return c;
    }

    private static byte[] serialize(BComponent c, Version bogVersion) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ValueDocEncoder encoder = new ValueDocEncoder((OutputStream)out);
        if (bogVersion != null) {
            encoder.getPlugin().setVersion(bogVersion);
        }
        encoder.encodeDocument((BValue)c);
        return out.toByteArray();
    }
}

