/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.point;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.EngageTimeoutException;
import com.tridium.fox.sys.spy.FoxLog;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.point.BNiagaraPointDeviceExt;
import com.tridium.nd.point.BPointChannel;
import com.tridium.nv.point.BSubscriptionState;
import com.tridium.nv.point.INiagaraProxyExt;
import java.util.ArrayList;
import javax.baja.net.NotConnectedException;
import javax.baja.util.ICoalesceable;

public class ClientWorker
implements Runnable,
ICoalesceable,
BFoxClientConnection.Interest {
    public static final int WORKER_SLEEP = 1000;
    private final FoxLog log;
    private final BNiagaraPointDeviceExt points;
    private final BNiagaraStation station;
    private final BFoxClientConnection connection;
    private final BPointChannel channel;
    private ArrayList<INiagaraProxyExt> toSub = new ArrayList();
    private ArrayList<INiagaraProxyExt> toUnsub = new ArrayList();
    private Object stoppedLock = new Object();
    private ArrayList<Integer> stopped = new ArrayList();

    ClientWorker(BNiagaraPointDeviceExt points) {
        this.points = points;
        this.station = (BNiagaraStation)points.getDevice();
        this.connection = this.station.getClientConnection();
        this.channel = (BPointChannel)this.connection.getChannels().get("point", BPointChannel.TYPE);
        this.log = this.channel.log;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object o) {
        return this == o;
    }

    public final String toString() {
        try {
            return this.station.getName() + ":Client Worker";
        }
        catch (Exception exception) {
            return this.points.toString();
        }
    }

    public void start() {
        BNiagaraNetwork net = this.station.getNiagaraNetwork();
        if (net != null) {
            net.getWorkers().register(this, 1000L);
        }
    }

    public void kill() {
        BNiagaraNetwork net = this.station.getNiagaraNetwork();
        if (net != null) {
            net.getWorkers().unregister(this);
        }
        this.connection.disengage((BFoxClientConnection.Interest)this);
    }

    @Override
    public void run() {
        try {
            this.workIt();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (EngageTimeoutException e) {
            this.log.trace("EngageTimeoutException");
        }
        catch (Throwable e) {
            this.log.error("Error workIt()", e);
        }
    }

    public void workIt() throws Exception {
        this.toSub.clear();
        this.toUnsub.clear();
        boolean needConnection = this.pick();
        if (needConnection) {
            try {
                this.connection.engageNoRetry((BFoxClientConnection.Interest)this, this.connection.getRetryPeriod().getMillis(), true);
            }
            catch (Exception e) {
                try {
                    this.connection.disengage((BFoxClientConnection.Interest)this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
        }
        this.connection.disengage((BFoxClientConnection.Interest)this);
        return;
        try {
            this.sendSub();
            this.sendUnsub();
            this.sendStopped();
        }
        catch (NotConnectedException e) {
            this.log.trace("NotConnectedException");
        }
        catch (Exception e) {
            this.log.error("Sending batches", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean pick() {
        Object object = this.points.stateLock;
        synchronized (object) {
            boolean needConnection = false;
            INiagaraProxyExt[] proxyExts = this.points.getProxyExtensions();
            for (int i = 0; i < proxyExts.length; ++i) {
                if (!this.pick(proxyExts[i])) continue;
                needConnection = true;
            }
            return needConnection;
        }
    }

    private boolean pick(INiagaraProxyExt ext) {
        BSubscriptionState subState = ext.getSubscriptionState();
        if (subState == BSubscriptionState.unsubscribed) {
            if (ext.isPointSubscribed() && !ext.isDisabled() && this.connection.isConnected()) {
                ext.pendingSubscribe();
            } else {
                return false;
            }
        }
        if (subState == BSubscriptionState.proxyError) {
            return false;
        }
        if (subState == BSubscriptionState.pendingSubscribe || subState == BSubscriptionState.sendingSubscribe) {
            this.toSub.add(ext);
        }
        if (subState == BSubscriptionState.pendingUnsubscribe || subState == BSubscriptionState.sendingUnsubscribe) {
            this.toUnsub.add(ext);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendSub() throws Exception {
        if (this.toSub.size() == 0) {
            return;
        }
        try {
            Object object = this.points.stateLock;
            synchronized (object) {
                if (!this.connection.isConnected()) {
                    throw new NotConnectedException();
                }
                for (int i = 0; i < this.toSub.size(); ++i) {
                    INiagaraProxyExt ext = this.toSub.get(i);
                    if (ext.getSubscriptionState() == BSubscriptionState.sendingSubscribe) continue;
                    ext.sendingSubscribe();
                }
            }
        }
        catch (NotConnectedException nce) {
            throw nce;
        }
        catch (Exception e) {
            Object object = this.points.stateLock;
            synchronized (object) {
                for (int i = 0; i < this.toSub.size(); ++i) {
                    this.toSub.get(i).setSubscriptionState(BSubscriptionState.unsubscribed);
                }
            }
            throw e;
        }
        try {
            this.channel.subscribe(this.toSub);
        }
        catch (Exception e) {
            Object object = this.points.stateLock;
            synchronized (object) {
                for (int i = 0; i < this.toSub.size(); ++i) {
                    this.toSub.get(i).setSubscriptionState(BSubscriptionState.unsubscribed);
                }
            }
            throw e;
        }
        Exception e = null;
        Object object = this.points.stateLock;
        synchronized (object) {
            if (!this.connection.isConnected()) {
                throw new NotConnectedException();
            }
            for (int i = 0; i < this.toSub.size(); ++i) {
                try {
                    this.toSub.get(i).sentSubscribe();
                    continue;
                }
                catch (Exception ex) {
                    e = ex;
                }
            }
        }
        if (e != null) {
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendUnsub() throws Exception {
        if (this.toUnsub.size() == 0) {
            return;
        }
        Object object = this.points.stateLock;
        synchronized (object) {
            if (!this.connection.isConnected()) {
                throw new NotConnectedException();
            }
            for (int i = 0; i < this.toUnsub.size(); ++i) {
                INiagaraProxyExt ext = this.toUnsub.get(i);
                if (ext.getSubscriptionState() == BSubscriptionState.sendingUnsubscribe) continue;
                ext.sendingUnsubscribe();
            }
        }
        this.channel.unsubscribe(this.toUnsub);
        Exception e = null;
        Object object2 = this.points.stateLock;
        synchronized (object2) {
            if (!this.connection.isConnected()) {
                throw new NotConnectedException();
            }
            for (int i = 0; i < this.toUnsub.size(); ++i) {
                try {
                    this.toUnsub.get(i).sentUnsubscribe();
                    continue;
                }
                catch (Exception ex) {
                    e = ex;
                }
            }
        }
        if (e != null) {
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendStopped() throws Exception {
        ArrayList<Integer> copy;
        if (this.stopped.size() == 0) {
            return;
        }
        Object object = this.stoppedLock;
        synchronized (object) {
            copy = this.stopped;
            this.stopped = new ArrayList();
        }
        this.channel.unsubscribe(copy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopped(INiagaraProxyExt ext) {
        if (ext.getSubscriptionState() != BSubscriptionState.unsubscribed) {
            Object object = this.stoppedLock;
            synchronized (object) {
                this.stopped.add(new Integer(ext.getMessageId()));
            }
        }
    }

    public Object getCoalesceKey() {
        return this;
    }

    public ICoalesceable coalesce(ICoalesceable c) {
        return c;
    }
}

