/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.history;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.history.db.BLocalHistoryDatabase;
import com.tridium.history.fox.BHistoryChannel;
import com.tridium.nd.history.BArchiveChannel;
import com.tridium.nd.history.BNiagaraHistoryDeviceExt;
import com.tridium.nd.history.BNiagaraHistoryExport;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.BHistorySummary;
import javax.baja.history.BIHistory;
import javax.baja.history.HistoryNotFoundException;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Cursor;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BNiagaraSystemHistoryExport
extends BNiagaraHistoryExport {
    public static final Property historyId = BNiagaraSystemHistoryExport.newProperty((int)7, (BValue)BHistoryId.NULL, null);
    public static final Property systemTagPatterns = BNiagaraSystemHistoryExport.newProperty((int)0, (String)"", null);
    public static final Type TYPE = Sys.loadType(BNiagaraSystemHistoryExport.class);

    public BHistoryId getHistoryId() {
        return (BHistoryId)this.get(historyId);
    }

    public void setHistoryId(BHistoryId v) {
        this.set(historyId, (BValue)v, null);
    }

    public String getSystemTagPatterns() {
        return this.getString(systemTagPatterns);
    }

    public void setSystemTagPatterns(String v) {
        this.setString(systemTagPatterns, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doExecute() {
        this.executeInProgress();
        BNiagaraHistoryDeviceExt devicelet = (BNiagaraHistoryDeviceExt)this.getDeviceExt();
        try {
            devicelet.getClientConnection().engageNoRetry((BFoxClientConnection.Interest)this);
        }
        catch (Exception e) {
            this.executeFail(e);
            if (devicelet.getClientConnection().isEngaged((BFoxClientConnection.Interest)this)) {
                devicelet.getClientConnection().disengage((BFoxClientConnection.Interest)this);
            }
            return;
        }
        try {
            String list = this.getSystemTagPatterns();
            if (list == null || list.length() < 1) {
                this.executeFail("System Tag Patterns is null.");
                return;
            }
            BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
            BHistoryDatabase db = service.getDatabase();
            if (!(db instanceof BLocalHistoryDatabase)) {
                this.executeFail("Local history database not available.");
                return;
            }
            BHistoryConfig[] matchingConfigs = ((BLocalHistoryDatabase)db).getConfigs(list);
            if (matchingConfigs == null || matchingConfigs.length < 1) {
                this.executeFail("No matching histories found for System Tag Patterns provided.");
                return;
            }
            BArchiveChannel archiveChannel = devicelet.getClientArchiveChannel();
            BHistoryChannel historyChannel = devicelet.getClientHistoryChannel();
            int len = matchingConfigs.length;
            try (HistoryDatabaseConnection conn = db.getDbConnection(null);){
                for (int i = 0; i < len; ++i) {
                    BHistoryId id = matchingConfigs[i].getId();
                    BIHistory history = conn.getHistory(id);
                    if (history == null) {
                        throw new HistoryNotFoundException();
                    }
                    BHistorySummary summary = historyChannel.getSummary(id);
                    if (summary == null) {
                        archiveChannel.createHistory(history.getConfig());
                    } else {
                        archiveChannel.updateConfig(history.getConfig());
                    }
                    Object startTime = null;
                    if (summary != null) {
                        startTime = summary.getLastTimestamp();
                        startTime = startTime.isNull() ? null : startTime.add(BRelTime.make((long)1L));
                    }
                    historyChannel.append(id, (Cursor)conn.timeQuery(history, startTime, null).cursor());
                }
            }
            this.executeOk();
        }
        catch (Exception e) {
            this.executeFail(e);
            return;
        }
        finally {
            devicelet.getClientConnection().disengage((BFoxClientConnection.Interest)this);
        }
    }
}

