/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.file;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.file.BFileChannel;
import com.tridium.fox.sys.file.BFoxFileSpace;
import com.tridium.nd.file.BFileOverwritePolicy;
import com.tridium.nd.file.BNiagaraFileDeviceExt;
import com.tridium.nd.file.BNiagaraFileTypeImportHandler;
import com.tridium.nd.util.BSimpleMap;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.driver.util.BDescriptor;
import javax.baja.file.BAbstractFile;
import javax.baja.file.BFileScheme;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.BajaFileUtil;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BMonth;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Version;

public abstract class BNiagaraFileDescriptor
extends BDescriptor
implements BFoxClientConnection.Interest {
    public static final Property files = BNiagaraFileDescriptor.newProperty((int)0, (BValue)BSimpleMap.NULL, (BFacets)BFacets.make((String)"fieldEditor", (String)"niagaraDriver:FileOrdsFE"));
    public static final Property fileOverwritePolicy = BNiagaraFileDescriptor.newProperty((int)0, (BValue)BFileOverwritePolicy.checksum, null);
    public static final Type TYPE = Sys.loadType(BNiagaraFileDescriptor.class);
    private final Object syncObj = new Object();
    private boolean executeInProgress = false;
    static final Logger LOG = Logger.getLogger("niagara.file");
    private BRelTime lastExecutionTime = BRelTime.DEFAULT;
    private BRelTime longestExecutionTime = BRelTime.DEFAULT;
    private BRelTime shortestExecutionTime = BRelTime.DEFAULT;
    private long totalSuccessfulExecutions = 0L;
    private long totalFailedExecutions = 0L;
    private static final Version checksumVersionStart = new Version("3.5");
    protected static final ThreadLocal<Boolean> FORCE_EXECUTE = new ThreadLocal();

    public BSimpleMap getFiles() {
        return (BSimpleMap)this.get(files);
    }

    public void setFiles(BSimpleMap v) {
        this.set(files, (BValue)v, null);
    }

    public BFileOverwritePolicy getFileOverwritePolicy() {
        return (BFileOverwritePolicy)this.get(fileOverwritePolicy);
    }

    public void setFileOverwritePolicy(BFileOverwritePolicy v) {
        this.set(fileOverwritePolicy, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BNiagaraFileDeviceExt;
    }

    protected IFuture postExecute(Action action, BValue arg, Context cx) {
        BNiagaraFileDeviceExt deviceExt = (BNiagaraFileDeviceExt)this.getParent();
        deviceExt.getNiagaraNetwork().getWorkers().process(new Invocation((BComponent)this, action, arg, cx));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doExecute() {
        BNiagaraFileDeviceExt devicelet = (BNiagaraFileDeviceExt)this.getDeviceExt();
        try {
            Object object = this.syncObj;
            synchronized (object) {
                while (this.executeInProgress) {
                    try {
                        this.syncObj.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                this.executeInProgress = true;
            }
            this.executeInProgress();
            devicelet.getClientConnection().engageNoRetry((BFoxClientConnection.Interest)this);
            if (this.getFileOverwritePolicy() == BFileOverwritePolicy.checksum && devicelet.getClientConnection().getRemoteVersion().compareTo(checksumVersionStart) < 0) {
                throw new Exception("Checksum File Overwrite Policy only supported from version 3.5 onwards");
            }
            Object remoteSpace = new BFoxFileSpace((BFileChannel)devicelet.getClientConnection().getChannels().get("file", BFileChannel.TYPE));
            if (this.getFiles().isNull()) {
                ++this.totalFailedExecutions;
                this.executeFail("No files to process!");
                return;
            }
            long t1 = Clock.ticks();
            this.doFileExecute((BFileSpace)remoteSpace);
            this.executeOk();
            this.lastExecutionTime = BRelTime.make((long)(Clock.ticks() - t1));
            if (this.lastExecutionTime.getMillis() > this.longestExecutionTime.getMillis()) {
                this.longestExecutionTime = this.lastExecutionTime;
            }
            if (this.lastExecutionTime.getMillis() < this.shortestExecutionTime.getMillis()) {
                this.shortestExecutionTime = this.lastExecutionTime;
            }
            ++this.totalSuccessfulExecutions;
        }
        catch (Throwable e) {
            ++this.totalFailedExecutions;
            this.executeFail(e);
            LOG.log(Level.SEVERE, "Failed to execute Niagara File Descriptor at " + this.toPathString(), e);
        }
        finally {
            try {
                if (devicelet.getClientConnection().isEngaged((BFoxClientConnection.Interest)this)) {
                    devicelet.getClientConnection().disengage((BFoxClientConnection.Interest)this);
                }
            }
            catch (Exception e) {}
            Object e = this.syncObj;
            synchronized (e) {
                this.executeInProgress = false;
                this.syncObj.notify();
            }
        }
    }

    public void forceFullExecute() {
        FORCE_EXECUTE.set(Boolean.TRUE);
        try {
            this.doExecute();
        }
        finally {
            FORCE_EXECUTE.remove();
        }
    }

    protected abstract void doFileExecute(BFileSpace var1) throws IOException;

    protected void createAllFiles(BFileSpace sourceSpace, BOrd sourceFileOrd, BFileSpace targetSpace, BOrd targetFileOrd) throws IOException {
        FilePath sourceFilePath = this.getFilePath(sourceFileOrd);
        BIFile sourceFile = sourceSpace.findFile(sourceFilePath);
        FilePath targetFilePath = this.getFilePath(targetFileOrd);
        BIFile targetFile = targetSpace.findFile(targetFilePath);
        if (sourceFile == null) {
            throw new IOException("Could not find " + BNiagaraFileDescriptor.toSpaceText(sourceSpace) + " File: " + sourceFileOrd);
        }
        if (sourceFile.isDirectory()) {
            if (targetFile != null && !targetFile.isDirectory()) {
                throw new IOException(BNiagaraFileDescriptor.toSpaceText(targetSpace) + " File is not a Directory: " + targetFilePath);
            }
            if (targetFile == null) {
                targetSpace.makeDir(targetFilePath);
            }
            for (BIFile sourceFileKid : ((BIDirectory)sourceFile).listFiles()) {
                FilePath newFilePath = targetFilePath.merge(sourceFileKid.getFileName());
                if (sourceFileKid.isDirectory()) {
                    targetSpace.makeDir(newFilePath);
                }
                this.createAllFiles(sourceSpace, BOrd.make((OrdQuery)sourceFileKid.getFilePath()), targetSpace, BOrd.make((OrdQuery)newFilePath));
            }
        } else {
            if (targetFile != null && targetFile.isDirectory()) {
                throw new IOException(BNiagaraFileDescriptor.toSpaceText(targetSpace) + " File is a Directory!");
            }
            this.createFile(sourceSpace, sourceFileOrd, targetSpace, targetFileOrd);
        }
    }

    private void createFile(BFileSpace sourceSpace, BOrd sourceFileOrd, BFileSpace targetSpace, BOrd targetFileOrd) throws IOException {
        boolean canUseChecksum;
        FilePath sourceFilePath = this.getFilePath(sourceFileOrd);
        BIFile sourceFile = sourceSpace.findFile(sourceFilePath);
        if (sourceFile == null) {
            throw new IOException("Could not find " + BNiagaraFileDescriptor.toSpaceText(sourceSpace) + " File: " + sourceFilePath);
        }
        FilePath targetFilePath = this.getFilePath(targetFileOrd);
        BIFile targetFile = targetSpace.findFile(targetFilePath);
        BNiagaraFileTypeImportHandler handler = BNiagaraFileTypeImportHandler.findImportHandlerForFileExt(sourceFile.getExtension());
        if (targetFile == null || FORCE_EXECUTE.get() == Boolean.TRUE) {
            if (LOG.isLoggable(Level.FINE)) {
                String prefix = targetFile == null ? "Creating file from " : "Force reimport file from ";
                LOG.fine(prefix + BNiagaraFileDescriptor.toSpaceText(sourceSpace) + ": " + sourceFilePath);
            }
            this.createFile(targetSpace, targetFilePath, sourceFile, handler);
            return;
        }
        boolean canUseLastModified = handler == null || handler.isAcceptableOverwritePolicy(BFileOverwritePolicy.lastModified);
        boolean bl = canUseChecksum = handler == null || handler.isAcceptableOverwritePolicy(BFileOverwritePolicy.checksum);
        if (canUseLastModified && (this.getFileOverwritePolicy() == BFileOverwritePolicy.lastModified || !canUseChecksum)) {
            BAbsTime targetFileModified;
            BAbsTime sourceFileModified = this.toNearestSecond(sourceFile.getLastModified());
            if (sourceFileModified.isAfter(targetFileModified = this.toNearestSecond(targetFile.getLastModified()))) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("File lastModified different. Creating/overwriting file from " + BNiagaraFileDescriptor.toSpaceText(sourceSpace) + ": " + sourceFilePath);
                }
                this.createFile(targetSpace, targetFilePath, sourceFile, handler);
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("File dates are the same - ignoring: " + sourceFilePath);
            }
        } else if (this.getFileOverwritePolicy() == BFileOverwritePolicy.checksum && targetFile instanceof BAbstractFile && sourceFile instanceof BAbstractFile && canUseChecksum) {
            long sourceCrc = ((BAbstractFile)sourceFile).getCrc();
            long targetCrc = ((BAbstractFile)targetFile).getCrc();
            if (sourceCrc == -1L) {
                throw new IOException("Failed to get CRC from file: " + sourceFile.getFilePath());
            }
            if (targetCrc == -1L) {
                throw new IOException("Failed to get CRC from file: " + targetFile.getFilePath());
            }
            if (sourceCrc != targetCrc) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine(String.format("File checksum is different. Creating/overwriting file from %s: %s (%s) (%s)", BNiagaraFileDescriptor.toSpaceText(sourceSpace), sourceFilePath, sourceCrc, targetCrc));
                }
                this.createFile(targetSpace, targetFilePath, sourceFile, handler);
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("File checksums are the same - ignoring: " + sourceFilePath);
            }
        } else {
            throw new IOException("Failed to create " + BNiagaraFileDescriptor.toSpaceText(sourceSpace) + " file: " + targetFileOrd);
        }
    }

    private void createFile(BFileSpace fileSpace, FilePath filePath, BIFile file, BNiagaraFileTypeImportHandler handler) throws IOException {
        fileSpace.delete(filePath);
        BIFile newFile = fileSpace.makeFile(filePath, null);
        if (handler != null) {
            handler.pipeFileData(this, file, newFile);
        } else {
            BajaFileUtil.pipe((BIFile)file, (BIFile)newFile);
        }
        if (newFile instanceof BAbstractFile && !((BAbstractFile)newFile).setLastModified(file.getLastModified())) {
            throw new IOException("Could not set lastModified on " + BNiagaraFileDescriptor.toSpaceText(fileSpace) + "file: " + filePath);
        }
    }

    private FilePath getFilePath(BOrd ord) throws IOException {
        for (OrdQuery query : ord.parse()) {
            if (!query.getScheme().equals(BFileScheme.INSTANCE.getId())) continue;
            return new FilePath(query.getBody());
        }
        throw new IOException("Could not find File Scheme in ORD: " + ord);
    }

    private BAbsTime toNearestSecond(BAbsTime absTime) {
        return BAbsTime.make((int)absTime.getYear(), (BMonth)absTime.getMonth(), (int)absTime.getDay(), (int)absTime.getHour(), (int)absTime.getMinute(), (int)absTime.getSecond(), (int)0, (BTimeZone)absTime.getTimeZone());
    }

    private static String toSpaceText(BFileSpace fileSpace) {
        return fileSpace instanceof BFoxFileSpace ? "Remote" : "Local";
    }

    public void spy(SpyWriter out) throws Exception {
        out.startProps("Niagara File Descriptor");
        out.prop((Object)"Last Execution Time", (Object)this.lastExecutionTime);
        out.prop((Object)"Longest Execution Time", (Object)this.longestExecutionTime);
        out.prop((Object)"Shortest Execution Time", (Object)this.shortestExecutionTime);
        out.prop((Object)"Total Successful Executions", (Object)String.valueOf(this.totalSuccessfulExecutions));
        out.prop((Object)"Total Failed Executions", (Object)String.valueOf(this.totalFailedExecutions));
        out.endProps();
        super.spy(out);
    }
}

