/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.alarm;

import com.tridium.alarm.AlarmClassRouteAlarmInvocation;
import com.tridium.alarm.BTextOp;
import com.tridium.alarm.fox.FoxAlarmCodec;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.message.FoxTuple;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.IncompatibleVersionException;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.alarm.AlarmWorker;
import com.tridium.nd.alarm.BNiagaraAlarmDeviceExt;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.IFuture;
import javax.baja.util.Queue;

public class BAlarmChannel
extends BFoxChannel {
    public static final Action alarmAck = BAlarmChannel.newAction((int)4, (BValue)new BAlarmRecord(), null);
    public static final Action alarmUpdate = BAlarmChannel.newAction((int)4, (BValue)new BAlarmRecord(), null);
    public static final Type TYPE = Sys.loadType(BAlarmChannel.class);
    BUser lastUser;
    public static final Logger logger = Logger.getLogger("niagara.alarms");

    public void alarmAck(BAlarmRecord alarm) {
        this.invoke(alarmAck, (BValue)alarm, null);
    }

    public void alarmUpdate(BAlarmRecord alarm) {
        this.invoke(alarmUpdate, (BValue)alarm, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BAlarmChannel() {
        super("alarm");
    }

    public void checkProcess(FoxRequest req) throws Throwable {
    }

    public void checkSendRequest(FoxRequest req) throws Exception {
        if (this.getConnection().session().isLegacyConnection() && req.command == "new") {
            throw new IncompatibleVersionException("Niagara4 station cannot send alarms to a NiagaraAX station");
        }
        super.checkSendRequest(req);
    }

    public FoxResponse process(FoxRequest request) throws Exception {
        String command = request.command;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("AlarmChannel.command = " + command);
        }
        try {
            if (command == "new") {
                return this.newAlarms(request);
            }
            if (command == "ack") {
                return this.ackAlarms(request);
            }
            if (command == "update") {
                return this.updateAlarms(request);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        throw new InvalidCommandException(command);
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        if (action == alarmAck) {
            Queue q = (Queue)Sys.getService((Type)BAlarmService.TYPE).fw(601);
            q.enqueue((Object)AlarmClassRouteAlarmInvocation.make((BComponent)this, (Action)action, (BAlarmRecord)((BAlarmRecord)argument), (Context)cx));
            return null;
        }
        return super.post(action, argument, cx);
    }

    private FoxResponse newAlarms(FoxRequest request) throws Exception {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("received: new");
        }
        BUser user = this.getSessionContext().getUser();
        FoxResponse resp = new FoxResponse(request);
        BAlarmService as = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        BNiagaraAlarmDeviceExt devicelet = this.getDeviceExt();
        devicelet.setLastReceivedTime(BAbsTime.make());
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("checking required permissions");
        }
        try {
            user.check((BIProtected)as, BPermissions.adminWrite);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("AlarmChannel: " + user + " has valid permissions");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        FoxTuple[] msgs = request.list("alarm");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("received " + msgs.length + " alarms");
        }
        Array futuresArray = new Array(AlarmClassRouteAlarmInvocation.class);
        for (int i = 0; i < msgs.length; ++i) {
            String newName;
            BString sourceName;
            BAlarmRecord alarm = FoxAlarmCodec.decodeAlarm((FoxMessage)((FoxMessage)msgs[i]));
            BAlarmChannel.modifyAlarmClass(alarm, devicelet);
            BOrdList src = alarm.getSource();
            BOrdList newSrc = BOrdList.add((BOrdList)src, (BOrd)BOrd.make((OrdQuery)devicelet.getSlotPath()));
            alarm.setSource(newSrc);
            if (logger.isLoggable(Level.FINE)) {
                this.trace("BAlarmChannel: new -> routeAlarm " + alarm.getTimestamp() + " " + alarm.getSource().encodeToString());
            }
            if ((sourceName = (BString)alarm.getAlarmData().get("sourceName")) != null) {
                newName = this.getDeviceExt().getSourceName().customize(sourceName.toString());
                alarm.setAlarmData(BFacets.make((BFacets)alarm.getAlarmData(), (String)"sourceName", (BIDataValue)BString.make((String)newName)));
            } else if (this.getDeviceExt().getSourceName().getOp() == BTextOp.replace) {
                newName = this.getDeviceExt().getSourceName().customize("");
                alarm.setAlarmData(BFacets.make((BFacets)alarm.getAlarmData(), (String)"sourceName", (BIDataValue)BString.make((String)newName)));
            }
            BObject hyperlink = alarm.getAlarmData().get("hyperlinkOrd");
            if (hyperlink != null) {
                BNiagaraStation station = (BNiagaraStation)this.getDeviceExt().getParent();
                String prependString = AlarmWorker.makeStationSessionOrdSegment(station);
                BString hyperlinkString = (BString)hyperlink;
                if (!hyperlink.toString().startsWith(prependString)) {
                    hyperlinkString = BString.make((String)(prependString + hyperlink.toString()));
                }
                alarm.setAlarmData(BFacets.make((BFacets)alarm.getAlarmData(), (String)"hyperlinkOrd", (BIDataValue)hyperlinkString));
            }
            BAlarmClass alarmClassObj = as.lookupAlarmClass(alarm.getAlarmClass());
            AlarmClassRouteAlarmInvocation future = (AlarmClassRouteAlarmInvocation)alarmClassObj.post(BAlarmClass.routeAlarm, (BValue)alarm, null);
            futuresArray.add((Object)future);
        }
        AlarmClassRouteAlarmInvocation[] futures = (AlarmClassRouteAlarmInvocation[])futuresArray.trim();
        boolean dbWritesFinished = false;
        while (!dbWritesFinished) {
            dbWritesFinished = true;
            for (int i = 0; i < futures.length; ++i) {
                if (futures[i].isFinished()) continue;
                dbWritesFinished = false;
            }
            Thread.sleep(10L);
        }
        boolean dbWriteFailed = false;
        Exception dbWriteException = null;
        for (int i = 0; i < futures.length; ++i) {
            dbWriteException = futures[i].getException();
            if (dbWriteException == null) continue;
            dbWriteFailed = true;
        }
        if (request.getBoolean("dbWriteSuccessEnabled", false)) {
            resp.add("dbWriteSuccess", !dbWriteFailed);
            if (dbWriteFailed) {
                resp.add("failureCause", dbWriteException.getMessage());
            }
        }
        return resp;
    }

    private static void modifyAlarmClass(BAlarmRecord alarm, BNiagaraAlarmDeviceExt devicelet) {
        String alarmClass = devicelet.getAlarmClass();
        if (alarmClass == null || alarmClass.equals("")) {
            return;
        }
        alarm.setAlarmClass(SlotPath.escape((String)TextUtil.replace((String)SlotPath.unescape((String)alarmClass), (String)"%alarmClass%", (String)SlotPath.unescape((String)alarm.getAlarmClass()))));
    }

    public void newAlarms(BAlarmRecord[] alarms) throws Exception {
        FoxRequest msg = this.makeRequest("new");
        msg.add("dbWriteSuccessEnabled", true);
        BAbsTime lastTime = BAbsTime.NULL;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("sending " + alarms.length + " alarms");
        }
        for (int i = 0; i < alarms.length; ++i) {
            msg.add("alarm", FoxAlarmCodec.encodeAlarm((BAlarmRecord)alarms[i]));
            if (!alarms[i].getLastUpdate().isAfter(lastTime)) continue;
            lastTime = alarms[i].getLastUpdate();
        }
        try {
            FoxResponse resp = this.sendSync(msg);
            if (!resp.getBoolean("dbWriteSuccess", true)) {
                throw new Exception(resp.getString("failureCause", "Remote Alarm Database Failure"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getDeviceExt().setLastSendFailureTime(BAbsTime.make());
            this.getDeviceExt().setLastSendFailureCause(e.toString());
            throw e;
        }
        this.getDeviceExt().setLastSendTime(lastTime);
    }

    public void ackAlarms(BAlarmRecord[] alarms) throws Exception {
        FoxRequest msg = this.makeRequest("ack");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("sending " + alarms.length + " alarm acks");
        }
        BAbsTime lastTime = BAbsTime.NULL;
        for (int i = 0; i < alarms.length; ++i) {
            msg.add("alarm", FoxAlarmCodec.encodeAlarm((BAlarmRecord)alarms[i]));
            if (!alarms[i].getLastUpdate().isAfter(lastTime)) continue;
            lastTime = alarms[i].getLastUpdate();
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("sending: ack");
        }
        try {
            this.sendAsync(msg);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getDeviceExt().setLastSendFailureTime(BAbsTime.make());
            this.getDeviceExt().setLastSendFailureCause(e.toString());
            throw e;
        }
        this.getDeviceExt().setLastSendTime(lastTime);
    }

    private FoxResponse ackAlarms(FoxRequest request) throws Exception {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("received: ack");
        }
        BUser user = this.getSessionContext().getUser();
        FoxResponse resp = new FoxResponse(request);
        BAlarmService as = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        BNiagaraAlarmDeviceExt devicelet = this.getDeviceExt();
        devicelet.setLastReceivedTime(BAbsTime.make());
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("checking required permissions");
        }
        try {
            user.check((BIProtected)as, BPermissions.adminWrite);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("AlarmChannel: " + user + " has valid permissions");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        FoxTuple[] msgs = request.list("alarm");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("received " + msgs.length + " alarm acks");
        }
        for (int i = 0; i < msgs.length; ++i) {
            BAlarmRecord alarm = FoxAlarmCodec.decodeAlarm((FoxMessage)((FoxMessage)msgs[i]));
            if (logger.isLoggable(Level.FINE)) {
                this.trace("BAlarmChannel: ack -> routeAlarm: " + alarm.getTimestamp() + " ");
            }
            this.alarmAck(alarm);
        }
        return resp;
    }

    public void doAlarmAck(BAlarmRecord alarm) throws Exception {
        BAlarmRecord dbRec;
        BAlarmService as;
        block21: {
            as = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            dbRec = null;
            try (AlarmDbConnection conn = as.getAlarmDb().getDbConnection(null);){
                dbRec = conn.getRecord(alarm.getUuid());
                if (dbRec == null) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("add new alarm");
                    }
                    alarm.setLastUpdate(BAbsTime.now());
                    conn.append(alarm);
                    break block21;
                }
                if (dbRec.getAckState() != BAckState.acked) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("update alarm ackState = " + alarm.getAckState());
                    }
                    alarm.setLastUpdate(BAbsTime.now());
                    BObject sourceName = dbRec.getAlarmData().get("sourceName");
                    if (sourceName != null) {
                        alarm.setAlarmData(BFacets.make((BFacets)alarm.getAlarmData(), (String)"sourceName", (BIDataValue)((BIDataValue)sourceName)));
                    }
                    conn.update(alarm);
                    break block21;
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("already have ack for " + alarm.getUuid() + " notifying sender...");
                }
                this.getDeviceExt().doRouteAlarm(dbRec);
                return;
            }
        }
        if (dbRec != null) {
            alarm.setAlarmClass(dbRec.getAlarmClass());
        }
        as.ackAlarm(alarm);
    }

    public void updateAlarms(BAlarmRecord[] alarms) throws Exception {
        FoxRequest msg = this.makeRequest("update");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("sending " + alarms.length + " alarm updates");
        }
        BAbsTime lastTime = BAbsTime.NULL;
        for (int i = 0; i < alarms.length; ++i) {
            msg.add("alarm", FoxAlarmCodec.encodeAlarm((BAlarmRecord)alarms[i]));
            if (!alarms[i].getLastUpdate().isAfter(lastTime)) continue;
            lastTime = alarms[i].getLastUpdate();
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("sending: update");
        }
        try {
            this.sendAsync(msg);
        }
        catch (InvalidCommandException i) {
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getDeviceExt().setLastSendFailureTime(BAbsTime.make());
            this.getDeviceExt().setLastSendFailureCause(e.toString());
            throw e;
        }
        this.getDeviceExt().setLastSendTime(lastTime);
    }

    private FoxResponse updateAlarms(FoxRequest request) throws Exception {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("received: update");
        }
        BUser user = this.getSessionContext().getUser();
        FoxResponse resp = new FoxResponse(request);
        BAlarmService as = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        BNiagaraAlarmDeviceExt devicelet = this.getDeviceExt();
        devicelet.setLastReceivedTime(BAbsTime.make());
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("checking required permissions");
        }
        try {
            user.check((BIProtected)as, BPermissions.operatorWrite);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("AlarmChannel: " + user + " has valid permissions");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        FoxTuple[] msgs = request.list("alarm");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("received " + msgs.length + " alarm updates");
        }
        for (int i = 0; i < msgs.length; ++i) {
            BAlarmRecord alarm = FoxAlarmCodec.decodeAlarm((FoxMessage)((FoxMessage)msgs[i]));
            if (logger.isLoggable(Level.FINE)) {
                this.trace("BAlarmChannel: update -> routeToSource: " + alarm.getTimestamp() + " ");
            }
            this.alarmUpdate(alarm);
        }
        return resp;
    }

    public void doAlarmUpdate(BAlarmRecord alarm) throws Exception {
        BAlarmService as = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        boolean isUseful = true;
        BAlarmRecord dbRec = null;
        try (AlarmDbConnection conn = as.getAlarmDb().getDbConnection(null);){
            dbRec = conn.getRecord(alarm.getUuid());
            if (dbRec == null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("add updated alarm");
                }
                alarm.setLastUpdate(BAbsTime.now());
                conn.append(alarm);
                dbRec = alarm;
            } else {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("update updated alarm");
                }
                if (alarm.getAlarmData().get("notes") != null && !alarm.getAlarmData().get("notes").equals((Object)dbRec.getAlarmData().get("notes"))) {
                    dbRec.setAlarmData(BFacets.make((BFacets)dbRec.getAlarmData(), (String)"notes", (BIDataValue)((BIDataValue)alarm.getAlarmData().get("notes"))));
                    dbRec.setLastUpdate(BAbsTime.now());
                    conn.update(dbRec);
                } else {
                    isUseful = false;
                }
            }
        }
        if (isUseful) {
            as.doRouteToSource(dbRec);
            as.doRouteAlarm(dbRec);
        }
    }

    public final BNiagaraAlarmDeviceExt getDeviceExt() {
        try {
            return ((BNiagaraStation)this.getConnection().getConnectionTarget(BNiagaraStation.class).orElseThrow(NullPointerException::new)).getAlarms();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

