/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd;

import com.tridium.fox.session.FoxServer;
import com.tridium.fox.session.MulticastServer;
import com.tridium.fox.sys.BFoxService;
import com.tridium.fox.sys.BLearnStation;
import com.tridium.fox.sys.Learn;
import com.tridium.nd.BNiagaraNetwork;
import javax.baja.job.BSimpleJob;
import javax.baja.naming.BOrd;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BStationDiscoveryJob
extends BSimpleJob
implements MulticastServer.RollcallCallback {
    public static final Type TYPE = Sys.loadType(BStationDiscoveryJob.class);
    public static BIcon icon = BIcon.std((String)"find.png");
    BNiagaraNetwork network;

    public Type getType() {
        return TYPE;
    }

    public BStationDiscoveryJob(BNiagaraNetwork network) {
        this.network = network;
    }

    public BStationDiscoveryJob() {
    }

    public void run(Context cx) throws Exception {
        if (this.network == null) {
            throw new IllegalStateException("Must submit through NiagaraNetwork.submitStationDiscoveryJob()");
        }
        this.log().start("Station discovery");
        this.removeAll();
        String myName = Sys.getStation().getStationName();
        BFoxService foxService = (BFoxService)BOrd.make((String)"service:fox:FoxService").get((BObject)this.network);
        FoxServer foxServer = foxService.getFoxServer();
        BLearnStation[] stations = Learn.learn((MulticastServer)foxServer.getMulticastServer(), (long)5000L, (MulticastServer.RollcallCallback)this);
        for (int i = 0; i < stations.length; ++i) {
            BLearnStation s = stations[i];
            if (s.getStationName().equalsIgnoreCase(myName)) {
                this.log().success("Myself: " + s);
                continue;
            }
            this.log().success("Found: " + s);
            this.add("s" + i, (BValue)s, 1);
        }
        this.log().success("Discovered " + stations.length + " stations");
    }

    public void completed(int percent) {
        this.progress(percent);
    }

    public BIcon getIcon() {
        return icon;
    }
}

