/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd;

import com.tridium.authn.AuthenticationClient;
import com.tridium.crypto.core.io.CoreCryptoManager;
import com.tridium.crypto.core.io.ExemptionStoreUtil;
import com.tridium.crypto.core.io.ICoreExemptionStore;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxServerConnection;
import com.tridium.fox.sys.BFoxService;
import com.tridium.fox.sys.FoxConnectionTarget;
import com.tridium.fox.sys.NiagaraStation;
import com.tridium.nd.BINiagaraDeviceExt;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BStationWorker;
import com.tridium.nd.TransientExemptionApprover;
import com.tridium.nd.alarm.BNiagaraAlarmDeviceExt;
import com.tridium.nd.file.BNiagaraFileDeviceExt;
import com.tridium.nd.history.BNiagaraHistoryDeviceExt;
import com.tridium.nd.point.BForceUpdateNiagaraPointsJob;
import com.tridium.nd.point.BINiagaraPointContainer;
import com.tridium.nd.point.BNiagaraPointDeviceExt;
import com.tridium.nd.point.BNiagaraProxyExt;
import com.tridium.nd.point.BPointChannel;
import com.tridium.nd.schedule.BNiagaraScheduleDeviceExt;
import com.tridium.nd.sysdef.BNiagaraSysDefDeviceExt;
import com.tridium.nd.user.BNiagaraUserDeviceExt;
import com.tridium.nd.virtual.BNiagaraVirtualDeviceExt;
import com.tridium.nd.virtual.DefaultNiagaraVirtualStationAdapter;
import com.tridium.nd.virtual.FoxNiagaraVirtualCommsAdapter;
import com.tridium.nre.security.ISecurityInfoProvider;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.sys.Nre;
import java.security.AccessController;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.history.BIPollableHistorySource;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrd;
import javax.baja.nd.BINiagaraStation;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.security.ClientTlsParameters;
import javax.baja.nre.security.ExemptionApprover;
import javax.baja.nre.security.ExemptionHandler;
import javax.baja.nre.util.Array;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="address", type="BOrd", defaultValue="BOrd.NULL", facets={@Facet(value="BFacets.make(BFacets.ORD_RELATIVIZE, BBoolean.FALSE,\n                                   \"mruAutoSave\", BBoolean.FALSE,\n                                   BFacets.FIELD_EDITOR, BString.make(\"workbench:HostOrdFE\"))")}), @NiagaraProperty(name="clientConnection", type="BFoxClientConnection", defaultValue="new BFoxClientConnection()"), @NiagaraProperty(name="serverConnectionOrd", type="BOrd", defaultValue="BOrd.NULL", flags=3), @NiagaraProperty(name="hostModel", type="String", defaultValue="", flags=1), @NiagaraProperty(name="hostModelVersion", type="String", defaultValue="", flags=1), @NiagaraProperty(name="version", type="String", defaultValue="", flags=1), @NiagaraProperty(name="worker", type="BStationWorker", defaultValue="new BStationWorker()", flags=4), @NiagaraProperty(name="points", type="BNiagaraPointDeviceExt", defaultValue="new BNiagaraPointDeviceExt()"), @NiagaraProperty(name="histories", type="BNiagaraHistoryDeviceExt", defaultValue="new BNiagaraHistoryDeviceExt()"), @NiagaraProperty(name="alarms", type="BNiagaraAlarmDeviceExt", defaultValue="new BNiagaraAlarmDeviceExt()"), @NiagaraProperty(name="schedules", type="BNiagaraScheduleDeviceExt", defaultValue="new BNiagaraScheduleDeviceExt()"), @NiagaraProperty(name="users", type="BNiagaraUserDeviceExt", defaultValue="new BNiagaraUserDeviceExt()"), @NiagaraProperty(name="sysDef", type="BNiagaraSysDefDeviceExt", defaultValue="new BNiagaraSysDefDeviceExt()"), @NiagaraProperty(name="virtual", type="BNiagaraVirtualDeviceExt", defaultValue="new BNiagaraVirtualDeviceExt()"), @NiagaraProperty(name="virtualsEnabled", type="boolean", defaultValue="false"), @NiagaraProperty(name="files", type="BNiagaraFileDeviceExt", defaultValue="new BNiagaraFileDeviceExt()")})
@NiagaraAction(name="forceUpdateNiagaraProxyPoints", flags=128, returnType="BOrd")
public class BNiagaraStation
extends BDevice
implements NiagaraStation,
BINiagaraStation,
BIPollableHistorySource,
BINiagaraPointContainer {
    public static final Property address = BNiagaraStation.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"ordRelativize", (BIDataValue)BBoolean.FALSE, (String)"mruAutoSave", (BIDataValue)BBoolean.FALSE, (String)"fieldEditor", (BIDataValue)BString.make((String)"workbench:HostOrdFE")));
    public static final Property clientConnection = BNiagaraStation.newProperty((int)0, (BValue)new BFoxClientConnection(), null);
    public static final Property serverConnectionOrd = BNiagaraStation.newProperty((int)3, (BValue)BOrd.NULL, null);
    public static final Property hostModel = BNiagaraStation.newProperty((int)1, (String)"", null);
    public static final Property hostModelVersion = BNiagaraStation.newProperty((int)1, (String)"", null);
    public static final Property version = BNiagaraStation.newProperty((int)1, (String)"", null);
    public static final Property worker = BNiagaraStation.newProperty((int)4, (BValue)new BStationWorker(), null);
    public static final Property points = BNiagaraStation.newProperty((int)0, (BValue)new BNiagaraPointDeviceExt(), null);
    public static final Property histories = BNiagaraStation.newProperty((int)0, (BValue)new BNiagaraHistoryDeviceExt(), null);
    public static final Property alarms = BNiagaraStation.newProperty((int)0, (BValue)new BNiagaraAlarmDeviceExt(), null);
    public static final Property schedules = BNiagaraStation.newProperty((int)0, (BValue)new BNiagaraScheduleDeviceExt(), null);
    public static final Property users = BNiagaraStation.newProperty((int)0, (BValue)new BNiagaraUserDeviceExt(), null);
    public static final Property sysDef = BNiagaraStation.newProperty((int)0, (BValue)new BNiagaraSysDefDeviceExt(), null);
    public static final Property virtual = BNiagaraStation.newProperty((int)0, (BValue)new BNiagaraVirtualDeviceExt(), null);
    public static final Property virtualsEnabled = BNiagaraStation.newProperty((int)0, (boolean)false, null);
    public static final Property files = BNiagaraStation.newProperty((int)0, (BValue)new BNiagaraFileDeviceExt(), null);
    public static final Action forceUpdateNiagaraProxyPoints = BNiagaraStation.newAction((int)128, null);
    public static final Type TYPE = Sys.loadType(BNiagaraStation.class);
    final BFoxClientConnection.Interest pingInterest = new PingInterest();
    private static final String BOOTSTRAP_PROPERTY = "bootstrap";
    private static final Lexicon LEX = Lexicon.make((String)"niagaraDriver");
    BFoxServerConnection serverConnection = null;
    boolean pingActive;
    BINiagaraDeviceExt[] exts;
    public static final BIcon secureIcon = BIcon.make((BIcon)BIcon.std((String)"device.png"), (BIcon)BIcon.std((String)"badges/lock.png"));
    private static final Logger logger = Logger.getLogger("niagaraDriver");

    public BOrd getAddress() {
        return (BOrd)this.get(address);
    }

    public void setAddress(BOrd v) {
        this.set(address, (BValue)v, null);
    }

    public BFoxClientConnection getClientConnection() {
        return (BFoxClientConnection)this.get(clientConnection);
    }

    public void setClientConnection(BFoxClientConnection v) {
        this.set(clientConnection, (BValue)v, null);
    }

    public BOrd getServerConnectionOrd() {
        return (BOrd)this.get(serverConnectionOrd);
    }

    public void setServerConnectionOrd(BOrd v) {
        this.set(serverConnectionOrd, (BValue)v, null);
    }

    public String getHostModel() {
        return this.getString(hostModel);
    }

    public void setHostModel(String v) {
        this.setString(hostModel, v, null);
    }

    public String getHostModelVersion() {
        return this.getString(hostModelVersion);
    }

    public void setHostModelVersion(String v) {
        this.setString(hostModelVersion, v, null);
    }

    public String getVersion() {
        return this.getString(version);
    }

    public void setVersion(String v) {
        this.setString(version, v, null);
    }

    public BStationWorker getWorker() {
        return (BStationWorker)this.get(worker);
    }

    public void setWorker(BStationWorker v) {
        this.set(worker, (BValue)v, null);
    }

    public BNiagaraPointDeviceExt getPoints() {
        return (BNiagaraPointDeviceExt)this.get(points);
    }

    public void setPoints(BNiagaraPointDeviceExt v) {
        this.set(points, (BValue)v, null);
    }

    public BNiagaraHistoryDeviceExt getHistories() {
        return (BNiagaraHistoryDeviceExt)this.get(histories);
    }

    public void setHistories(BNiagaraHistoryDeviceExt v) {
        this.set(histories, (BValue)v, null);
    }

    public BNiagaraAlarmDeviceExt getAlarms() {
        return (BNiagaraAlarmDeviceExt)this.get(alarms);
    }

    public void setAlarms(BNiagaraAlarmDeviceExt v) {
        this.set(alarms, (BValue)v, null);
    }

    public BNiagaraScheduleDeviceExt getSchedules() {
        return (BNiagaraScheduleDeviceExt)this.get(schedules);
    }

    public void setSchedules(BNiagaraScheduleDeviceExt v) {
        this.set(schedules, (BValue)v, null);
    }

    public BNiagaraUserDeviceExt getUsers() {
        return (BNiagaraUserDeviceExt)this.get(users);
    }

    public void setUsers(BNiagaraUserDeviceExt v) {
        this.set(users, (BValue)v, null);
    }

    public BNiagaraSysDefDeviceExt getSysDef() {
        return (BNiagaraSysDefDeviceExt)this.get(sysDef);
    }

    public void setSysDef(BNiagaraSysDefDeviceExt v) {
        this.set(sysDef, (BValue)v, null);
    }

    public BNiagaraVirtualDeviceExt getVirtual() {
        return (BNiagaraVirtualDeviceExt)this.get(virtual);
    }

    public void setVirtual(BNiagaraVirtualDeviceExt v) {
        this.set(virtual, (BValue)v, null);
    }

    public boolean getVirtualsEnabled() {
        return this.getBoolean(virtualsEnabled);
    }

    public void setVirtualsEnabled(boolean v) {
        this.setBoolean(virtualsEnabled, v, null);
    }

    public BNiagaraFileDeviceExt getFiles() {
        return (BNiagaraFileDeviceExt)this.get(files);
    }

    public void setFiles(BNiagaraFileDeviceExt v) {
        this.set(files, (BValue)v, null);
    }

    public BOrd forceUpdateNiagaraProxyPoints() {
        return (BOrd)this.invoke(forceUpdateNiagaraProxyPoints, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BNiagaraStation() {
        this.getClientConnection().addConnectionTarget((FoxConnectionTarget)this);
    }

    public Type getNetworkType() {
        return BNiagaraNetwork.TYPE;
    }

    public BNiagaraNetwork getNiagaraNetwork() {
        for (BComplex parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof BNiagaraNetwork)) continue;
            return (BNiagaraNetwork)parent;
        }
        return null;
    }

    public IFuture postAsync(Runnable r) {
        return this.getWorker().postAsync(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BINiagaraDeviceExt[] getNiagaraDeviceExts() {
        if (this.exts == null) {
            BNiagaraStation bNiagaraStation = this;
            synchronized (bNiagaraStation) {
                Array temp = new Array(BINiagaraDeviceExt.class);
                SlotCursor c = this.getProperties();
                while (c.next(BINiagaraDeviceExt.class)) {
                    temp.add((Object)((BINiagaraDeviceExt)c.get()));
                }
                this.exts = (BINiagaraDeviceExt[])temp.trim();
            }
        }
        return this.exts;
    }

    public boolean getBootstrap() {
        Property bootstrapProp = this.getProperty(BOOTSTRAP_PROPERTY);
        if (bootstrapProp != null) {
            return this.getBoolean(bootstrapProp);
        }
        return false;
    }

    public void setBootstrap(boolean bootstrap) {
        Property bootstrapProp = this.getProperty(BOOTSTRAP_PROPERTY);
        if (bootstrapProp == null) {
            if (bootstrap) {
                this.add(BOOTSTRAP_PROPERTY, (BValue)BBoolean.make((boolean)bootstrap), 6);
            }
        } else if (bootstrap) {
            this.setBoolean(bootstrapProp, bootstrap);
        } else {
            this.remove(bootstrapProp);
        }
    }

    @Override
    public String getStationName() {
        return this.getName();
    }

    public BHost getRemoteHost() {
        return (BHost)this.getAddress().get();
    }

    public int getFoxPort() {
        return this.getClientConnection().getPort();
    }

    public String getScheme() {
        if (this.getClientConnection().getUseFoxs()) {
            return "foxs";
        }
        return "fox";
    }

    public void initHello(FoxMessage hello) throws Exception {
        BNiagaraNetwork network = this.getNiagaraNetwork();
        if (network != null) {
            BFoxService foxService = (BFoxService)Sys.getService((Type)BFoxService.TYPE);
            if (foxService.getFoxsEnabled()) {
                hello.add("foxServerPort", foxService.getFoxsPort().getBindingPort());
                hello.add("foxServerUseFoxs", true);
            } else {
                hello.add("foxServerPort", foxService.getFoxPort().getBindingPort());
            }
            hello.add("version", Sys.getBajaVersion().toString());
            hello.add("hostModel", Nre.getHostModel());
            hello.add("hostModelVersion", Nre.getHostModelVersion());
            hello.add("sysDefVersion", network.getType().getVendorVersion().toString());
        }
    }

    public void clientOpened() {
        try {
            FoxMessage hello = this.getClientConnection().session().getRemoteHello();
            this.setVersion(hello.getString("version", ""));
            this.setHostModel(hello.getString("hostModel", ""));
            this.setHostModelVersion(hello.getString("hostModelVersion", ""));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (BINiagaraDeviceExt devicelet : this.getNiagaraDeviceExts()) {
            try {
                devicelet.clientOpened();
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "clientOpened", e);
            }
        }
    }

    public void clientClosed() {
        for (BINiagaraDeviceExt devicelet : this.getNiagaraDeviceExts()) {
            try {
                devicelet.clientClosed();
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "clientClosed", e);
            }
        }
    }

    public void serverOpened() {
        for (BINiagaraDeviceExt devicelet : this.getNiagaraDeviceExts()) {
            try {
                devicelet.serverOpened();
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "serverOpened", e);
            }
        }
    }

    public void serverClosed() {
        for (BINiagaraDeviceExt devicelet : this.getNiagaraDeviceExts()) {
            try {
                devicelet.serverClosed();
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "serverClosed", e);
            }
        }
    }

    @Override
    public boolean isEngaged(String interest) {
        return this.getClientConnection().isEngaged(this.toInterest(interest));
    }

    @Override
    public void engageNoRetry(String interest) throws Exception {
        this.getClientConnection().engageNoRetry(this.toInterest(interest));
    }

    @Override
    public void engageNoRetry(String interest, long failFastPeriod) throws Exception {
        this.getClientConnection().engageNoRetry(this.toInterest(interest), failFastPeriod);
    }

    @Override
    public void engageRetry(String interest) throws Exception {
        this.getClientConnection().engageRetry(this.toInterest(interest));
    }

    @Override
    public void disengage(String interest) {
        this.getClientConnection().disengage(this.toInterest(interest));
    }

    @Override
    public BValue invokeAction(BOrd componentOrd, String actionName, BValue arg) throws Exception {
        return ((BPointChannel)this.getClientConnection().getChannels().get("point", BPointChannel.TYPE)).invoke(componentOrd.encodeToString(), actionName, arg);
    }

    private BFoxClientConnection.Interest toInterest(String s) {
        return new BFoxClientConnection.StringInterest(s);
    }

    public BFoxServerConnection getServerConnection() {
        if (this.serverConnection == null) {
            BOrd ord = this.getServerConnectionOrd();
            this.serverConnection = ord.isNull() ? null : (BFoxServerConnection)ord.get((BObject)this);
        }
        return this.serverConnection;
    }

    public void setServerConnection(BFoxServerConnection value) {
        if (this.serverConnection != null) {
            this.serverConnection.removeConnectionTarget((FoxConnectionTarget)this);
        }
        if (value == null) {
            this.serverConnection = null;
            this.setServerConnectionOrd(BOrd.NULL);
        } else {
            this.setServerConnectionOrd(value.getHandleOrd());
            this.serverConnection = value;
            this.serverConnection.addConnectionTarget((FoxConnectionTarget)this);
        }
    }

    private void configureFoxClientConnection() {
        if (!this.isRunning()) {
            return;
        }
        this.configureFoxClientConnection(this.getClientConnection());
    }

    public void configureFoxClientConnection(BFoxClientConnection clientConnection) {
        if (this.getBootstrap()) {
            SocketFactory factory;
            try {
                factory = CertManagerFactory.getInstance().getClientSocketFactory(ClientTlsParameters.DEFAULT);
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
            if (factory instanceof ExemptionHandler && factory instanceof SSLSocketFactory) {
                AccessController.doPrivileged(() -> {
                    ((ExemptionHandler)factory).setExemptionApprover((ExemptionApprover)new TransientExemptionApprover());
                    return null;
                });
                clientConnection.setSSLSocketFactory((SSLSocketFactory)factory);
            }
        } else {
            logger.fine(() -> String.format("Bootstrap has been turned off for station %s", this.getStationName()));
            clientConnection.setSSLSocketFactory(null);
            this.removeTransientExemption(clientConnection);
        }
    }

    private void removeTransientExemption(BFoxClientConnection clientConnection) {
        logger.fine(() -> String.format("Checking for transient exemptions for station %s", this.getStationName()));
        try {
            ISecurityInfoProvider provider = AccessController.doPrivileged(() -> SecurityInitializer.getInstance().getSecurityInfoProvider());
            ICoreExemptionStore exemptionStore = CoreCryptoManager.get((ISecurityInfoProvider)provider).getExemptionStore();
            BHost host = clientConnection.getRemoteHost();
            if (host != null) {
                String hostName = host.getHostname();
                ExemptionStoreUtil exemptionStoreUtil = new ExemptionStoreUtil(exemptionStore);
                exemptionStoreUtil.deleteExemptionsForHostname(hostName, true);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "bootstrap mode was turned off for station " + this.getStationName() + " but failed to remove transient exemptions", e);
        }
    }

    public void started() throws Exception {
        DefaultNiagaraVirtualStationAdapter stationAdapter = new DefaultNiagaraVirtualStationAdapter(this);
        this.getVirtual().setStationAdapter(stationAdapter);
        this.getVirtual().setCommsAdapter(new FoxNiagaraVirtualCommsAdapter(this.getClientConnection(), stationAdapter));
        BFoxService foxService = (BFoxService)Sys.getService((Type)BFoxService.TYPE);
        this.setServerConnection(foxService.makePersistentServerConnection("Station_" + this.getStationName()));
        if (this.getBootstrap()) {
            this.configureFoxClientConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void added(Property property, Context cx) {
        if (BOOTSTRAP_PROPERTY.equals(property.getName())) {
            this.configureFoxClientConnection();
        }
        BNiagaraStation bNiagaraStation = this;
        synchronized (bNiagaraStation) {
            this.exts = null;
        }
    }

    public void removed(Property property, BValue oldValue, Context context) {
        if (BOOTSTRAP_PROPERTY.equals(property.getName())) {
            this.configureFoxClientConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removed(Property property, Context cx) {
        BNiagaraStation bNiagaraStation = this;
        synchronized (bNiagaraStation) {
            this.exts = null;
        }
    }

    public void changed(Property property, Context context) {
        if (property == clientConnection) {
            this.getClientConnection().addConnectionTarget((FoxConnectionTarget)this);
            if (this.isRunning()) {
                this.configureFoxClientConnection();
            }
        }
        if (this.isRunning()) {
            if (BOOTSTRAP_PROPERTY.equals(property.getName())) {
                this.configureFoxClientConnection();
            }
            if (property == BDevice.status) {
                this.getVirtual().deviceStatusChanged();
            } else if (property == virtualsEnabled) {
                this.getVirtual().refresh();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IFuture postPing() {
        BFoxClientConnection.Interest interest = this.pingInterest;
        synchronized (interest) {
            if (!this.pingActive) {
                this.pingActive = true;
                return this.postAsync((Runnable)new Invocation((BComponent)this, ping, null, null));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPing() {
        block13: {
            try {
                BFoxClientConnection conn = this.getClientConnection();
                conn.setAuthenticationClient((AuthenticationClient)conn);
                if (this.getClientConnection().isConnected()) {
                    this.pingOk();
                }
                try {
                    conn.engageNoRetry(this.pingInterest, 0L);
                }
                catch (Exception exception) {
                    conn.disengage(this.pingInterest);
                    break block13;
                }
                catch (Throwable throwable) {
                    conn.disengage(this.pingInterest);
                    throw throwable;
                }
                conn.disengage(this.pingInterest);
            }
            finally {
                BFoxClientConnection.Interest interest = this.pingInterest;
                synchronized (interest) {
                    this.pingActive = false;
                }
            }
        }
    }

    public final boolean historyPollingEnabled() {
        return false;
    }

    public final int updateHistorySubscriptionCount(int change) {
        return 0;
    }

    @Override
    public List<BNiagaraProxyExt> getDescendantNiagaraProxyExts() {
        return this.getPoints().getDescendantNiagaraProxyExts();
    }

    public BOrd doForceUpdateNiagaraProxyPoints(Context cx) {
        return new BForceUpdateNiagaraPointsJob(this).submit(cx);
    }

    public BIcon getIcon() {
        if (this.getClientConnection().getUseFoxs()) {
            return secureIcon;
        }
        return icon;
    }

    static class PingInterest
    implements BFoxClientConnection.Interest {
        PingInterest() {
        }

        public String toString() {
            return "PingInterest";
        }
    }
}

