/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd;

import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.sys.station.BStationScheme;
import com.tridium.util.IFoxSession;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdQueryList;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnresolvedException;
import javax.baja.space.BComponentSpace;
import javax.baja.space.BSpace;
import javax.baja.space.BSpaceScheme;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BNSpaceScheme
extends BSpaceScheme {
    private static final NSpaceQuery QUERY = new NSpaceQuery("");
    public static final BNSpaceScheme INSTANCE = new BNSpaceScheme("nspace");
    public static final Type TYPE = Sys.loadType(BNSpaceScheme.class);

    private BNSpaceScheme(String schemeId) {
        super(schemeId);
    }

    public OrdQuery parse(String queryBody) {
        if (queryBody.isEmpty()) {
            return QUERY;
        }
        return new NSpaceQuery(queryBody);
    }

    public Type getSpaceType() {
        return BComponentSpace.TYPE;
    }

    protected String getNavChildSpaceId() {
        return BStationScheme.INSTANCE.getId();
    }

    public OrdTarget resolve(OrdTarget base, OrdQuery query, BSpace space) {
        String body = query.getBody();
        if (body.isEmpty()) {
            return new OrdTarget(base, (BObject)space);
        }
        BObject baseObj = base.get();
        BISession session = this.toSession(baseObj);
        boolean clientSide = session instanceof IFoxSession;
        String defaultStationName = clientSide ? ((IFoxSession)session).getStationName() : Sys.getStation().getStationName();
        if (body.equals(defaultStationName)) {
            return new OrdTarget(base, (BObject)space);
        }
        try {
            BNiagaraNetwork network = (BNiagaraNetwork)BOrd.make((String)"service:niagaraDriver:NiagaraNetwork").get(baseObj);
            BComponent station = clientSide ? BNSpaceScheme.findStation((BComponent)network, body, !network.isRunning()) : (BComponent)network.getStation(body);
            return new OrdTarget(base, BOrd.make((BOrd)station.getAbsoluteOrd(), (String)"slot:virtual|virtual:").get(baseObj));
        }
        catch (NullPointerException npe) {
            throw new UnresolvedException("Could not find active space for station " + body);
        }
        catch (Exception e) {
            throw new UnresolvedException("Could not find active space for station " + body, (Throwable)e);
        }
    }

    private static BComponent findStation(BComponent comp, String stationName, boolean lease) {
        if (lease) {
            comp.lease();
        }
        SlotCursor cursor = comp.getProperties();
        while (cursor.nextComponent()) {
            BComponent kid = cursor.get().asComponent();
            if (kid.getType().is(BNiagaraStation.TYPE)) {
                if (!stationName.equals(kid.getName())) continue;
                return kid;
            }
            BComponent station = BNSpaceScheme.findStation(kid, stationName, lease);
            if (station == null) continue;
            return station;
        }
        return null;
    }

    public Type getType() {
        return TYPE;
    }

    private static class NSpaceQuery
    implements OrdQuery {
        private final String body;

        public NSpaceQuery(String body) {
            this.body = body;
        }

        public boolean isHost() {
            return false;
        }

        public boolean isSession() {
            return false;
        }

        public void normalize(OrdQueryList list, int index) {
            list.shiftToSession(index);
        }

        public String getScheme() {
            return "nspace";
        }

        public String getBody() {
            return this.body;
        }

        public String toString() {
            return "nspace:" + this.body;
        }
    }
}

