/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.converters;

import javax.baja.agent.BIAgent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BConverter;

public final class BStringToNumber
extends BConverter
implements BIAgent {
    public static final Type TYPE = Sys.loadType(BStringToNumber.class);

    public Type getType() {
        return TYPE;
    }

    public BObject convert(BObject from, BObject to, Context cx) {
        String fromString = from.toString(cx);
        try {
            switch (to.getType().getDataTypeSymbol()) {
                case 'i': {
                    return BInteger.make((int)Integer.parseInt(fromString));
                }
                case 'l': {
                    return BLong.make((long)Long.parseLong(fromString));
                }
                case 'f': {
                    return BFloat.make((float)Float.parseFloat(fromString));
                }
                case 'd': {
                    return BDouble.make((double)Double.parseDouble(fromString));
                }
            }
            throw new IllegalStateException();
        }
        catch (NumberFormatException nfe) {
            switch (to.getType().getDataTypeSymbol()) {
                case 'i': 
                case 'l': {
                    return to;
                }
                case 'f': {
                    return BFloat.NaN;
                }
                case 'd': {
                    return BDouble.NaN;
                }
            }
            throw new IllegalStateException();
        }
    }
}

