/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.converters;

import javax.baja.agent.BIAgent;
import javax.baja.converters.BBooleanToDynamicEnum;
import javax.baja.status.BStatusBoolean;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.InvalidEnumException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BConverter;

public final class BStatusBooleanToFrozenEnum
extends BConverter
implements BIAgent {
    public static final Property trueOrdinal = BStatusBooleanToFrozenEnum.newProperty((int)0, (int)BBoolean.TRUE.getOrdinal(), (BFacets)BFacets.NULL);
    public static final Property falseOrdinal = BStatusBooleanToFrozenEnum.newProperty((int)0, (int)BBoolean.FALSE.getOrdinal(), (BFacets)BFacets.NULL);
    public static final Type TYPE = Sys.loadType(BStatusBooleanToFrozenEnum.class);

    public final int getTrueOrdinal() {
        return this.getInt(trueOrdinal);
    }

    public final void setTrueOrdinal(int trueValue) {
        this.setInt(BBooleanToDynamicEnum.trueOrdinal, trueValue, null);
    }

    public final int getFalseOrdinal() {
        return this.getInt(falseOrdinal);
    }

    public final void setFalseOrdinal(int falseValue) {
        this.setInt(BBooleanToDynamicEnum.falseOrdinal, falseValue, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BObject convert(BObject from, BObject to, Context cx) {
        BStatusBoolean statusBoolean = (BStatusBoolean)from;
        if (statusBoolean.getStatus().isNull()) {
            return to;
        }
        try {
            if (statusBoolean.getValue()) {
                return ((BFrozenEnum)to).getRange().get(this.getTrueOrdinal(), false);
            }
            return ((BFrozenEnum)to).getRange().get(this.getFalseOrdinal(), false);
        }
        catch (InvalidEnumException iee) {
            return to;
        }
    }
}

